/*
 * Decompiled with CFR 0.152.
 */
package vminus.shadow.org.gagravarr.theora;

import vminus.shadow.org.gagravarr.ogg.HighLevelOggStreamPacket;
import vminus.shadow.org.gagravarr.ogg.IOUtils;
import vminus.shadow.org.gagravarr.ogg.OggPacket;
import vminus.shadow.org.gagravarr.theora.TheoraComments;
import vminus.shadow.org.gagravarr.theora.TheoraInfo;
import vminus.shadow.org.gagravarr.theora.TheoraPacket;
import vminus.shadow.org.gagravarr.theora.TheoraSetup;
import vminus.shadow.org.gagravarr.theora.TheoraVideoData;

public class TheoraPacketFactory
extends HighLevelOggStreamPacket {
    protected static void populateMetadataHeader(byte[] b, int type, int dataLength) {
        b[0] = IOUtils.fromInt(type);
        b[1] = 116;
        b[2] = 104;
        b[3] = 101;
        b[4] = 111;
        b[5] = 114;
        b[6] = 97;
    }

    public static boolean isTheoraStream(OggPacket firstPacket) {
        if (!firstPacket.isBeginningOfStream()) {
            return false;
        }
        return TheoraPacketFactory.isTheoraSpecial(firstPacket);
    }

    protected static boolean isTheoraSpecial(OggPacket packet) {
        byte[] d = packet.getData();
        if (d.length < 16) {
            return false;
        }
        byte type = d[0];
        return (type == -128 || type == -127 || type == -126) && d[1] == 116 && d[2] == 104 && d[3] == 101 && d[4] == 111 && d[5] == 114 && d[6] == 97;
    }

    public static TheoraPacket create(OggPacket packet) {
        byte type = packet.getData()[0];
        if (TheoraPacketFactory.isTheoraSpecial(packet)) {
            switch (type) {
                case -128: {
                    return new TheoraInfo(packet);
                }
                case -127: {
                    return new TheoraComments(packet);
                }
                case -126: {
                    return new TheoraSetup(packet);
                }
            }
        }
        return new TheoraVideoData(packet);
    }
}

