/*
 * Decompiled with CFR 0.152.
 */
package vminus.shadow.org.gagravarr.speex;

import vminus.shadow.org.gagravarr.ogg.HighLevelOggStreamPacket;
import vminus.shadow.org.gagravarr.ogg.IOUtils;
import vminus.shadow.org.gagravarr.ogg.OggPacket;
import vminus.shadow.org.gagravarr.speex.SpeexAudioData;
import vminus.shadow.org.gagravarr.speex.SpeexInfo;
import vminus.shadow.org.gagravarr.speex.SpeexPacket;
import vminus.shadow.org.gagravarr.speex.SpeexTags;

public class SpeexPacketFactory
extends HighLevelOggStreamPacket {
    public static boolean isSpeexStream(OggPacket firstPacket) {
        if (!firstPacket.isBeginningOfStream()) {
            return false;
        }
        return SpeexPacketFactory.isSpeexSpecial(firstPacket);
    }

    protected static boolean isSpeexSpecial(OggPacket packet) {
        byte[] d = packet.getData();
        if (d.length < 72) {
            return false;
        }
        return IOUtils.byteRangeMatches(SpeexPacket.MAGIC_HEADER_BYTES, d, 0);
    }

    public static SpeexPacket create(OggPacket packet) {
        if (SpeexPacketFactory.isSpeexSpecial(packet)) {
            return new SpeexInfo(packet);
        }
        if (packet.getSequenceNumber() == 1 && packet.getGranulePosition() == 0L) {
            return new SpeexTags(packet);
        }
        return new SpeexAudioData(packet);
    }
}

