/*
 * Decompiled with CFR 0.152.
 */
package vminus.shadow.org.gagravarr.skeleton;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import vminus.shadow.org.gagravarr.ogg.OggPacket;
import vminus.shadow.org.gagravarr.skeleton.SkeletonFisbone;
import vminus.shadow.org.gagravarr.skeleton.SkeletonFishead;
import vminus.shadow.org.gagravarr.skeleton.SkeletonKeyFramePacket;
import vminus.shadow.org.gagravarr.skeleton.SkeletonPacket;
import vminus.shadow.org.gagravarr.skeleton.SkeletonPacketFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SkeletonStream {
    private int sid = -1;
    private boolean hasWholeStream;
    private SkeletonFishead fishead;
    private List<SkeletonFisbone> fisbones;
    private Map<Integer, SkeletonFisbone> bonesByStream;
    private List<SkeletonKeyFramePacket> keyFrames;

    public SkeletonStream(OggPacket packet) {
        this.sid = packet.getSid();
        this.hasWholeStream = false;
        this.fisbones = new ArrayList<SkeletonFisbone>();
        this.bonesByStream = new HashMap<Integer, SkeletonFisbone>();
        this.keyFrames = new ArrayList<SkeletonKeyFramePacket>();
        this.processPacket(packet);
    }

    public SkeletonStream(int[] sids) {
        this.fishead = new SkeletonFishead();
        for (int sid : sids) {
            this.addBoneForStream(sid);
        }
    }

    public void processPacket(OggPacket packet) {
        SkeletonPacket skel = SkeletonPacketFactory.create(packet);
        if (packet.isBeginningOfStream()) {
            this.fishead = (SkeletonFishead)skel;
        } else if (skel instanceof SkeletonFisbone) {
            SkeletonFisbone bone = (SkeletonFisbone)skel;
            this.fisbones.add(bone);
            this.bonesByStream.put(bone.getSerialNumber(), bone);
        } else if (skel instanceof SkeletonKeyFramePacket) {
            this.keyFrames.add((SkeletonKeyFramePacket)skel);
        } else {
            throw new IllegalStateException("Unexpected Skeleton " + skel);
        }
        if (packet.isEndOfStream()) {
            this.hasWholeStream = true;
        }
    }

    public int getSid() {
        return this.sid;
    }

    public boolean hasWholeStream() {
        return this.hasWholeStream;
    }

    public SkeletonFishead getFishead() {
        return this.fishead;
    }

    public List<SkeletonFisbone> getFisbones() {
        return this.fisbones;
    }

    public SkeletonFisbone getBoneForStream(int sid) {
        return this.bonesByStream.get(sid);
    }

    public SkeletonFisbone addBoneForStream(int sid) {
        SkeletonFisbone bone = new SkeletonFisbone();
        bone.setSerialNumber(sid);
        this.fisbones.add(bone);
        if (sid == -1 || this.bonesByStream.containsKey(sid)) {
            throw new IllegalArgumentException("Invalid / duplicate sid " + sid);
        }
        this.bonesByStream.put(sid, bone);
        return bone;
    }

    public List<SkeletonKeyFramePacket> getKeyFrames() {
        return this.keyFrames;
    }
}

