/*
 * Decompiled with CFR 0.152.
 */
package vminus.shadow.org.gagravarr.flac;

import java.io.IOException;
import java.io.OutputStream;
import vminus.shadow.org.gagravarr.flac.FlacMetadataBlock;
import vminus.shadow.org.gagravarr.ogg.IOUtils;
import vminus.shadow.org.gagravarr.ogg.OggPacket;
import vminus.shadow.org.gagravarr.ogg.audio.OggAudioTagsHeader;
import vminus.shadow.org.gagravarr.vorbis.VorbisStyleComments;

public class FlacTags
extends VorbisStyleComments
implements OggAudioTagsHeader {
    public FlacTags(OggPacket packet) {
        super(packet, 4);
        byte type = this.getData()[0];
        if (type != 4) {
            throw new IllegalArgumentException("Invalid type " + type);
        }
    }

    public FlacTags() {
    }

    public int getHeaderSize() {
        return 4;
    }

    protected boolean hasFramingBit() {
        return false;
    }

    public void populateMetadataHeader(byte[] b, int dataLength) {
        b[0] = 4;
        IOUtils.putInt3BE(b, 1, dataLength);
    }

    protected void populateMetadataFooter(OutputStream out) {
    }

    protected static class FlacTagsAsMetadata
    extends FlacMetadataBlock {
        private FlacTags tags;

        protected FlacTagsAsMetadata(byte[] data) {
            super((byte)4);
            byte[] d = new byte[data.length + 4];
            d[0] = 4;
            System.arraycopy(data, 0, d, 4, data.length);
            this.tags = new FlacTags(new OggPacket(d));
        }

        public byte[] getData() {
            return this.tags.getData();
        }

        protected void write(OutputStream out) throws IOException {
            throw new IllegalStateException("Must not call directly");
        }

        public FlacTags getTags() {
            return this.tags;
        }
    }
}

