/*
 * Decompiled with CFR 0.152.
 */
package vminus.shadow.org.gagravarr.flac;

import java.io.IOException;
import vminus.shadow.org.gagravarr.flac.FlacAudioFrame;
import vminus.shadow.org.gagravarr.ogg.BitsReader;

public abstract class FlacAudioSubFrame {
    protected final FlacAudioFrame audioFrame;
    protected final int predictorOrder;
    protected final int sampleSizeBits;
    protected final int blockSize;
    private int wastedBits;

    public static FlacAudioSubFrame create(int type, int channelNumber, int wastedBits, FlacAudioFrame audioFrame, BitsReader data) throws IOException {
        if (type < 0 || type >= 64) {
            throw new IllegalArgumentException("Type must be a un-signed 6 bit number, found " + type);
        }
        FlacAudioSubFrame subFrame = SubFrameConstant.matchesType(type) ? new SubFrameConstant(channelNumber, audioFrame, data) : (SubFrameVerbatim.matchesType(type) ? new SubFrameVerbatim(channelNumber, audioFrame, data) : (SubFrameFixed.matchesType(type) ? new SubFrameFixed(type, channelNumber, audioFrame, data) : (SubFrameLPC.matchesType(type) ? new SubFrameLPC(type, channelNumber, audioFrame, data) : new SubFrameReserved(audioFrame))));
        subFrame.wastedBits = wastedBits;
        return subFrame;
    }

    protected FlacAudioSubFrame(int predictorOrder, int channelNumber, FlacAudioFrame audioFrame) {
        this.predictorOrder = predictorOrder;
        this.audioFrame = audioFrame;
        this.blockSize = audioFrame.getBlockSize();
        int sampleSizeBits = audioFrame.getBitsPerSample();
        if (audioFrame.getChannelType() == 9 && channelNumber == 1) {
            ++sampleSizeBits;
        }
        if (audioFrame.getChannelType() == 10 && channelNumber == 0) {
            ++sampleSizeBits;
        }
        if (audioFrame.getChannelType() == 11 && channelNumber == 1) {
            ++sampleSizeBits;
        }
        this.sampleSizeBits = sampleSizeBits;
    }

    public int getWastedBits() {
        return this.wastedBits;
    }

    public int getPredictorOrder() {
        return this.predictorOrder;
    }

    public int getSampleSizeBits() {
        return this.sampleSizeBits;
    }

    public int getBlockSize() {
        return this.blockSize;
    }

    public abstract String getType();

    protected SubFrameResidual createResidual(BitsReader data) throws IOException {
        int type = data.read(2);
        if (type > 1) {
            return null;
        }
        int partitionOrder = data.read(4);
        if (type == 0) {
            return new SubFrameResidualRice(partitionOrder, data);
        }
        return new SubFrameResidualRice2(partitionOrder, data);
    }

    public class SubFrameResidualRice2
    extends SubFrameResidual {
        private static final int PARAM_BITS = 5;
        private static final int ESCAPE_CODE = 31;

        public SubFrameResidualRice2(int partitionOrder, BitsReader data) throws IOException {
            super(partitionOrder, 5, 31, data);
        }

        public String getType() {
            return "RICE2";
        }
    }

    public class SubFrameResidualRice
    extends SubFrameResidual {
        private static final int PARAM_BITS = 4;
        private static final int ESCAPE_CODE = 15;

        public SubFrameResidualRice(int partitionOrder, BitsReader data) throws IOException {
            super(partitionOrder, 4, 15, data);
        }

        public String getType() {
            return "RICE";
        }
    }

    public class SubFrameResidual {
        protected final int partitionOrder;
        protected final int numPartitions;
        protected final int[] riceParams;

        private SubFrameResidual(int partitionOrder, int bits, int escapeCode, BitsReader data) throws IOException {
            this.partitionOrder = partitionOrder;
            this.numPartitions = 1 << partitionOrder;
            this.riceParams = new int[this.numPartitions];
            int numSamples = 0;
            numSamples = partitionOrder > 0 ? FlacAudioSubFrame.this.blockSize >> partitionOrder : FlacAudioSubFrame.this.blockSize - FlacAudioSubFrame.this.predictorOrder;
            for (int pn = 0; pn < this.numPartitions; ++pn) {
                int riceParam = data.read(bits);
                int partitionSamples = 0;
                partitionSamples = partitionOrder == 0 || pn > 0 ? numSamples : numSamples - FlacAudioSubFrame.this.predictorOrder;
                if (riceParam == escapeCode) {
                    riceParam = data.read(5);
                    for (int i = 0; i < partitionSamples; ++i) {
                        data.read(riceParam);
                    }
                } else {
                    for (int sn = 0; sn < numSamples; ++sn) {
                        data.bitsToNextOne();
                        data.read(riceParam);
                    }
                }
                this.riceParams[pn] = riceParam;
            }
        }

        public int getPartitionOrder() {
            return this.partitionOrder;
        }

        public int getNumPartitions() {
            return this.numPartitions;
        }

        public int[] getRiceParams() {
            return this.riceParams;
        }

        public String getType() {
            return "UNKNOWN";
        }
    }

    public static class SubFrameReserved
    extends FlacAudioSubFrame {
        public static boolean matchesType(int type) {
            if (type >= 2 && type <= 7) {
                return true;
            }
            return type >= 16 && type <= 31;
        }

        private SubFrameReserved(FlacAudioFrame audioFrame) {
            super(-1, -1, audioFrame);
        }

        public String getType() {
            return "RESERVED";
        }
    }

    public static class SubFrameLPC
    extends SubFrameWithResidual {
        protected final int linearPredictorCoefficientPrecision;
        protected final int linearPredictorCoefficientShift;
        protected final int[] coefficients;

        protected SubFrameLPC(int type, int channelNumber, FlacAudioFrame audioFrame, BitsReader data) throws IOException {
            super((type & 0x1F) + 1, channelNumber, audioFrame);
            int i;
            this.warmUpSamples = new int[this.predictorOrder];
            for (i = 0; i < this.predictorOrder; ++i) {
                this.warmUpSamples[i] = data.read(this.sampleSizeBits);
            }
            this.linearPredictorCoefficientPrecision = data.read(4) + 1;
            this.linearPredictorCoefficientShift = data.read(5);
            this.coefficients = new int[this.predictorOrder];
            for (i = 0; i < this.predictorOrder; ++i) {
                this.coefficients[i] = data.read(this.linearPredictorCoefficientPrecision);
            }
            this.residual = this.createResidual(data);
        }

        public static boolean matchesType(int type) {
            return type >= 32;
        }

        public int getLinearPredictorCoefficientPrecision() {
            return this.linearPredictorCoefficientPrecision;
        }

        public int getLinearPredictorCoefficientShift() {
            return this.linearPredictorCoefficientShift;
        }

        public int[] getCoefficients() {
            return this.coefficients;
        }

        public String getType() {
            return "LPC";
        }
    }

    public static class SubFrameFixed
    extends SubFrameWithResidual {
        protected SubFrameFixed(int type, int channelNumber, FlacAudioFrame audioFrame, BitsReader data) throws IOException {
            super(type & 7, channelNumber, audioFrame);
            this.warmUpSamples = new int[this.predictorOrder];
            for (int i = 0; i < this.predictorOrder; ++i) {
                this.warmUpSamples[i] = data.read(this.sampleSizeBits);
            }
            this.residual = this.createResidual(data);
        }

        public static boolean matchesType(int type) {
            return type >= 8 && type <= 15;
        }

        public String getType() {
            return "FIXED";
        }
    }

    public static class SubFrameWithResidual
    extends FlacAudioSubFrame {
        protected int[] warmUpSamples;
        protected SubFrameResidual residual;

        protected SubFrameWithResidual(int predictorOrder, int channelNumber, FlacAudioFrame audioFrame) {
            super(predictorOrder, channelNumber, audioFrame);
        }

        public SubFrameResidual getResidual() {
            return this.residual;
        }

        public int[] getWarmUpSamples() {
            return this.warmUpSamples;
        }

        public String getType() {
            return "UNKNOWN";
        }
    }

    public static class SubFrameVerbatim
    extends FlacAudioSubFrame {
        protected SubFrameVerbatim(int channelNumber, FlacAudioFrame audioFrame, BitsReader data) throws IOException {
            super(-1, channelNumber, audioFrame);
            for (int i = 0; i < this.blockSize; ++i) {
                data.read(this.sampleSizeBits);
            }
        }

        public static boolean matchesType(int type) {
            return type == 1;
        }

        public String getType() {
            return "VERBATIM";
        }
    }

    public static class SubFrameConstant
    extends FlacAudioSubFrame {
        protected SubFrameConstant(int channelNumber, FlacAudioFrame audioFrame, BitsReader data) throws IOException {
            super(-1, channelNumber, audioFrame);
            data.read(this.sampleSizeBits);
        }

        public static boolean matchesType(int type) {
            return type == 0;
        }

        public String getType() {
            return "CONSTANT";
        }
    }
}

