/*
 * Decompiled with CFR 0.152.
 */
package net.lixir.vminus.vision.values.conditions;

import javax.annotation.Nullable;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;

public class VisionContext {
    private Item item = null;
    private ItemStack itemStack = null;
    private Entity entity = null;
    private Block block = null;
    private BlockBehaviour.BlockStateBase blockStateBase = null;
    private BlockState blockState = null;
    private MobEffect mobEffect = null;
    private EntityType<?> entityType = null;

    private VisionContext(Builder builder) {
        this.item = builder.item;
        this.entity = builder.entity;
        this.itemStack = builder.itemStack;
        this.block = builder.block;
        this.blockStateBase = builder.blockStateBase;
        this.blockState = builder.blockState;
    }

    public VisionContext(@Nullable ItemEntity itemEntity) {
        if (itemEntity == null) {
            return;
        }
        this.itemStack = itemEntity.m_32055_();
        this.item = this.itemStack.m_41720_();
    }

    public VisionContext(@Nullable ItemStack itemStack) {
        if (itemStack == null) {
            return;
        }
        this.item = itemStack.m_41720_();
        this.itemStack = itemStack;
    }

    public VisionContext(Item item) {
        this.item = item;
    }

    public VisionContext(MobEffect mobEffect) {
        this.mobEffect = mobEffect;
    }

    public VisionContext(EntityType<?> entityType) {
        this.entityType = entityType;
    }

    public VisionContext(Entity entity) {
        this.entity = entity;
        this.entityType = entity.m_6095_();
    }

    public VisionContext(Block block) {
        this.block = block;
    }

    public VisionContext(BlockBehaviour.BlockStateBase blockStateBase) {
        this.blockStateBase = blockStateBase;
    }

    public boolean hasItem() {
        return this.item != null;
    }

    public boolean hasItemStack() {
        return this.itemStack != null;
    }

    public boolean hasEntity() {
        return this.entity != null;
    }

    @Nullable
    public Item getItem() {
        return this.item;
    }

    @Nullable
    public ItemStack getItemStack() {
        return this.itemStack;
    }

    @Nullable
    public EntityType<?> getEntityType() {
        return this.entityType;
    }

    @Nullable
    public Entity getEntity() {
        return this.entity;
    }

    @Nullable
    public Block getBlock() {
        return this.block;
    }

    @Nullable
    public BlockState getBlockState() {
        return this.blockState;
    }

    @Nullable
    public BlockBehaviour.BlockStateBase getBlockStateBase() {
        return this.blockStateBase;
    }

    public static class Builder {
        private Item item = null;
        private Block block = null;
        private Entity entity = null;
        private ItemStack itemStack = null;
        private BlockBehaviour.BlockStateBase blockStateBase = null;
        private BlockState blockState = null;

        public Builder pass(Item item) {
            this.item = item;
            return this;
        }

        public Builder pass(ItemStack itemStack) {
            this.itemStack = itemStack;
            if (this.item == null) {
                this.item = itemStack.m_41720_();
            }
            return this;
        }

        public Builder pass(Entity entity) {
            this.entity = entity;
            return this;
        }

        public Builder pass(Block block) {
            this.block = block;
            if (this.item == null) {
                this.item = block.m_5456_();
            }
            return this;
        }

        public Builder pass(BlockState blockState) {
            this.blockState = blockState;
            if (this.block == null) {
                this.block = blockState.m_60734_();
            }
            if (this.item == null) {
                this.item = this.block.m_5456_();
            }
            return this;
        }

        public Builder pass(BlockBehaviour.BlockStateBase blockStateBase) {
            this.blockStateBase = blockStateBase;
            if (this.block == null) {
                this.block = blockStateBase.m_60734_();
            }
            if (this.item == null) {
                this.item = this.block.m_5456_();
            }
            return this;
        }

        public VisionContext build() {
            return new VisionContext(this);
        }
    }
}

