/*
 * Decompiled with CFR 0.152.
 */
package net.lixir.vminus.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.Map;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.ShortTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import org.jetbrains.annotations.NotNull;

public class NbtConversionUtil {
    @NotNull
    public static JsonObject compoundToJson(@NotNull CompoundTag tag) {
        JsonObject json = new JsonObject();
        for (String key : tag.m_128431_()) {
            Tag nbt = tag.m_128423_(key);
            if (nbt instanceof CompoundTag) {
                CompoundTag nested = (CompoundTag)nbt;
                json.add(key, (JsonElement)NbtConversionUtil.compoundToJson(nested));
                continue;
            }
            if (nbt instanceof ListTag) {
                ListTag list = (ListTag)nbt;
                JsonArray array = new JsonArray();
                for (Tag item : list) {
                    if (item instanceof CompoundTag) {
                        CompoundTag ct = (CompoundTag)item;
                        array.add((JsonElement)NbtConversionUtil.compoundToJson(ct));
                        continue;
                    }
                    if (!(item instanceof StringTag)) continue;
                    StringTag st = (StringTag)item;
                    array.add((JsonElement)new JsonPrimitive(st.m_7916_()));
                }
                json.add(key, (JsonElement)array);
                continue;
            }
            if (nbt instanceof IntTag) {
                IntTag i = (IntTag)nbt;
                json.addProperty(key, (Number)i.m_7047_());
                continue;
            }
            if (nbt instanceof ByteTag) {
                ByteTag b = (ByteTag)nbt;
                byte val = b.m_7063_();
                if (val == 0 || val == 1) {
                    json.addProperty(key, Boolean.valueOf(val == 1));
                    continue;
                }
                json.addProperty(key, (Number)val);
                continue;
            }
            if (nbt instanceof ShortTag) {
                ShortTag s = (ShortTag)nbt;
                json.addProperty(key, (Number)s.m_7053_());
                continue;
            }
            if (nbt instanceof LongTag) {
                LongTag l = (LongTag)nbt;
                json.addProperty(key, (Number)l.m_7046_());
                continue;
            }
            if (nbt instanceof FloatTag) {
                FloatTag f = (FloatTag)nbt;
                json.addProperty(key, (Number)Float.valueOf(f.m_7057_()));
                continue;
            }
            if (nbt instanceof DoubleTag) {
                DoubleTag d = (DoubleTag)nbt;
                json.addProperty(key, (Number)d.m_7061_());
                continue;
            }
            if (nbt instanceof StringTag) {
                StringTag st = (StringTag)nbt;
                json.addProperty(key, st.m_7916_());
                continue;
            }
            json.addProperty(key, nbt.m_7916_());
        }
        return json;
    }

    @NotNull
    public static CompoundTag jsonToCompound(@NotNull JsonObject json) {
        CompoundTag tag = new CompoundTag();
        for (Map.Entry entry : json.entrySet()) {
            String key = (String)entry.getKey();
            JsonElement value = (JsonElement)entry.getValue();
            if (value.isJsonPrimitive()) {
                JsonPrimitive primitive = value.getAsJsonPrimitive();
                if (primitive.isBoolean()) {
                    tag.m_128379_(key, primitive.getAsBoolean());
                    continue;
                }
                if (primitive.isNumber()) {
                    Number num = primitive.getAsNumber();
                    if (primitive.getAsString().endsWith("b")) {
                        tag.m_128344_(key, num.byteValue());
                        continue;
                    }
                    if (primitive.getAsString().endsWith("s")) {
                        tag.m_128376_(key, num.shortValue());
                        continue;
                    }
                    if (primitive.getAsString().endsWith("f")) {
                        tag.m_128350_(key, num.floatValue());
                        continue;
                    }
                    if (primitive.getAsString().endsWith("L") || primitive.getAsString().endsWith("l")) {
                        tag.m_128356_(key, num.longValue());
                        continue;
                    }
                    if (num.doubleValue() == (double)num.intValue()) {
                        tag.m_128405_(key, num.intValue());
                        continue;
                    }
                    tag.m_128347_(key, num.doubleValue());
                    continue;
                }
                tag.m_128359_(key, primitive.getAsString());
                continue;
            }
            if (value.isJsonObject()) {
                tag.m_128365_(key, (Tag)NbtConversionUtil.jsonToCompound(value.getAsJsonObject()));
                continue;
            }
            if (!value.isJsonArray()) continue;
            JsonArray array = value.getAsJsonArray();
            ListTag list = new ListTag();
            for (JsonElement e : array) {
                if (e.isJsonPrimitive()) {
                    list.add((Object)StringTag.m_129297_((String)e.getAsJsonPrimitive().getAsString()));
                    continue;
                }
                if (!e.isJsonObject()) continue;
                list.add((Object)NbtConversionUtil.jsonToCompound(e.getAsJsonObject()));
            }
            tag.m_128365_(key, (Tag)list);
        }
        return tag;
    }
}

