/*
 * Decompiled with CFR 0.152.
 */
package net.lixir.vminus.roles;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import org.jetbrains.annotations.NotNull;

public class RoleSavedData
extends SavedData {
    private final Map<UUID, String> playerRoles = new HashMap<UUID, String>();

    @NotNull
    public static RoleSavedData load(@NotNull CompoundTag tag) {
        RoleSavedData data = new RoleSavedData();
        ListTag list = tag.m_128437_("Roles", 10);
        for (Tag t : list) {
            CompoundTag entry = (CompoundTag)t;
            data.playerRoles.put(UUID.fromString(entry.m_128461_("UUID")), entry.m_128461_("Role"));
        }
        return data;
    }

    public void removeRole(@NotNull ServerPlayer player) {
        this.playerRoles.remove(player.m_20148_());
        this.m_77762_();
    }

    @NotNull
    public CompoundTag m_7176_(@NotNull CompoundTag tag) {
        ListTag list = new ListTag();
        for (Map.Entry<UUID, String> e : this.playerRoles.entrySet()) {
            CompoundTag entry = new CompoundTag();
            entry.m_128359_("UUID", e.getKey().toString());
            entry.m_128359_("Role", e.getValue());
            list.add((Object)entry);
        }
        tag.m_128365_("Roles", (Tag)list);
        return tag;
    }

    public void setRole(@NotNull ServerPlayer player, String role) {
        this.playerRoles.put(player.m_20148_(), role);
        this.m_77762_();
    }

    public String getRole(UUID uuid) {
        return this.playerRoles.getOrDefault(uuid, "");
    }

    @NotNull
    public static RoleSavedData get(@NotNull Level level) {
        return (RoleSavedData)level.m_7654_().m_129783_().m_8895_().m_164861_(RoleSavedData::load, RoleSavedData::new, "player_roles");
    }
}

