/*
 * Decompiled with CFR 0.152.
 */
package net.lixir.vminus.resources.data.vision.codec;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.ArrayList;
import java.util.List;
import net.lixir.vminus.registry.VMinusRarities;
import net.lixir.vminus.resources.data.vision.codec.VisionEnumCodec;
import net.lixir.vminus.vision.values.VisionValue;
import net.minecraft.world.item.Rarity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VisionRarityCodec
extends VisionEnumCodec<Rarity> {
    public VisionRarityCodec() {
        super(Rarity.class);
    }

    @Override
    @Nullable
    public List<VisionValue<Rarity>> decode(@NotNull JsonObject jsonObject, String key) throws JsonParseException {
        ArrayList<VisionValue<Rarity>> visionProperties = new ArrayList<VisionValue<Rarity>>();
        JsonArray jsonArray = jsonObject.getAsJsonArray(key);
        for (JsonElement jsonArrayElement : jsonArray) {
            Rarity value;
            JsonObject arrayObject = jsonArrayElement.getAsJsonObject();
            String rarityString = arrayObject.getAsJsonPrimitive("value").getAsString();
            switch (rarityString.toUpperCase()) {
                case "LEGENDARY": {
                    value = VMinusRarities.LEGENDARY;
                    break;
                }
                case "INVERTED": {
                    value = VMinusRarities.INVERTED;
                    break;
                }
                case "UNOBTAINABLE": {
                    value = VMinusRarities.UNOBTAINABLE;
                    break;
                }
                case "DELICACY": {
                    value = VMinusRarities.DELICACY;
                    break;
                }
                default: {
                    try {
                        value = Rarity.valueOf((String)rarityString.toUpperCase());
                        break;
                    }
                    catch (IllegalArgumentException e) {
                        throw new JsonParseException(rarityString + " is not a valid rarity for " + key);
                    }
                }
            }
            visionProperties.add(VisionValue.create(value, arrayObject, jsonObject, key));
        }
        return visionProperties;
    }
}

