/*
 * Decompiled with CFR 0.152.
 */
package net.lixir.vminus.resources.data.vision.codec;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.ArrayList;
import java.util.List;
import net.lixir.vminus.VMinus;
import net.lixir.vminus.resources.data.vision.codec.VisionCodec;
import net.lixir.vminus.util.NumberRange;
import net.lixir.vminus.vision.values.VisionValue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VisionIntegerNumberRangeCodec
extends VisionCodec<NumberRange<Integer>> {
    @Override
    public Class<NumberRange<Integer>> getClassType() {
        return NumberRange.class;
    }

    @Override
    @Nullable
    public List<VisionValue<NumberRange<Integer>>> decode(@NotNull JsonObject jsonObject, String key) throws JsonParseException {
        ArrayList<VisionValue<NumberRange<Integer>>> visionProperties = new ArrayList<VisionValue<NumberRange<Integer>>>();
        JsonArray jsonArray = jsonObject.getAsJsonArray(key);
        for (JsonElement jsonArrayElement : jsonArray) {
            int max;
            int min;
            JsonObject arrayObject = jsonArrayElement.getAsJsonObject();
            try {
                min = arrayObject.getAsJsonPrimitive("min").getAsInt();
                max = arrayObject.getAsJsonPrimitive("max").getAsInt();
            }
            catch (Exception e) {
                VMinus.LOGGER.error("Failed parsing range in: {}", (Object)jsonObject);
                throw new JsonParseException((Throwable)e);
            }
            NumberRange<Integer> numberRange = new NumberRange<Integer>(min, max);
            visionProperties.add(VisionValue.create(numberRange, arrayObject, jsonObject, key));
        }
        return visionProperties;
    }

    @Override
    @Nullable
    public JsonObject encode(@NotNull NumberRange<Integer> numberRange) {
        JsonObject obj = new JsonObject();
        obj.addProperty("min", (Number)numberRange.min());
        obj.addProperty("max", (Number)numberRange.max());
        return obj;
    }
}

