/*
 * Decompiled with CFR 0.152.
 */
package net.lixir.vminus.resources.data.vision.codec;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.List;
import net.lixir.vminus.resources.data.vision.codec.VisionCodec;
import net.lixir.vminus.vision.values.VisionValue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VisionDoubleCodec
extends VisionCodec<Double> {
    @Override
    public Class<Double> getClassType() {
        return Double.class;
    }

    @Override
    @Nullable
    public List<VisionValue<Double>> decode(@NotNull JsonObject jsonObject, String key) throws JsonParseException {
        ArrayList<VisionValue<Double>> visionProperties = new ArrayList<VisionValue<Double>>();
        JsonArray jsonArray = jsonObject.getAsJsonArray(key);
        for (JsonElement jsonArrayElement : jsonArray) {
            JsonObject arrayObject = jsonArrayElement.getAsJsonObject();
            double value = arrayObject.getAsJsonPrimitive("value").getAsDouble();
            visionProperties.add(VisionValue.create(value, arrayObject, jsonObject, key));
        }
        return visionProperties;
    }

    @Override
    @Nullable
    public JsonObject encode(@NotNull Double value) {
        JsonPrimitive jsonPrimitive = new JsonPrimitive((Number)value);
        JsonObject jsonObject = new JsonObject();
        jsonObject.add("value", (JsonElement)jsonPrimitive);
        return jsonObject;
    }
}

