/*
 * Decompiled with CFR 0.152.
 */
package net.lixir.vminus.resources.data.vision.codec;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.ArrayList;
import java.util.List;
import net.lixir.vminus.resources.data.vision.codec.VisionCodec;
import net.lixir.vminus.vision.util.BaseAttribute;
import net.lixir.vminus.vision.values.VisionValue;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VisionBaseAttributeCodec
extends VisionCodec<BaseAttribute> {
    @Override
    public Class<BaseAttribute> getClassType() {
        return BaseAttribute.class;
    }

    @Override
    @Nullable
    public List<VisionValue<BaseAttribute>> decode(@NotNull JsonObject jsonObject, String key) throws JsonParseException {
        ArrayList<VisionValue<BaseAttribute>> visionProperties = new ArrayList<VisionValue<BaseAttribute>>();
        JsonArray jsonArray = jsonObject.getAsJsonArray(key);
        if (jsonArray == null) {
            throw new JsonParseException("Expected a JSON array for key: " + key);
        }
        for (JsonElement jsonArrayElement : jsonArray) {
            double value;
            if (!jsonArrayElement.isJsonObject()) {
                throw new JsonParseException("Expected a JSON object inside array for key: " + key);
            }
            JsonObject arrayObject = jsonArrayElement.getAsJsonObject();
            try {
                value = arrayObject.getAsJsonPrimitive("value").getAsDouble();
            }
            catch (Exception e) {
                throw new JsonParseException("Missing or invalid 'value' for key: " + key, (Throwable)e);
            }
            ResourceLocation resourceLocation = VisionBaseAttributeCodec.parseResourceLocation("id", key, arrayObject);
            Attribute attribute = (Attribute)ForgeRegistries.ATTRIBUTES.getValue(resourceLocation);
            if (attribute == null) {
                throw new JsonParseException("Invalid attribute id for key '" + key + "': " + resourceLocation);
            }
            BaseAttribute baseAttribute = new BaseAttribute(value, attribute);
            visionProperties.add(VisionValue.create(baseAttribute, arrayObject, jsonObject, key));
        }
        return visionProperties;
    }

    @Override
    @Nullable
    public JsonObject encode(@NotNull BaseAttribute value) {
        JsonObject jsonObject = new JsonObject();
        ResourceLocation key = ForgeRegistries.ATTRIBUTES.getKey((Object)value.attribute());
        if (key == null) {
            throw new IllegalArgumentException("Cannot encode VisionBaseAttribute with unknown attribute registry key");
        }
        jsonObject.addProperty("id", key.toString());
        jsonObject.addProperty("value", (Number)value.value());
        return jsonObject;
    }
}

