/*
 * Decompiled with CFR 0.152.
 */
package net.lixir.vminus.resources.data.sight;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.lixir.vminus.VMinus;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraftforge.fml.loading.FMLPaths;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.UnmodifiableView;

public class SightManager
extends SimpleJsonResourceReloadListener {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Map<String, Boolean> SIGHTS = new HashMap<String, Boolean>();
    private static final Map<String, Integer> PRIORITIES = new HashMap<String, Integer>();

    public SightManager() {
        super(GSON, "sights");
    }

    protected void apply(@NotNull Map<ResourceLocation, JsonElement> files, ResourceManager manager, ProfilerFiller profiler) {
        File[] jsonFiles;
        SIGHTS.clear();
        PRIORITIES.clear();
        for (Map.Entry<ResourceLocation, JsonElement> entry : files.entrySet()) {
            this.processJson(entry.getValue().getAsJsonObject());
        }
        File configDir = new File(FMLPaths.CONFIGDIR.get().toFile(), "sights");
        if (configDir.exists() && configDir.isDirectory() && (jsonFiles = configDir.listFiles((dir, name) -> name.endsWith(".json"))) != null) {
            for (File file : jsonFiles) {
                try (FileReader reader = new FileReader(file);){
                    JsonObject json = (JsonObject)GSON.fromJson((Reader)reader, JsonObject.class);
                    this.processJson(json);
                }
                catch (Exception e) {
                    VMinus.LOGGER.error("Error reading config file '{}':", (Object)file.getName(), (Object)e);
                }
            }
        }
        VMinus.LOGGER.info("Loaded {} sights", (Object)SIGHTS.size());
    }

    private void processJson(@NotNull JsonObject json) {
        for (Map.Entry entry : json.entrySet()) {
            int priority;
            String key = (String)entry.getKey();
            if (key.endsWith("/priority")) continue;
            boolean value = ((JsonElement)entry.getValue()).getAsBoolean();
            int n = priority = json.has(key + "/priority") ? json.get(key + "/priority").getAsInt() : 0;
            if (PRIORITIES.containsKey(key) && priority < PRIORITIES.get(key)) continue;
            PRIORITIES.put(key, priority);
            SIGHTS.put(key, value);
        }
    }

    public static boolean get(String id) {
        return SIGHTS.getOrDefault(id, false);
    }

    @NotNull
    public static @UnmodifiableView Map<String, Boolean> getAllSights() {
        return Collections.unmodifiableMap(SIGHTS);
    }

    public static void setAll(Map<String, Boolean> newSights) {
        SIGHTS.clear();
        PRIORITIES.clear();
        SIGHTS.putAll(newSights);
    }
}

