/*
 * Decompiled with CFR 0.152.
 */
package net.lixir.vminus.network.vision;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.lixir.vminus.VMinus;
import net.lixir.vminus.vision.Vision;
import net.lixir.vminus.vision.VisionType;
import net.lixir.vminus.vision.VisionTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.network.NetworkEvent;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class ClientboundVisionListPacket {
    private final String visionTypeId;
    private final List<Pair<List<ResourceLocation>, CompoundTag>> groupedVisions;

    public ClientboundVisionListPacket(String visionTypeId, List<Pair<List<ResourceLocation>, CompoundTag>> groupedVisions) {
        this.visionTypeId = visionTypeId;
        this.groupedVisions = groupedVisions;
    }

    public static void encode(@NotNull ClientboundVisionListPacket msg, @NotNull FriendlyByteBuf buf) {
        buf.m_130070_(msg.visionTypeId);
        buf.m_130130_(msg.groupedVisions.size());
        for (Pair<List<ResourceLocation>, CompoundTag> pair : msg.groupedVisions) {
            List ids = (List)pair.getFirst();
            CompoundTag tag = (CompoundTag)pair.getSecond();
            buf.m_130130_(ids.size());
            for (ResourceLocation id : ids) {
                buf.m_130085_(id);
            }
            buf.m_130079_(tag);
        }
    }

    @Contract(value="_ -> new")
    @NotNull
    public static ClientboundVisionListPacket decode(@NotNull FriendlyByteBuf buf) {
        String id = buf.m_130277_();
        int groupCount = buf.m_130242_();
        ArrayList<Pair<List<ResourceLocation>, CompoundTag>> grouped = new ArrayList<Pair<List<ResourceLocation>, CompoundTag>>();
        for (int i = 0; i < groupCount; ++i) {
            int idCount = buf.m_130242_();
            ArrayList<ResourceLocation> ids = new ArrayList<ResourceLocation>();
            for (int j = 0; j < idCount; ++j) {
                ids.add(buf.m_130281_());
            }
            CompoundTag tag = buf.m_130260_();
            grouped.add((Pair<List<ResourceLocation>, CompoundTag>)Pair.of(ids, (Object)tag));
        }
        return new ClientboundVisionListPacket(id, grouped);
    }

    public static void handle(ClientboundVisionListPacket msg, @NotNull Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            VisionType<?> visionType = VisionTypes.get(msg.visionTypeId);
            if (visionType == null) {
                VMinus.LOGGER.warn("VisionType not found for id: {}", (Object)msg.visionTypeId);
                return;
            }
            for (int groupIndex = 0; groupIndex < msg.groupedVisions.size(); ++groupIndex) {
                Pair<List<ResourceLocation>, CompoundTag> pair = msg.groupedVisions.get(groupIndex);
                List ids = (List)pair.getFirst();
                CompoundTag tag = (CompoundTag)pair.getSecond();
                for (ResourceLocation id : ids) {
                    try {
                        Vision.decode(id, tag, visionType);
                        Object target = visionType.getRegistryGetter().apply(id);
                        if (target == null) continue;
                        visionType.getVisionSetter().accept(target, id);
                    }
                    catch (Exception ex) {
                        VMinus.LOGGER.error("Error syncing vision for id {}: ", (Object)id, (Object)ex);
                    }
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

