/*
 * Decompiled with CFR 0.152.
 */
package net.lixir.vminus.network;

import java.util.function.Supplier;
import net.lixir.vminus.entity.VariantEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.NetworkEvent;

public class VariantSyncPacket {
    private final int entityId;
    private final ResourceLocation variantName;
    private final ResourceLocation variantTexture;

    public VariantSyncPacket(int entityId, ResourceLocation variantName, ResourceLocation variantTexture) {
        this.entityId = entityId;
        this.variantName = variantName;
        this.variantTexture = variantTexture;
    }

    public VariantSyncPacket(FriendlyByteBuf buf) {
        this.entityId = buf.m_130242_();
        this.variantName = buf.m_130281_();
        this.variantTexture = buf.m_130281_();
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130130_(this.entityId);
        buf.m_130085_(this.variantName);
        buf.m_130085_(this.variantTexture);
    }

    public void handle(Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        ctx.enqueueWork(() -> {
            Entity entity;
            ClientLevel world = Minecraft.m_91087_().f_91073_;
            if (world != null && (entity = world.m_6815_(this.entityId)) instanceof VariantEntity) {
                VariantEntity variantEntity = (VariantEntity)entity;
                variantEntity.vMinus$setVariant(this.variantName, this.variantTexture);
            }
        });
        ctx.setPacketHandled(true);
    }
}

