/*
 * Decompiled with CFR 0.152.
 */
package net.lixir.vminus.mixins.creative;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import net.lixir.vminus.vision.VisionDuck;
import net.lixir.vminus.vision.VisionProperties;
import net.lixir.vminus.vision.util.VisionUtils;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={CreativeModeTabs.class})
public class CreativeModeTabsMixin {
    @Inject(method={"allTabs"}, at={@At(value="RETURN")}, cancellable=true)
    private static void allTabs(@NotNull CallbackInfoReturnable<List<CreativeModeTab>> cir) {
        List originalTabs = (List)cir.getReturnValue();
        ArrayList<CreativeModeTab> newTabs = new ArrayList<CreativeModeTab>();
        for (CreativeModeTab tab : originalTabs) {
            Boolean hide = VisionUtils.getOverrideValue((VisionDuck)tab, VisionProperties.Tabs.HIDE, null);
            if (hide != null && hide.booleanValue()) continue;
            newTabs.add(tab);
        }
        if (!newTabs.equals(cir.getReturnValue())) {
            cir.setReturnValue(new ArrayList(newTabs));
        }
    }

    @Inject(method={"tabs"}, at={@At(value="RETURN")}, cancellable=true)
    private static void tabs(@NotNull CallbackInfoReturnable<List<CreativeModeTab>> cir) {
        List originalTabs = (List)cir.getReturnValue();
        ArrayList<CreativeModeTab> newTabs = new ArrayList<CreativeModeTab>();
        for (CreativeModeTab tab : originalTabs) {
            Boolean hide = VisionUtils.getOverrideValue((VisionDuck)tab, VisionProperties.Tabs.HIDE, null);
            if (hide != null && hide.booleanValue()) continue;
            newTabs.add(tab);
        }
        if (!newTabs.equals(cir.getReturnValue())) {
            cir.setReturnValue(new ArrayList(newTabs));
        }
    }

    @Inject(method={"streamAllTabs"}, at={@At(value="RETURN")}, cancellable=true)
    private static void streamAllTabs(@NotNull CallbackInfoReturnable<Stream<CreativeModeTab>> cir) {
        List originalTabs = ((Stream)cir.getReturnValue()).toList();
        ArrayList<CreativeModeTab> newTabs = new ArrayList<CreativeModeTab>();
        for (CreativeModeTab tab : originalTabs) {
            Boolean hide = VisionUtils.getOverrideValue((VisionDuck)tab, VisionProperties.Tabs.HIDE, null);
            if (hide != null && hide.booleanValue()) continue;
            newTabs.add(tab);
        }
        if (!newTabs.equals(cir.getReturnValue())) {
            cir.setReturnValue(newTabs.stream());
        }
    }
}

