/*
 * Decompiled with CFR 0.152.
 */
package net.lixir.vminus.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import net.lixir.vminus.VMinus;
import net.lixir.vminus.vision.Vision;
import net.lixir.vminus.vision.VisionDuck;
import net.lixir.vminus.vision.VisionType;
import net.lixir.vminus.vision.VisionTypes;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.NotNull;

@Mod.EventBusSubscriber
public class VisionCommand {
    private static final SuggestionProvider<CommandSourceStack> VISION_TYPE_PROVIDER = (ctx, builder) -> {
        for (VisionType<?> type : VisionTypes.getAll()) {
            builder.suggest(type.getId());
        }
        return builder.buildFuture();
    };
    private static final SuggestionProvider<CommandSourceStack> FEATURE_PROVIDER = (ctx, builder) -> {
        String visionTypeId = StringArgumentType.getString((CommandContext)ctx, (String)"type");
        VisionType<?> visionType = VisionTypes.get(visionTypeId);
        if (visionType != null) {
            Registry<?> registry = visionType.getRegistry();
            registry.m_6566_().forEach(id -> builder.suggest(id.toString()));
        }
        return builder.buildFuture();
    };

    @SubscribeEvent
    public static void registerCommand(@NotNull RegisterCommandsEvent event) {
        CommandDispatcher dispatcher = event.getDispatcher();
        dispatcher.register((LiteralArgumentBuilder)Commands.m_82127_((String)"vision").then(Commands.m_82129_((String)"type", (ArgumentType)StringArgumentType.string()).suggests(VISION_TYPE_PROVIDER).then(Commands.m_82129_((String)"feature", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests(FEATURE_PROVIDER).executes(VisionCommand::execute))));
    }

    private static int execute(CommandContext<CommandSourceStack> ctx) {
        String visionTypeId = StringArgumentType.getString(ctx, (String)"type");
        VisionType<?> visionType = VisionTypes.get(visionTypeId);
        if (visionType == null) {
            ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Component.m_237113_((String)("Unknown VisionType: " + visionTypeId)));
            return 0;
        }
        ResourceLocation featureId = ResourceLocationArgument.m_107011_(ctx, (String)"feature");
        Registry<?> registry = visionType.getRegistry();
        Object feature = registry.m_6612_(featureId).orElse(null);
        if (feature == null) {
            ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Component.m_237113_((String)("Unknown feature: " + featureId + " in registry " + registry.m_123023_().m_135782_())));
            return 0;
        }
        VisionDuck duck = feature;
        Vision vision = Vision.get(visionType, duck.vMinus$getVisionId());
        CompoundTag nbt = vision.encode(visionType);
        Component component = NbtUtils.m_178061_((Tag)nbt);
        ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)("Vision[" + featureId + "]=")).m_7220_(component), false);
        VMinus.LOGGER.debug((Object)vision);
        return 1;
    }
}

