/*
 * Decompiled with CFR 0.152.
 */
package net.lixir.vminus.cape;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Predicate;
import net.lixir.vminus.cape.CapeAccounts;
import net.lixir.vminus.network.VMinusSavedData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum Cape {
    BEEPER("beeper", "vminus", "textures/cape/beeper.png", flags -> flags.isPatreon() || flags.isBooster() || flags.isDeveloper()),
    GHOST("ghost", "vminus", "textures/cape/ghost.png", CapeAccounts.Flags::isBooster),
    MIMIC("mimic", "vminus", "textures/cape/mimic.png", CapeAccounts.Flags::isPatreon),
    BEDROCK_GOLEM("bedrock_golem", "vminus", "textures/cape/bedrock_golem.png", flags -> flags.isPatreon() && flags.isBooster()),
    PHOTON("photon", "vminus", "textures/cape/photon.png", CapeAccounts.Flags::isContributor);

    private final String id;
    private final String namespace;
    private final String texturePath;
    private final Predicate<CapeAccounts.Flags> predicate;

    private Cape(String id, String namespace, String texturePath, Predicate<CapeAccounts.Flags> predicate) {
        this.id = id;
        this.namespace = namespace;
        this.texturePath = texturePath;
        this.predicate = predicate;
    }

    public boolean isAllowedFor(CapeAccounts.Flags flags) {
        return this.predicate.test(flags);
    }

    public String getId() {
        return this.id;
    }

    @NotNull
    public ResourceLocation getTexture() {
        return new ResourceLocation(this.namespace, this.texturePath);
    }

    public static boolean ownsCape(Entity entity, String capeId) {
        if (entity instanceof Player) {
            CapeAccounts.Flags flags;
            Player player = (Player)entity;
            Cape cape = Cape.fromId(capeId);
            UUID uuid = player.m_36316_().getId();
            String name = player.m_36316_().getName();
            CapeAccounts.Flags flags2 = flags = name.equals("Dev") ? CapeAccounts.fromUUID(CapeAccounts.DEV_UUID) : CapeAccounts.fromUUID(uuid);
            if (cape != null && flags != null) {
                return cape.isAllowedFor(flags);
            }
            return "default".equalsIgnoreCase(capeId);
        }
        return false;
    }

    @NotNull
    public static List<Cape> getAvailableCapes(Player player) {
        ArrayList<Cape> available = new ArrayList<Cape>();
        for (Cape cape : Cape.values()) {
            if (!Cape.ownsCape((Entity)player, cape.getId())) continue;
            available.add(cape);
        }
        return available;
    }

    @Nullable
    public static ResourceLocation getCapeTexture(@NotNull Player player) {
        Cape cape;
        String capeId = player.getCapability(VMinusSavedData.PLAYER_VARIABLES_CAPABILITY, null).map(capability -> capability.cape_id).orElse("");
        if (Cape.ownsCape((Entity)player, capeId) && (cape = Cape.fromId(capeId)) != null) {
            return cape.getTexture();
        }
        return null;
    }

    public static void setCape(Player player, String id) {
        player.getCapability(VMinusSavedData.PLAYER_VARIABLES_CAPABILITY, null).ifPresent(capability -> {
            capability.cape_id = id;
        });
    }

    @Nullable
    public static Cape fromId(String capeId) {
        for (Cape cape : Cape.values()) {
            if (!cape.id.equalsIgnoreCase(capeId)) continue;
            return cape;
        }
        return null;
    }
}

