/*
 * Decompiled with CFR 0.152.
 */
package com.github.exopandora.shouldersurfing.forge.compat;

import com.github.exopandora.shouldersurfing.compat.Mods;
import com.github.exopandora.shouldersurfing.compat.ShoulderSurfingCompatMixinPlugin;
import com.github.exopandora.shouldersurfing.forge.Platform;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.objectweb.asm.tree.ClassNode;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;

public class ShoulderSurfingCompatMixinPluginForge
extends ShoulderSurfingCompatMixinPlugin {
    public List<String> getMixins() {
        ArrayList<String> mixins = new ArrayList<String>();
        ShoulderSurfingCompatMixinPluginForge.addCommonCompatMixins(mixins);
        ShoulderSurfingCompatMixinPluginForge.addCreateModMixins(mixins);
        ShoulderSurfingCompatMixinPluginForge.addMtsMixins(mixins);
        ShoulderSurfingCompatMixinPluginForge.addOculusMixins(mixins);
        ShoulderSurfingCompatMixinPluginForge.addSkinLayersMixins(mixins);
        return mixins.isEmpty() ? null : mixins;
    }

    private static void addMtsMixins(List<String> mixins) {
        if (Mods.MTS.isLoaded()) {
            mixins.add("mts.MixinCameraSystem");
        }
    }

    private static void addOculusMixins(List<String> mixins) {
        String oculusModVersion = Mods.OCULUS.getModVersion();
        if (oculusModVersion != null) {
            DefaultArtifactVersion version = new DefaultArtifactVersion(oculusModVersion);
            if (Platform.parseVersionRangeSilent("[1.7.0-snapshot,)").containsVersion((ArtifactVersion)version)) {
                mixins.add("iris.MixinSheets_1_7_0");
            } else if (Platform.parseVersionRangeSilent("[1.6.15,1.7.0)").containsVersion((ArtifactVersion)version)) {
                mixins.add("iris.MixinSheets_1_6_15");
            }
        }
    }

    private static void addCreateModMixins(List<String> mixins) {
        String createModVersion = Mods.CREATE.getModVersion();
        if (createModVersion != null) {
            DefaultArtifactVersion version = new DefaultArtifactVersion(createModVersion);
            if (Platform.parseVersionRangeSilent("[6.0.0,)").containsVersion((ArtifactVersion)version)) {
                mixins.add("create.MixinContraptionHandlerClient_6_0_0");
            } else if (Platform.parseVersionRangeSilent("(,6.0.0)").containsVersion((ArtifactVersion)version)) {
                mixins.add("create.MixinContraptionHandlerClient_0_5_0");
            }
        }
    }

    private static void addSkinLayersMixins(List<String> mixins) {
        String skinLayersModVersion = Mods.SKIN_LAYERS.getModVersion();
        if (skinLayersModVersion != null) {
            DefaultArtifactVersion version = new DefaultArtifactVersion(skinLayersModVersion);
            if (Platform.parseVersionRangeSilent("[1_6_6,)").containsVersion((ArtifactVersion)version)) {
                mixins.add("skinlayers.MixinCustomizableModelPart_1_6_6");
            } else if (Platform.parseVersionRangeSilent("(,1.6.6)").containsVersion((ArtifactVersion)version)) {
                mixins.add("skinlayers.MixinCustomizableModelPart_1_6_5");
            }
        }
    }

    public void preApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    public void postApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }
}

