/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyswords.item.custom;

import java.util.List;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.sweenus.simplyswords.config.Config;
import net.sweenus.simplyswords.config.ConfigDefaultValues;
import net.sweenus.simplyswords.item.UniqueSwordItem;
import net.sweenus.simplyswords.registry.SoundRegistry;
import net.sweenus.simplyswords.util.AbilityMethods;
import net.sweenus.simplyswords.util.HelperMethods;

public class VolcanicFurySwordItem
extends UniqueSwordItem {
    private static int stepMod = 0;
    public static boolean scalesWithSpellPower;
    int radius = (int)Config.getFloat("volcanicFuryRadius", "UniqueEffects", ConfigDefaultValues.volcanicFuryRadius);
    float abilityDamage = Config.getFloat("volcanicFuryDamage", "UniqueEffects", ConfigDefaultValues.volcanicFuryDamage);
    int ability_timer_max = 120;
    int skillCooldown = (int)Config.getFloat("volcanicFuryCooldown", "UniqueEffects", ConfigDefaultValues.volcanicFuryCooldown);
    int chargeChance = (int)Config.getFloat("volcanicFuryChance", "UniqueEffects", ConfigDefaultValues.volcanicFuryChance);
    float spellPowerModifier = Config.getFloat("volcanicFurySpellScaling", "UniqueEffects", ConfigDefaultValues.volcanicFurySpellScaling);
    int chargePower;

    public VolcanicFurySwordItem(Tier toolMaterial, int attackDamage, float attackSpeed, Item.Properties settings) {
        super(toolMaterial, attackDamage, attackSpeed, settings);
    }

    @Override
    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        if (!attacker.m_9236_().m_5776_()) {
            ServerLevel world = (ServerLevel)attacker.m_9236_();
            HelperMethods.playHitSounds(attacker, target);
            if (attacker.m_217043_().m_188503_(100) <= this.chargeChance) {
                target.m_147207_(new MobEffectInstance(MobEffects.f_19620_, 10, 1), (Entity)attacker);
                target.m_20334_(target.m_20185_() - attacker.m_20185_(), 0.5, target.m_20189_() - attacker.m_20189_());
                target.m_20254_(5);
                int choose_sound = (int)(Math.random() * 30.0);
                if (choose_sound <= 10) {
                    world.m_6269_(null, (Entity)target, (SoundEvent)SoundRegistry.ELEMENTAL_BOW_FIRE_SHOOT_IMPACT_01.get(), target.m_5720_(), 0.5f, 1.2f);
                }
                if (choose_sound <= 20 && choose_sound > 10) {
                    world.m_6269_(null, (Entity)target, (SoundEvent)SoundRegistry.ELEMENTAL_BOW_FIRE_SHOOT_IMPACT_02.get(), target.m_5720_(), 0.5f, 1.2f);
                }
                if (choose_sound <= 30 && choose_sound > 20) {
                    world.m_6269_(null, (Entity)target, (SoundEvent)SoundRegistry.ELEMENTAL_BOW_FIRE_SHOOT_IMPACT_03.get(), target.m_5720_(), 0.5f, 1.2f);
                }
            }
        }
        return super.m_7579_(stack, target, attacker);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player user, InteractionHand hand) {
        user.m_147207_(new MobEffectInstance(MobEffects.f_19597_, 20, 5), (Entity)user);
        user.m_147207_(new MobEffectInstance(MobEffects.f_19599_, 20, 8), (Entity)user);
        user.m_147207_(new MobEffectInstance(MobEffects.f_19606_, 20, 5), (Entity)user);
        ItemStack itemStack = user.m_21120_(hand);
        if (itemStack.m_41773_() >= itemStack.m_41776_() - 1) {
            return InteractionResultHolder.m_19100_((Object)itemStack);
        }
        user.m_6672_(hand);
        return InteractionResultHolder.m_19096_((Object)itemStack);
    }

    public void m_5929_(Level world, LivingEntity user, ItemStack stack, int remainingUseTicks) {
        if (user.m_6844_(EquipmentSlot.MAINHAND) == stack && user instanceof Player) {
            Player player = (Player)user;
            AbilityMethods.tickAbilityVolcanicFury(stack, world, user, remainingUseTicks, this.ability_timer_max, this.abilityDamage, this.skillCooldown, this.radius, this.chargePower);
            if (player.f_19797_ % 20 == 0) {
                this.chargePower += 2;
            }
        }
    }

    public int m_8105_(ItemStack stack) {
        return this.ability_timer_max;
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.CROSSBOW;
    }

    public void m_5551_(ItemStack stack, Level world, LivingEntity user, int remainingUseTicks) {
        if (!world.f_46443_) {
            int choose_sound;
            if (user instanceof Player) {
                Player player = (Player)user;
                player.m_36335_().m_41524_((Item)this, this.skillCooldown);
            }
            if ((choose_sound = (int)(Math.random() * 30.0)) <= 10) {
                world.m_6269_(null, (Entity)user, (SoundEvent)SoundRegistry.ELEMENTAL_BOW_FIRE_SHOOT_IMPACT_01.get(), user.m_5720_(), 0.6f, 1.2f);
            } else if (choose_sound <= 20) {
                world.m_6269_(null, (Entity)user, (SoundEvent)SoundRegistry.ELEMENTAL_BOW_FIRE_SHOOT_IMPACT_02.get(), user.m_5720_(), 0.6f, 1.2f);
            } else if (choose_sound <= 30) {
                world.m_6269_(null, (Entity)user, (SoundEvent)SoundRegistry.ELEMENTAL_BOW_FIRE_SHOOT_IMPACT_03.get(), user.m_5720_(), 0.6f, 1.2f);
            }
            AABB box = new AABB(user.m_20185_() + (double)this.radius, user.m_20186_() + (double)this.radius, user.m_20189_() + (double)this.radius, user.m_20185_() - (double)this.radius, user.m_20186_() - (double)this.radius, user.m_20189_() - (double)this.radius);
            for (Entity entity : world.m_6249_((Entity)user, box, EntitySelector.f_20403_)) {
                if (!(entity instanceof LivingEntity)) continue;
                LivingEntity le = (LivingEntity)entity;
                if (!HelperMethods.checkFriendlyFire((LivingEntity)entity, user)) continue;
                float choose = (float)(Math.random() * 1.0);
                le.m_6469_(user.m_269291_().m_269104_((Entity)user, (Entity)user), this.abilityDamage * ((float)this.chargePower * 0.3f));
                le.m_20254_(6);
                world.m_6269_(null, (Entity)le, (SoundEvent)SoundRegistry.ELEMENTAL_BOW_POISON_ATTACK_01.get(), le.m_5720_(), 0.1f, choose);
                this.chargePower = 0;
                le.m_147207_(new MobEffectInstance(MobEffects.f_19620_, 10, 1), (Entity)user);
                le.m_20334_(le.m_20185_() - user.m_20185_(), 0.5, le.m_20189_() - user.m_20189_());
            }
        }
    }

    @Override
    public void m_6883_(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        if (HelperMethods.commonSpellAttributeScaling(this.spellPowerModifier, entity, "fire") > 0.0f) {
            this.abilityDamage = HelperMethods.commonSpellAttributeScaling(this.spellPowerModifier, entity, "fire");
            scalesWithSpellPower = true;
        }
        if (stepMod > 0) {
            --stepMod;
        }
        if (stepMod <= 0) {
            stepMod = 7;
        }
        HelperMethods.createFootfalls(entity, stack, world, stepMod, ParticleTypes.f_123757_, ParticleTypes.f_123757_, ParticleTypes.f_123757_, true);
        super.m_6883_(stack, world, entity, slot, selected);
    }

    @Override
    public void m_7373_(ItemStack itemStack, Level world, List<Component> tooltip, TooltipFlag tooltipContext) {
        Style RIGHTCLICK = HelperMethods.getStyle("rightclick");
        Style ABILITY = HelperMethods.getStyle("ability");
        Style TEXT = HelperMethods.getStyle("text");
        tooltip.add((Component)Component.m_237113_((String)""));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.volcanicfurysworditem.tooltip1").m_6270_(ABILITY));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.volcanicfurysworditem.tooltip2").m_6270_(TEXT));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.volcanicfurysworditem.tooltip3").m_6270_(TEXT));
        tooltip.add((Component)Component.m_237113_((String)""));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.onrightclickheld").m_6270_(RIGHTCLICK));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.volcanicfurysworditem.tooltip4").m_6270_(TEXT));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.volcanicfurysworditem.tooltip5").m_6270_(TEXT));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.volcanicfurysworditem.tooltip6").m_6270_(TEXT));
        tooltip.add((Component)Component.m_237113_((String)""));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.volcanicfurysworditem.tooltip7").m_6270_(TEXT));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.volcanicfurysworditem.tooltip8").m_6270_(TEXT));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.volcanicfurysworditem.tooltip9").m_6270_(TEXT));
        if (scalesWithSpellPower) {
            tooltip.add((Component)Component.m_237113_((String)""));
            tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.compat.scaleFire"));
        }
        super.m_7373_(itemStack, world, tooltip, tooltipContext);
    }
}

