/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyswords.item.custom;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.sweenus.simplyswords.config.Config;
import net.sweenus.simplyswords.config.ConfigDefaultValues;
import net.sweenus.simplyswords.item.UniqueSwordItem;
import net.sweenus.simplyswords.registry.SoundRegistry;
import net.sweenus.simplyswords.util.HelperMethods;

public class StealSwordItem
extends UniqueSwordItem {
    private static int stepMod = 0;
    public static boolean scalesWithSpellPower;
    float abilityDamage = 5.0f;
    float spellScalingModifier = Config.getFloat("stealSpellScaling", "UniqueEffects", ConfigDefaultValues.stealSpellScaling);

    public StealSwordItem(Tier toolMaterial, int attackDamage, float attackSpeed, Item.Properties settings) {
        super(toolMaterial, attackDamage, attackSpeed, settings);
    }

    @Override
    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        if (!attacker.m_9236_().m_5776_()) {
            ServerLevel sworld = (ServerLevel)attacker.m_9236_();
            int fhitchance = (int)Config.getFloat("stealChance", "UniqueEffects", ConfigDefaultValues.stealChance);
            int fduration = (int)Config.getFloat("stealDuration", "UniqueEffects", ConfigDefaultValues.stealDuration);
            attacker.m_20256_(attacker.m_20154_().m_82490_(1.0));
            attacker.f_19864_ = true;
            HelperMethods.playHitSounds(attacker, target);
            if (attacker.m_217043_().m_188503_(100) <= fhitchance) {
                int choose_sound = (int)(Math.random() * 30.0);
                if (choose_sound <= 10) {
                    sworld.m_6269_(null, (Entity)target, (SoundEvent)SoundRegistry.MAGIC_SWORD_ATTACK_WITH_BLOOD_01.get(), target.m_5720_(), 0.5f, 2.0f);
                } else if (choose_sound <= 20) {
                    sworld.m_6269_(null, (Entity)target, (SoundEvent)SoundRegistry.MAGIC_SWORD_ATTACK_WITH_BLOOD_02.get(), target.m_5720_(), 0.5f, 2.0f);
                } else {
                    sworld.m_6269_(null, (Entity)target, (SoundEvent)SoundRegistry.MAGIC_SWORD_ATTACK_WITH_BLOOD_03.get(), target.m_5720_(), 0.5f, 2.0f);
                }
                attacker.m_147207_(new MobEffectInstance(MobEffects.f_19598_, fduration, 2), (Entity)attacker);
                target.m_147207_(new MobEffectInstance(MobEffects.f_19597_, fduration, 1), (Entity)attacker);
                target.m_147207_(new MobEffectInstance(MobEffects.f_19619_, fduration, 1), (Entity)attacker);
            }
        }
        return super.m_7579_(stack, target, attacker);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player user, InteractionHand hand) {
        if (!user.m_9236_().m_5776_()) {
            int sradius = (int)Config.getFloat("stealRadius", "UniqueEffects", ConfigDefaultValues.stealRadius);
            int vradius = (int)(Config.getFloat("stealRadius", "UniqueEffects", ConfigDefaultValues.stealRadius) / 2.0f);
            double x = user.m_20185_();
            double y = user.m_20186_();
            double z = user.m_20189_();
            ServerLevel sworld = (ServerLevel)user.m_9236_();
            AABB box = new AABB(x + (double)sradius, y + (double)vradius, z + (double)sradius, x - (double)sradius, y - (double)vradius, z - (double)sradius);
            for (Entity entity : sworld.m_6249_((Entity)user, box, EntitySelector.f_20403_)) {
                LivingEntity le;
                if (!(entity instanceof LivingEntity) || !HelperMethods.checkFriendlyFire(le = (LivingEntity)entity, (LivingEntity)user)) continue;
                int iduration = (int)Config.getFloat("stealInvisDuration", "UniqueEffects", ConfigDefaultValues.stealInvisDuration);
                int bduration = (int)Config.getFloat("stealBlindDuration", "UniqueEffects", ConfigDefaultValues.stealBlindDuration);
                if (!le.m_21023_(MobEffects.f_19597_) || !le.m_21023_(MobEffects.f_19619_)) continue;
                if (le.m_20270_((Entity)user) > 5.0f) {
                    le.m_147207_(new MobEffectInstance(MobEffects.f_19610_, bduration, 1), (Entity)user);
                    user.m_20324_(le.m_20185_(), le.m_20186_(), le.m_20189_());
                    sworld.m_6269_(null, (Entity)le, (SoundEvent)SoundRegistry.ELEMENTAL_SWORD_SCIFI_ATTACK_03.get(), le.m_5720_(), 0.3f, 1.5f);
                    le.m_6469_(user.m_269291_().m_269109_(), this.abilityDamage);
                } else {
                    user.m_147207_(new MobEffectInstance(MobEffects.f_19609_, iduration, 1), (Entity)user);
                    user.m_20256_(user.m_20154_().m_82490_(2.0));
                    user.f_19864_ = true;
                    sworld.m_6269_(null, entity, (SoundEvent)SoundRegistry.MAGIC_BOW_SHOOT_MISS_01.get(), entity.m_5720_(), 0.3f, 1.5f);
                }
                le.m_21195_(MobEffects.f_19597_);
                le.m_21195_(MobEffects.f_19619_);
            }
        }
        return super.m_7203_(world, user, hand);
    }

    @Override
    public void m_6883_(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        if (HelperMethods.commonSpellAttributeScaling(this.spellScalingModifier, entity, "soul") > 0.0f) {
            this.abilityDamage = HelperMethods.commonSpellAttributeScaling(this.spellScalingModifier, entity, "soul");
            scalesWithSpellPower = true;
        }
        if (stepMod > 0) {
            --stepMod;
        }
        if (stepMod <= 0) {
            stepMod = 7;
        }
        HelperMethods.createFootfalls(entity, stack, world, stepMod, ParticleTypes.f_123775_, ParticleTypes.f_123775_, ParticleTypes.f_123757_, true);
        super.m_6883_(stack, world, entity, slot, selected);
    }

    public boolean m_6813_(ItemStack stack, Level world, BlockState state, BlockPos pos, LivingEntity miner) {
        return false;
    }

    @Override
    public void m_7373_(ItemStack itemStack, Level world, List<Component> tooltip, TooltipFlag tooltipContext) {
        Style RIGHTCLICK = HelperMethods.getStyle("rightclick");
        Style ABILITY = HelperMethods.getStyle("ability");
        Style TEXT = HelperMethods.getStyle("text");
        tooltip.add((Component)Component.m_237113_((String)""));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.stealsworditem.tooltip1").m_6270_(ABILITY));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.stealsworditem.tooltip2").m_6270_(TEXT));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.stealsworditem.tooltip3").m_6270_(TEXT));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.stealsworditem.tooltip4").m_6270_(TEXT));
        tooltip.add((Component)Component.m_237113_((String)""));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.onrightclick").m_6270_(RIGHTCLICK));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.stealsworditem.tooltip5").m_6270_(TEXT));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.stealsworditem.tooltip6").m_6270_(TEXT));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.stealsworditem.tooltip7").m_6270_(TEXT));
        tooltip.add((Component)Component.m_237113_((String)""));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.stealsworditem.tooltip8").m_6270_(TEXT));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.stealsworditem.tooltip9").m_6270_(TEXT));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.stealsworditem.tooltip10").m_6270_(TEXT));
        if (scalesWithSpellPower) {
            tooltip.add((Component)Component.m_237113_((String)""));
            tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.compat.scaleSoul"));
        }
        super.m_7373_(itemStack, world, tooltip, tooltipContext);
    }
}

