/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyswords.item.custom;

import java.util.List;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.sweenus.simplyswords.config.Config;
import net.sweenus.simplyswords.config.ConfigDefaultValues;
import net.sweenus.simplyswords.entity.BattleStandardDarkEntity;
import net.sweenus.simplyswords.item.UniqueSwordItem;
import net.sweenus.simplyswords.registry.EntityRegistry;
import net.sweenus.simplyswords.registry.SoundRegistry;
import net.sweenus.simplyswords.util.HelperMethods;

public class HarbingerSwordItem
extends UniqueSwordItem {
    private static int stepMod = 0;
    public static boolean scalesWithSpellPower;
    int skillCooldown = (int)Config.getFloat("abyssalStandardCooldown", "UniqueEffects", ConfigDefaultValues.abyssalStandardCooldown);
    int abilityChance = (int)Config.getFloat("abyssalStandardChance", "UniqueEffects", ConfigDefaultValues.abyssalStandardChance);

    public HarbingerSwordItem(Tier toolMaterial, int attackDamage, float attackSpeed, Item.Properties settings) {
        super(toolMaterial, attackDamage, attackSpeed, settings);
    }

    @Override
    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        HelperMethods.playHitSounds(attacker, target);
        if (!attacker.m_9236_().m_5776_() && attacker.m_217043_().m_188503_(100) <= this.abilityChance && attacker instanceof Player) {
            attacker.m_9236_().m_6269_(null, (Entity)attacker, (SoundEvent)SoundRegistry.MAGIC_SWORD_SPELL_02.get(), attacker.m_5720_(), 0.3f, 1.6f);
            target.m_147207_(new MobEffectInstance(MobEffects.f_19613_, 160, 0), (Entity)attacker);
        }
        return super.m_7579_(stack, target, attacker);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player user, InteractionHand hand) {
        if (!user.m_9236_().m_5776_()) {
            BlockState state;
            ServerLevel serverWorld = (ServerLevel)user.m_9236_();
            BlockState currentState = world.m_8055_(user.m_20183_().m_6630_(4).m_5484_(user.m_6374_(), 3));
            if (currentState == (state = Blocks.f_50016_.m_49966_())) {
                world.m_6269_(null, (Entity)user, (SoundEvent)SoundRegistry.DARK_SWORD_ATTACK_WITH_BLOOD_02.get(), user.m_5720_(), 0.4f, 0.8f);
                BattleStandardDarkEntity banner = (BattleStandardDarkEntity)((EntityType)EntityRegistry.BATTLESTANDARDDARK.get()).m_262496_(serverWorld, user.m_20183_().m_6630_(4).m_5484_(user.m_6374_(), 3), MobSpawnType.MOB_SUMMONED);
                if (banner != null) {
                    banner.m_20334_(0.0, -1.0, 0.0);
                    banner.ownerEntity = user;
                    banner.decayRate = 3;
                    banner.standardType = "harbinger";
                    banner.m_6593_((Component)Component.m_237110_((String)"entity.simplyswords.battlestandard.name", (Object[])new Object[]{user.m_7755_()}));
                }
                user.m_36335_().m_41524_(this.m_7968_().m_41720_(), this.skillCooldown);
            }
        }
        return super.m_7203_(world, user, hand);
    }

    @Override
    public void m_6883_(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        if (HelperMethods.commonSpellAttributeScaling(2.0f, entity, "soul") > 0.0f) {
            scalesWithSpellPower = true;
        }
        if (stepMod > 0) {
            --stepMod;
        }
        if (stepMod <= 0) {
            stepMod = 7;
        }
        HelperMethods.createFootfalls(entity, stack, world, stepMod, ParticleTypes.f_123757_, ParticleTypes.f_123757_, ParticleTypes.f_123757_, true);
        super.m_6883_(stack, world, entity, slot, selected);
    }

    @Override
    public void m_7373_(ItemStack itemStack, Level world, List<Component> tooltip, TooltipFlag tooltipContext) {
        Style RIGHTCLICK = HelperMethods.getStyle("rightclick");
        Style ABILITY = HelperMethods.getStyle("ability");
        Style TEXT = HelperMethods.getStyle("text");
        tooltip.add((Component)Component.m_237113_((String)""));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.harbingersworditem.tooltip1").m_6270_(ABILITY));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.harbingersworditem.tooltip2").m_6270_(TEXT));
        tooltip.add((Component)Component.m_237113_((String)""));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.onrightclick").m_6270_(RIGHTCLICK));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.harbingersworditem.tooltip3").m_6270_(TEXT));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.harbingersworditem.tooltip4").m_6270_(TEXT));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.harbingersworditem.tooltip5").m_6270_(TEXT));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.harbingersworditem.tooltip6").m_6270_(TEXT));
        if (scalesWithSpellPower) {
            tooltip.add((Component)Component.m_237113_((String)""));
            tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.compat.scaleSoul"));
        }
        super.m_7373_(itemStack, world, tooltip, tooltipContext);
    }
}

