/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyswords.compat.eldritch_end;

import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.sweenus.simplyswords.compat.EldritchEndCompat;
import net.sweenus.simplyswords.compat.eldritch_end.EldritchEndCompatRegistry;
import net.sweenus.simplyswords.config.Config;
import net.sweenus.simplyswords.config.ConfigDefaultValues;
import net.sweenus.simplyswords.registry.EffectRegistry;
import net.sweenus.simplyswords.registry.SoundRegistry;
import net.sweenus.simplyswords.util.HelperMethods;

public class EldritchEndCompatMethods {
    public static void generateVoidcloakStacks(LivingEntity livingEntity) {
        if (livingEntity instanceof Player) {
            int voidcallerCorruptionFrequency;
            Player player = (Player)livingEntity;
            ItemStack stack = player.m_21205_();
            if (player.f_19797_ % 180 == 0 && BuiltInRegistries.f_256951_.m_7745_(new ResourceLocation("eldritch_end:corruption")) != null) {
                double corruption = livingEntity.m_21133_((Attribute)BuiltInRegistries.f_256951_.m_7745_(new ResourceLocation("eldritch_end:corruption")));
                int maxStacks = (int)corruption / 20;
                if (!stack.m_41619_() && stack.m_150930_((Item)EldritchEndCompat.DREADTIDE.get())) {
                    HelperMethods.incrementStatusEffect(livingEntity, (MobEffect)EffectRegistry.VOIDCLOAK.get(), 280, 1, maxStacks - 1);
                    livingEntity.m_9236_().m_5594_(null, livingEntity.m_20183_(), (SoundEvent)SoundRegistry.SPELL_FIRE.get(), livingEntity.m_5720_(), 0.1f, 1.4f);
                }
            }
            if (player.f_19797_ % (voidcallerCorruptionFrequency = (int)Config.getFloat("voidcallerCorruptionFrequency", "UniqueEffects", ConfigDefaultValues.voidcallerCorruptionFrequency)) == 0) {
                EldritchEndCompatMethods.generateVoidhungerStacks((LivingEntity)player, stack);
            }
        }
    }

    public static void generateVoidhungerStacks(LivingEntity livingEntity, ItemStack stack) {
        int voidcallerCorruptionPerTick = (int)Config.getFloat("voidcallerCorruptionPerTick", "UniqueEffects", ConfigDefaultValues.voidcallerCorruptionPerTick);
        int voidcallerCorruptionDuration = (int)Config.getFloat("voidcallerCorruptionDuration", "UniqueEffects", ConfigDefaultValues.voidcallerCorruptionDuration);
        int voidcallerCorruptionMax = (int)Config.getFloat("voidcallerCorruptionMax", "UniqueEffects", ConfigDefaultValues.voidcallerCorruptionMax);
        if (!stack.m_41619_() && stack.m_150930_((Item)EldritchEndCompat.DREADTIDE.get())) {
            HelperMethods.incrementStatusEffect(livingEntity, (MobEffect)EldritchEndCompatRegistry.VOIDHUNGER.get(), voidcallerCorruptionDuration, voidcallerCorruptionPerTick, voidcallerCorruptionMax);
        }
    }
}

