/*
 * Decompiled with CFR 0.152.
 */
package malfu.bc_particle.config;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import malfu.bc_particle.BetterCombatParticleMods;
import malfu.bc_particle.config.ParticleSettings;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.util.GsonHelper;

public class ParticleSettingsLoader
implements ResourceManagerReloadListener {
    public static final ParticleSettingsLoader INSTANCE = new ParticleSettingsLoader();
    private Map<String, List<ParticleSettings>> settingsMap = new HashMap<String, List<ParticleSettings>>();

    private ParticleSettingsLoader() {
    }

    public void m_6213_(ResourceManager resourceManager) {
        HashMap<String, List<ParticleSettings>> combinedMap = new HashMap<String, List<ParticleSettings>>();
        Map resourceMap = resourceManager.m_214159_("bc_particle", path -> path.m_135815_().endsWith(".json"));
        for (ResourceLocation resourceId : resourceMap.keySet()) {
            String path2 = resourceId.m_135815_();
            if (!path2.endsWith("particle_settings.json")) continue;
            try {
                Resource resource = (Resource)resourceMap.get(resourceId);
                try {
                    InputStream stream = resource.m_215507_();
                    try (InputStreamReader reader = new InputStreamReader(stream, StandardCharsets.UTF_8);){
                        JsonObject rootObject = GsonHelper.m_13859_((Reader)reader);
                        JsonObject valuesObject = GsonHelper.m_13930_((JsonObject)rootObject, (String)"values");
                        for (String animationName : valuesObject.keySet()) {
                            JsonElement element = valuesObject.get(animationName);
                            ArrayList<ParticleSettings> settingsList = new ArrayList<ParticleSettings>();
                            if (element.isJsonArray()) {
                                JsonArray settingsArray = element.getAsJsonArray();
                                for (JsonElement settingElement : settingsArray) {
                                    JsonObject settingsObject = settingElement.getAsJsonObject();
                                    ParticleSettings settings = this.parseSettings(settingsObject);
                                    settingsList.add(settings);
                                }
                            } else if (element.isJsonObject()) {
                                JsonObject settingsObject = element.getAsJsonObject();
                                ParticleSettings settings = this.parseSettings(settingsObject);
                                settingsList.add(settings);
                            }
                            combinedMap.put(animationName, settingsList);
                        }
                    }
                    finally {
                        if (stream == null) continue;
                        stream.close();
                    }
                }
                catch (Exception e) {
                    BetterCombatParticleMods.LOGGER.error("Failed to parse particle settings from: " + String.valueOf(resourceId), (Throwable)e);
                }
            }
            catch (Exception e) {
                BetterCombatParticleMods.LOGGER.error("Failed to load particle settings from: " + String.valueOf(resourceId), (Throwable)e);
            }
        }
        this.settingsMap = combinedMap;
        BetterCombatParticleMods.LOGGER.info("[BC Particles] Loaded settings for {} animations", (Object)combinedMap.size());
    }

    private ParticleSettings parseSettings(JsonObject json) {
        return new ParticleSettings(GsonHelper.m_13851_((JsonObject)json, (String)"particle_type", (String)"none"), GsonHelper.m_13820_((JsonObject)json, (String)"z_addition", (float)0.0f), GsonHelper.m_13820_((JsonObject)json, (String)"x_addition", (float)0.0f), GsonHelper.m_13820_((JsonObject)json, (String)"y_addition", (float)0.0f), GsonHelper.m_13820_((JsonObject)json, (String)"local_yaw", (float)0.0f), GsonHelper.m_13820_((JsonObject)json, (String)"pitch_addition", (float)0.0f), GsonHelper.m_13820_((JsonObject)json, (String)"roll_set", (float)0.0f));
    }

    public List<ParticleSettings> getSettings(String animationName) {
        return this.settingsMap.getOrDefault(animationName, List.of(ParticleSettings.DEFAULT));
    }

    public static void loadNow() {
        INSTANCE.m_6213_(Minecraft.m_91087_().m_91098_());
    }
}

