/*
 * Decompiled with CFR 0.152.
 */
package toughasnails.block;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import toughasnails.api.blockentity.TANBlockEntityTypes;
import toughasnails.api.temperature.TemperatureLevel;
import toughasnails.block.entity.TemperatureGaugeBlockEntity;
import toughasnails.temperature.TemperatureHelperImpl;

public class TemperatureGaugeBlock
extends BaseEntityBlock {
    protected static final VoxelShape SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)6.0, (double)16.0);
    public static final IntegerProperty POWER = BlockStateProperties.f_61426_;
    public static final BooleanProperty INVERTED = BlockStateProperties.f_61441_;

    public TemperatureGaugeBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)POWER, (Comparable)Integer.valueOf(0))).m_61124_((Property)INVERTED, (Comparable)Boolean.valueOf(false)));
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult rayTraceResult) {
        if (player.m_36326_()) {
            if (world.f_46443_) {
                return InteractionResult.SUCCESS;
            }
            BlockState blockstate = (BlockState)state.m_61122_((Property)INVERTED);
            world.m_7731_(pos, blockstate, 2);
            world.m_220407_(GameEvent.f_157792_, pos, GameEvent.Context.m_223719_((Entity)player, (BlockState)blockstate));
            TemperatureGaugeBlock.updateSignalStrength(blockstate, world, pos);
            return InteractionResult.CONSUME;
        }
        return super.m_6227_(state, world, pos, player, hand, rayTraceResult);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter reader, BlockPos pos, CollisionContext selectionContext) {
        return SHAPE;
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public boolean m_7923_(BlockState state) {
        return true;
    }

    public boolean m_7899_(BlockState state) {
        return true;
    }

    public int m_6378_(BlockState state, BlockGetter getter, BlockPos pos, Direction direction) {
        return (Integer)state.m_61143_((Property)POWER);
    }

    public BlockEntity m_142194_(BlockPos $$0, BlockState $$1) {
        return new TemperatureGaugeBlockEntity($$0, $$1);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return !level.f_46443_ ? TemperatureGaugeBlock.m_152132_(type, TANBlockEntityTypes.TEMPERATURE_GAUGE, TemperatureGaugeBlock::tickEntity) : null;
    }

    private static void tickEntity(Level level, BlockPos pos, BlockState state, TemperatureGaugeBlockEntity blockEntity) {
        if (level.m_46467_() % 20L == 0L) {
            TemperatureGaugeBlock.updateSignalStrength(state, level, pos);
        }
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{POWER, INVERTED});
    }

    private static void updateSignalStrength(BlockState state, Level level, BlockPos pos) {
        TemperatureLevel temperatureLevel = TemperatureHelperImpl.getTemperatureAtPosWithoutProximity(level, pos);
        int strength = (Boolean)state.m_61143_((Property)INVERTED) != false ? (Mth.m_14045_((int)temperatureLevel.ordinal(), (int)2, (int)4) - 2) * 8 - 1 : 15 - Mth.m_14045_((int)temperatureLevel.ordinal(), (int)0, (int)2) * 8;
        strength = Mth.m_14045_((int)strength, (int)0, (int)15);
        if ((Integer)state.m_61143_((Property)POWER) != strength) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)POWER, (Comparable)Integer.valueOf(strength)), 3);
        }
    }
}

