/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.level.structure.piece;

import com.github.alexmodguy.alexscaves.server.block.ACBlockRegistry;
import com.github.alexmodguy.alexscaves.server.block.PrimalMagmaBlock;
import com.github.alexmodguy.alexscaves.server.level.structure.piece.ACStructurePieceRegistry;
import com.github.alexmodguy.alexscaves.server.misc.ACMath;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;

public class VolcanoStructurePiece
extends StructurePiece {
    private BlockPos center;
    private BlockPos chunkCorner;
    private int volcanoRadius;
    private int volcanoHeight;

    public VolcanoStructurePiece(BlockPos center, BlockPos chunkCorner, int volcanoRadius, int volcanoHeight) {
        super((StructurePieceType)ACStructurePieceRegistry.VOLCANO.get(), 0, VolcanoStructurePiece.createBoundingBox(chunkCorner));
        this.center = center;
        this.chunkCorner = chunkCorner;
        this.volcanoRadius = volcanoRadius;
        this.volcanoHeight = volcanoHeight;
    }

    public VolcanoStructurePiece(CompoundTag tag) {
        super((StructurePieceType)ACStructurePieceRegistry.VOLCANO.get(), tag);
        this.center = new BlockPos(tag.m_128451_("CPX"), tag.m_128451_("CPY"), tag.m_128451_("CPZ"));
        this.chunkCorner = new BlockPos(tag.m_128451_("TPX"), tag.m_128451_("TPY"), tag.m_128451_("TPZ"));
        this.volcanoRadius = tag.m_128451_("Radius");
        this.volcanoHeight = tag.m_128451_("Height");
    }

    public VolcanoStructurePiece(StructurePieceSerializationContext structurePieceSerializationContext, CompoundTag tag) {
        this(tag);
    }

    protected void m_183620_(StructurePieceSerializationContext context, CompoundTag tag) {
        tag.m_128405_("CPX", this.center.m_123341_());
        tag.m_128405_("CPY", this.center.m_123342_());
        tag.m_128405_("CPZ", this.center.m_123343_());
        tag.m_128405_("TPX", this.chunkCorner.m_123341_());
        tag.m_128405_("TPY", this.chunkCorner.m_123342_());
        tag.m_128405_("TPZ", this.chunkCorner.m_123343_());
        tag.m_128405_("Radius", this.volcanoRadius);
        tag.m_128405_("Height", this.volcanoHeight);
    }

    private static BoundingBox createBoundingBox(BlockPos chunkCorner) {
        ChunkPos chunkPos = new ChunkPos(chunkCorner);
        return new BoundingBox(chunkPos.m_45604_(), -64, chunkPos.m_45605_(), chunkPos.m_45608_(), 256, chunkPos.m_45609_());
    }

    public void checkedSetBlock(WorldGenLevel level, BlockPos position, BlockState state) {
        if (this.m_73547_().m_71051_((Vec3i)position)) {
            level.m_7731_(position, state, 128);
        }
    }

    public BlockState checkedGetBlock(WorldGenLevel level, BlockPos position) {
        if (this.m_73547_().m_71051_((Vec3i)position)) {
            return level.m_8055_(position);
        }
        return Blocks.f_50626_.m_49966_();
    }

    public void m_213694_(WorldGenLevel level, StructureManager featureManager, ChunkGenerator chunkGen, RandomSource random, BoundingBox boundingBox, ChunkPos chunkPos, BlockPos blockPos) {
        int cornerX = this.chunkCorner.m_123341_();
        int cornerY = this.chunkCorner.m_123342_();
        int cornerZ = this.chunkCorner.m_123343_();
        int generateCoreHeight = (int)Math.floor((double)this.volcanoHeight * 0.35);
        BlockPos.MutableBlockPos carve = new BlockPos.MutableBlockPos();
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                BlockState checkedBlockstate;
                carve.m_122178_(cornerX + x, cornerY, cornerZ + z);
                double dist = Math.sqrt(carve.m_203202_((double)this.center.m_123341_(), (double)carve.m_123342_(), (double)this.center.m_123343_())) / (double)this.volcanoRadius;
                if (!(dist < 1.0)) continue;
                double invDist = 1.0 - dist;
                double volcanoCurve = this.calcVolcanoCurve(invDist);
                int lavaSink = volcanoCurve < 1.0 && dist < (double)0.15f ? 2 : 0;
                double heightAt = (double)this.volcanoHeight * volcanoCurve;
                int generateHeight = (int)((double)this.center.m_123342_() + heightAt - (double)lavaSink);
                while (carve.m_123342_() < generateHeight && !(checkedBlockstate = this.checkedGetBlock(level, (BlockPos)carve)).m_60713_(Blocks.f_50752_)) {
                    int beneathAmount = generateHeight - carve.m_123342_();
                    int aboveAmount = carve.m_123342_() - this.center.m_123342_();
                    float calderaAmount = (float)Math.sin(invDist * Math.PI);
                    if (beneathAmount == generateCoreHeight && carve.m_123341_() == this.center.m_123341_() && carve.m_123343_() == this.center.m_123343_()) {
                        this.checkedSetBlock(level, (BlockPos)carve, ((Block)ACBlockRegistry.VOLCANIC_CORE.get()).m_49966_());
                    } else if ((float)beneathAmount > 3.0f + calderaAmount * 20.0f && (float)aboveAmount > 3.0f + calderaAmount * 10.0f) {
                        this.checkedSetBlock(level, (BlockPos)carve, Blocks.f_49991_.m_49966_());
                    } else if (lavaSink > 0 || beneathAmount > 6 && aboveAmount > 3) {
                        this.checkedSetBlock(level, (BlockPos)carve, (BlockState)((BlockState)((Block)ACBlockRegistry.PRIMAL_MAGMA.get()).m_49966_().m_61124_((Property)PrimalMagmaBlock.ACTIVE, (Comparable)Boolean.valueOf(true))).m_61124_((Property)PrimalMagmaBlock.PERMANENT, (Comparable)Boolean.valueOf(true)));
                    } else {
                        float magmaVeinNoise = ACMath.sampleNoise3D((float)(carve.m_123341_() - 19000), (float)carve.m_123342_() * 0.5f + 120.0f, (float)(carve.m_123343_() + 19000), 20.0f);
                        if (volcanoCurve < (double)0.035f) {
                            if ((double)(random.m_188501_() * 0.13f) < volcanoCurve) {
                                this.checkedSetBlock(level, (BlockPos)carve, Blocks.f_152597_.m_49966_());
                            } else {
                                this.checkedSetBlock(level, (BlockPos)carve, ((Block)ACBlockRegistry.LIMESTONE.get()).m_49966_());
                            }
                        } else if (magmaVeinNoise < 0.075f && magmaVeinNoise > -0.075f) {
                            this.checkedSetBlock(level, (BlockPos)carve, ((Block)ACBlockRegistry.PRIMAL_MAGMA.get()).m_49966_());
                        } else {
                            this.checkedSetBlock(level, (BlockPos)carve, ((Block)ACBlockRegistry.FLOOD_BASALT.get()).m_49966_());
                        }
                    }
                    carve.m_122184_(0, 1, 0);
                }
                carve.m_122178_(carve.m_123341_(), cornerY - 1, carve.m_123343_());
                for (int j = 0; (this.volcanoReplacesBeneath(this.checkedGetBlock(level, (BlockPos)carve)) || j < 3) && carve.m_123342_() > level.m_141937_(); ++j) {
                    this.checkedSetBlock(level, (BlockPos)carve, ((Block)ACBlockRegistry.LIMESTONE.get()).m_49966_());
                    carve.m_122184_(0, -1, 0);
                }
            }
        }
    }

    private boolean volcanoReplacesBeneath(BlockState state) {
        return state.m_60713_(Blocks.f_50016_) || state.m_204336_(BlockTags.f_144274_);
    }

    private double calcVolcanoCurve(double dist) {
        double off = 2.0 * dist - 1.0;
        double d0 = 0.5 * ((double)0.85f * Math.sin(off * 3.1415927410125732) + Math.pow(off, 3.0) + 0.5);
        return dist > (double)0.85f ? d0 : Math.max(d0, dist * dist);
    }
}

