/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.level.feature;

import com.github.alexmodguy.alexscaves.server.block.ACBlockRegistry;
import com.github.alexmodguy.alexscaves.server.block.PewenBranchBlock;
import com.github.alexmodguy.alexscaves.server.misc.ACTagRegistry;
import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class PewenTreeFeature
extends Feature<NoneFeatureConfiguration> {
    public PewenTreeFeature(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        int penumbraLvls;
        int height;
        BlockPos treeBottom;
        RandomSource randomsource = context.m_225041_();
        WorldGenLevel level = context.m_159774_();
        if (!this.checkCanTreePlace(level, treeBottom = context.m_159777_(), height = 11 + randomsource.m_188503_(10), penumbraLvls = 3 + randomsource.m_188503_(2))) {
            return false;
        }
        int j = height - penumbraLvls;
        for (int i = 0; i <= height; ++i) {
            int branchRot;
            BlockPos offset;
            BlockPos trunkPos = treeBottom.m_6630_(i);
            level.m_7731_(trunkPos, i == height ? ((Block)ACBlockRegistry.PEWEN_WOOD.get()).m_49966_() : ((Block)ACBlockRegistry.PEWEN_LOG.get()).m_49966_(), 3);
            if (i == height) {
                level.m_7731_(trunkPos.m_7494_(), ((Block)ACBlockRegistry.PEWEN_PINES.get()).m_49966_(), 3);
            }
            if (i > j) {
                this.buildPenumbra(level, trunkPos, i - j, penumbraLvls, randomsource);
                continue;
            }
            if (i > j - 1) {
                this.buildPenumbra(level, trunkPos, 1, 1, randomsource);
                continue;
            }
            if (randomsource.m_188503_(5) != 0 || !PewenTreeFeature.canReplace(level.m_8055_(offset = trunkPos.m_121996_(PewenBranchBlock.getOffsetConnectToPos(branchRot = randomsource.m_188503_(7)))))) continue;
            level.m_7731_(offset, (BlockState)((BlockState)((Block)ACBlockRegistry.PEWEN_BRANCH.get()).m_49966_().m_61124_((Property)PewenBranchBlock.ROTATION, (Comparable)Integer.valueOf(branchRot))).m_61124_((Property)PewenBranchBlock.PINES, (Comparable)Boolean.valueOf(true)), 3);
        }
        return true;
    }

    private void buildPenumbra(WorldGenLevel level, BlockPos trunkPos, int currentIndex, int maxIndex, RandomSource randomSource) {
        int branchWidth = maxIndex - currentIndex + 1;
        for (int i = 0; i < 8; ++i) {
            int randBranchLength = branchWidth - randomSource.m_188503_(1);
            int actualLength = i % 2 != 0 && randBranchLength > 1 ? randBranchLength - 1 : randBranchLength;
            for (int j = 1; j <= actualLength; ++j) {
                BlockPos offset = trunkPos.m_121996_(PewenBranchBlock.getOffsetConnectToPos(i).m_142393_(j));
                if (!PewenTreeFeature.canReplace(level.m_8055_(offset))) continue;
                level.m_7731_(offset, (BlockState)((BlockState)((Block)ACBlockRegistry.PEWEN_BRANCH.get()).m_49966_().m_61124_((Property)PewenBranchBlock.ROTATION, (Comparable)Integer.valueOf(i))).m_61124_((Property)PewenBranchBlock.PINES, (Comparable)Boolean.valueOf(j == actualLength)), 3);
            }
        }
    }

    private boolean checkCanTreePlace(WorldGenLevel level, BlockPos treeBottom, int height, int penumbraLvls) {
        BlockState below = level.m_8055_(treeBottom.m_7495_());
        if (!below.m_204336_(BlockTags.f_144274_)) {
            return false;
        }
        for (int i = 0; i < height; ++i) {
            if (PewenTreeFeature.canReplace(level.m_8055_(treeBottom.m_6630_(i)))) continue;
            return false;
        }
        BlockPos treeTop = treeBottom.m_6630_(height - penumbraLvls);
        for (BlockPos checkLeaf : BlockPos.m_121940_((BlockPos)treeTop.m_7918_(-2, -1, -2), (BlockPos)treeTop.m_7918_(2, penumbraLvls - 1, 2))) {
            if (PewenTreeFeature.canReplace(level.m_8055_(checkLeaf))) continue;
            return false;
        }
        return true;
    }

    private static boolean canReplace(BlockState state) {
        return (state.m_60795_() || state.m_247087_() || state.m_60713_((Block)ACBlockRegistry.PEWEN_BRANCH.get())) && !state.m_204336_(ACTagRegistry.UNMOVEABLE) && state.m_60819_().m_76178_();
    }
}

