/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.entity.living;

import com.github.alexmodguy.alexscaves.server.block.ACBlockRegistry;
import com.github.alexmodguy.alexscaves.server.entity.ACEntityRegistry;
import com.github.alexmodguy.alexscaves.server.entity.ai.AnimalFollowOwnerGoal;
import com.github.alexmodguy.alexscaves.server.entity.ai.RaycatSitOnBlockGoal;
import com.github.alexmodguy.alexscaves.server.item.ACItemRegistry;
import com.github.alexmodguy.alexscaves.server.misc.ACSoundRegistry;
import com.github.alexmodguy.alexscaves.server.potion.ACEffectRegistry;
import com.github.alexthe666.citadel.server.entity.IComandableMob;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.OcelotAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.Nullable;

public class RaycatEntity
extends TamableAnimal
implements IComandableMob {
    private static final EntityDataAccessor<Integer> ABSORB_TARGET_ID = SynchedEntityData.m_135353_(RaycatEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> COMMAND = SynchedEntityData.m_135353_(RaycatEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> LAY_TIME = SynchedEntityData.m_135353_(RaycatEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Float> ABSORB_AMOUNT = SynchedEntityData.m_135353_(RaycatEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private float sitProgress;
    private float prevSitProgress;
    private float layProgress;
    private float prevLayProgress;
    private float prevAbsorbAmount;
    private int absorbCooldown;

    public RaycatEntity(EntityType entityType, Level level) {
        super(entityType, level);
        this.absorbCooldown = 300 + this.f_19796_.m_188503_(300);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.f_21345_.m_25352_(2, (Goal)new TemptGoal((PathfinderMob)this, 1.0, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42526_}), false));
        this.f_21345_.m_25352_(3, (Goal)new AnimalFollowOwnerGoal(this, 1.2, 5.0f, 2.0f, false){

            @Override
            public boolean shouldFollow() {
                return RaycatEntity.this.getCommand() == 2;
            }
        });
        this.f_21345_.m_25352_(4, (Goal)new RaycatSitOnBlockGoal(this, 1.0));
        this.f_21345_.m_25352_(5, (Goal)new LeapAtTargetGoal((Mob)this, 0.3f));
        this.f_21345_.m_25352_(6, (Goal)new OcelotAttackGoal((Mob)this));
        this.f_21345_.m_25352_(7, (Goal)new BreedGoal((Animal)this, 0.8));
        this.f_21345_.m_25352_(8, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.8));
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 15.0f));
        this.f_21345_.m_25352_(10, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public static boolean checkRaycatSpawnRules(EntityType<? extends Animal> type, LevelAccessor levelAccessor, MobSpawnType mobType, BlockPos pos, RandomSource randomSource) {
        return levelAccessor.m_8055_(pos.m_7495_()).m_60713_((Block)ACBlockRegistry.RADROCK.get()) && levelAccessor.m_6425_(pos).m_76178_() && levelAccessor.m_6425_(pos.m_7495_()).m_76178_();
    }

    public float m_5610_(BlockPos pos, LevelReader levelReader) {
        return levelReader.m_8055_(pos.m_7495_()).m_60713_((Block)ACBlockRegistry.RADROCK.get()) ? 10.0f : super.m_5610_(pos, levelReader);
    }

    public int m_5792_() {
        return 1;
    }

    public boolean m_7296_(int i) {
        return true;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ABSORB_TARGET_ID, (Object)-1);
        this.f_19804_.m_135372_(LAY_TIME, (Object)0);
        this.f_19804_.m_135372_(COMMAND, (Object)0);
        this.f_19804_.m_135372_(ABSORB_AMOUNT, (Object)Float.valueOf(0.0f));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22279_, 0.3).m_22268_(Attributes.f_22276_, 24.0).m_22268_(Attributes.f_22281_, 1.0);
    }

    public MobType m_6336_() {
        return MobType.f_21641_;
    }

    public boolean m_6898_(ItemStack itemStack) {
        return itemStack.m_150930_((Item)ACItemRegistry.RADGILL.get());
    }

    public void m_8119_() {
        super.m_8119_();
        this.prevSitProgress = this.sitProgress;
        this.prevLayProgress = this.layProgress;
        this.prevAbsorbAmount = this.getAbsorbAmount();
        if (this.m_21825_() && this.sitProgress < 5.0f) {
            this.sitProgress += 1.0f;
        }
        if (!this.m_21825_() && this.sitProgress > 0.0f) {
            this.sitProgress -= 1.0f;
        }
        if (this.getLayTime() > 0 && this.layProgress < 5.0f) {
            this.layProgress += 1.0f;
        }
        if (this.getLayTime() <= 0 && this.layProgress > 0.0f) {
            this.layProgress -= 1.0f;
        }
        Entity absorbTarget = this.getAbsorbTarget();
        if (this.m_21023_((MobEffect)ACEffectRegistry.IRRADIATED.get()) && this.f_19797_ % 10 == 0) {
            this.m_5634_(1.0f);
        }
        if (this.absorbCooldown > 0) {
            --this.absorbCooldown;
        } else {
            LivingEntity owner = this.m_269323_();
            if (absorbTarget == null) {
                if (!this.m_9236_().f_46443_) {
                    LivingEntity closestIrradiated = null;
                    if (owner != null && owner.m_20270_((Entity)this) < 20.0f && owner.m_21023_((MobEffect)ACEffectRegistry.IRRADIATED.get())) {
                        closestIrradiated = owner;
                    } else {
                        for (LivingEntity entity : this.m_9236_().m_45976_(LivingEntity.class, this.m_20191_().m_82400_(9.0))) {
                            if (entity instanceof RaycatEntity || !entity.m_21023_((MobEffect)ACEffectRegistry.IRRADIATED.get()) || closestIrradiated != null && !(closestIrradiated.m_20270_((Entity)this) > entity.m_20270_((Entity)this)) || !this.m_21824_() && entity instanceof Player) continue;
                            closestIrradiated = entity;
                        }
                    }
                    this.setAbsorbTargetId(closestIrradiated == null ? -1 : closestIrradiated.m_19879_());
                    this.resetAbsorbCooldown();
                }
            } else if (this.getAbsorbAmount() <= 0.0f) {
                this.setAbsorbAmount(1.0f);
                this.m_216990_((SoundEvent)ACSoundRegistry.RAYCAT_ABSORB.get());
            } else {
                this.setAbsorbAmount(Math.max(0.0f, this.getAbsorbAmount() - 0.05f));
                if (this.getAbsorbAmount() <= 0.0f) {
                    LivingEntity living;
                    MobEffectInstance effectInstance;
                    int currentRad = this.m_21023_((MobEffect)ACEffectRegistry.IRRADIATED.get()) ? this.m_21124_((MobEffect)ACEffectRegistry.IRRADIATED.get()).m_19564_() + 1 : 0;
                    this.m_5634_(10.0f);
                    this.m_7292_(new MobEffectInstance((MobEffect)ACEffectRegistry.IRRADIATED.get(), 200, currentRad));
                    this.m_21391_(absorbTarget, 30.0f, 30.0f);
                    if (absorbTarget instanceof LivingEntity && (effectInstance = (living = (LivingEntity)absorbTarget).m_21124_((MobEffect)ACEffectRegistry.IRRADIATED.get())) != null) {
                        int timeLeft = effectInstance.m_19557_();
                        int level = effectInstance.m_19564_();
                        living.m_21195_((MobEffect)ACEffectRegistry.IRRADIATED.get());
                        if (level > 0) {
                            living.m_7292_(new MobEffectInstance((MobEffect)ACEffectRegistry.IRRADIATED.get(), timeLeft, level - 1));
                        }
                    }
                    this.setAbsorbTargetId(-1);
                    if (!this.m_9236_().f_46443_) {
                        this.resetAbsorbCooldown();
                    }
                }
            }
        }
    }

    private void resetAbsorbCooldown() {
        this.absorbCooldown = 300 + this.f_19796_.m_188503_(300);
    }

    public Entity getAbsorbTarget() {
        int id = (Integer)this.f_19804_.m_135370_(ABSORB_TARGET_ID);
        return id == -1 ? null : this.m_9236_().m_6815_(id);
    }

    public void setAbsorbTargetId(int id) {
        this.f_19804_.m_135381_(ABSORB_TARGET_ID, (Object)id);
    }

    public float getSitProgress(float partialTicks) {
        return (this.prevSitProgress + (this.sitProgress - this.prevSitProgress) * partialTicks) * 0.2f;
    }

    public float getLayProgress(float partialTicks) {
        return (this.prevLayProgress + (this.layProgress - this.prevLayProgress) * partialTicks) * 0.2f;
    }

    public float getAbsorbAmount(float partialTicks) {
        return this.prevAbsorbAmount + (this.getAbsorbAmount() - this.prevAbsorbAmount) * partialTicks;
    }

    public float getAbsorbAmount() {
        return ((Float)this.f_19804_.m_135370_(ABSORB_AMOUNT)).floatValue();
    }

    public void setAbsorbAmount(float absorbAmount) {
        this.f_19804_.m_135381_(ABSORB_AMOUNT, (Object)Float.valueOf(absorbAmount));
    }

    public int getCommand() {
        return (Integer)this.f_19804_.m_135370_(COMMAND);
    }

    public void setCommand(int command) {
        this.f_19804_.m_135381_(COMMAND, (Object)command);
    }

    public int getLayTime() {
        return (Integer)this.f_19804_.m_135370_(LAY_TIME);
    }

    public void setLayTime(int layTime) {
        this.f_19804_.m_135381_(LAY_TIME, (Object)layTime);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("Command", this.getCommand());
        compound.m_128405_("LayTime", this.getLayTime());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setCommand(compound.m_128451_("Command"));
        this.setLayTime(compound.m_128451_("LayTime"));
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (itemstack.m_150930_((Item)ACItemRegistry.RADGILL.get()) && !this.m_21824_()) {
            this.m_142075_(player, hand, itemstack);
            if (this.m_217043_().m_188503_(3) == 0) {
                this.m_21828_(player);
                this.m_9236_().m_7605_((Entity)this, (byte)7);
            } else {
                this.m_9236_().m_7605_((Entity)this, (byte)6);
            }
            return InteractionResult.SUCCESS;
        }
        InteractionResult interactionresult = itemstack.m_41647_(player, (LivingEntity)this, hand);
        InteractionResult type = super.m_6071_(player, hand);
        if (!interactionresult.m_19077_() && !type.m_19077_() && this.m_21824_() && this.m_21830_((LivingEntity)player) && !this.m_6898_(itemstack) && !player.m_6144_()) {
            boolean sit;
            this.setCommand(this.getCommand() + 1);
            if (this.getCommand() == 3) {
                this.setCommand(0);
            }
            player.m_5661_((Component)Component.m_237110_((String)("entity.alexscaves.all.command_" + this.getCommand()), (Object[])new Object[]{this.m_7755_()}), true);
            boolean bl = sit = this.getCommand() == 1;
            if (sit) {
                this.m_21839_(true);
            } else {
                this.m_21839_(false);
            }
            return InteractionResult.SUCCESS;
        }
        return type;
    }

    protected void m_142075_(Player player, InteractionHand hand, ItemStack itemStack) {
        if (this.m_6898_(itemStack)) {
            this.m_5496_((SoundEvent)ACSoundRegistry.RAYCAT_EAT.get(), 1.0f, 1.0f);
        }
        super.m_142075_(player, hand, itemStack);
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel serverLevel, AgeableMob mob) {
        return (AgeableMob)((EntityType)ACEntityRegistry.RAYCAT.get()).m_20615_((Level)serverLevel);
    }

    protected SoundEvent m_7515_() {
        return this.m_21824_() ? (SoundEvent)ACSoundRegistry.RAYCAT_TAME_IDLE.get() : (SoundEvent)ACSoundRegistry.RAYCAT_IDLE.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return (SoundEvent)ACSoundRegistry.RAYCAT_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)ACSoundRegistry.RAYCAT_HURT.get();
    }
}

