/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.block;

import com.github.alexmodguy.alexscaves.AlexsCaves;
import com.github.alexmodguy.alexscaves.server.message.WorldEventMessage;
import com.github.alexmodguy.alexscaves.server.misc.ACMath;
import com.github.alexmodguy.alexscaves.server.misc.ACTagRegistry;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Tuple;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.AbstractGlassBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraftforge.fluids.FluidType;

public class DrainBlock
extends AbstractGlassBlock {
    public static final BooleanProperty OPEN = BooleanProperty.m_61465_((String)"open");
    private static final int MAXIMUM_BLOCKS_DRAINED = 64;
    public static final int MAX_FLUID_SPREAD = 10;
    private static final Direction[] DRAIN_DIRECTIONS = ACMath.HORIZONTAL_DIRECTIONS;
    private static final Direction[] FIND_WATER_DIRECTIONS = new Direction[]{Direction.UP, Direction.EAST, Direction.NORTH, Direction.WEST, Direction.SOUTH};
    private static final Direction[] FILL_DIRECTIONS = new Direction[]{Direction.DOWN, Direction.EAST, Direction.NORTH, Direction.WEST, Direction.SOUTH};
    private static final int DRAIN_TIME = 20;

    public DrainBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283906_).m_278166_(PushReaction.IGNORE).m_60955_().m_60999_().m_60913_(5.0f, 15.0f).m_60918_(SoundType.f_56743_));
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> blockStateBuilder) {
        blockStateBuilder.m_61104_(new Property[]{OPEN});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(context.m_43725_().m_276867_(context.m_8083_())));
    }

    public void m_6861_(BlockState state, Level worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        if (!worldIn.f_46443_) {
            this.updateState(state, worldIn, pos, blockIn);
        }
    }

    public void m_213897_(BlockState state, ServerLevel worldIn, BlockPos pos, RandomSource rand) {
        if (!worldIn.f_46443_) {
            this.updateState(state, (Level)worldIn, pos, state.m_60734_());
            if (((Boolean)state.m_61143_((Property)OPEN)).booleanValue()) {
                this.drainLogic(state, (Level)worldIn, pos);
            }
        }
    }

    public void drainLogic(BlockState state, Level worldIn, BlockPos pos) {
        BlockPos above = pos.m_7494_();
        if (!(worldIn.m_6425_(above).m_76178_() || !worldIn.m_46859_(pos.m_7495_()) && worldIn.m_6425_(pos.m_7495_()).m_76178_())) {
            BlockPos.MutableBlockPos highestWaterMutable = new BlockPos.MutableBlockPos();
            highestWaterMutable.m_122190_((Vec3i)pos);
            highestWaterMutable.m_122184_(0, 1, 0);
            while (!worldIn.m_6425_((BlockPos)highestWaterMutable).m_76178_() && highestWaterMutable.m_123342_() < worldIn.m_151558_()) {
                highestWaterMutable.m_122184_(0, 1, 0);
            }
            highestWaterMutable.m_122184_(0, -1, 0);
            BlockPos highestWater = this.findHighestWater(worldIn, highestWaterMutable.m_7949_());
            FluidState copyState = worldIn.m_6425_(highestWater);
            BlockState fluidBlockCopyState = worldIn.m_8055_(highestWater);
            if (!copyState.m_76178_()) {
                int count = this.removeWaterBreadthFirstSearch(worldIn, highestWater);
                if (count > 0) {
                    AlexsCaves.sendMSGToAll(new WorldEventMessage(3, pos.m_123341_(), pos.m_123342_(), pos.m_123343_()));
                }
                BlockPos.MutableBlockPos lowestAir = new BlockPos.MutableBlockPos();
                lowestAir.m_122190_((Vec3i)pos);
                lowestAir.m_122184_(0, -1, 0);
                while ((!worldIn.m_6425_((BlockPos)lowestAir).m_76178_() || worldIn.m_46859_((BlockPos)lowestAir)) && lowestAir.m_123342_() > worldIn.m_141937_()) {
                    lowestAir.m_122184_(0, -1, 0);
                }
                lowestAir.m_122184_(0, 1, 0);
                BlockPos lowest = lowestAir.m_7949_();
                BlockState fullBlock = fluidBlockCopyState.m_60819_().m_76178_() ? Blocks.f_50016_.m_49966_() : fluidBlockCopyState.m_60819_().m_76188_();
                boolean flag = false;
                for (int i = 0; i < count; ++i) {
                    ArrayList ignoredPoses = Lists.newArrayList();
                    BlockPos setPos = this.getFirstEmptyNeighborPosition(worldIn, lowest, copyState.getFluidType(), 0, ignoredPoses);
                    if (setPos == null) {
                        if ((lowest = lowest.m_7494_()).m_123342_() >= pos.m_123342_()) break;
                        --i;
                        continue;
                    }
                    worldIn.m_46597_(setPos, fullBlock);
                    flag = true;
                }
                if (flag) {
                    AlexsCaves.sendMSGToAll(new WorldEventMessage(4, pos.m_123341_(), pos.m_123342_(), pos.m_123343_()));
                }
            }
            worldIn.m_186460_(pos, (Block)this, 20);
        }
    }

    public void updateState(BlockState state, Level worldIn, BlockPos pos, Block blockIn) {
        boolean flag = (Boolean)state.m_61143_((Property)OPEN);
        boolean flag1 = worldIn.m_276867_(pos);
        if (flag1 != flag) {
            worldIn.m_7731_(pos, (BlockState)state.m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(flag1)), 3);
            worldIn.m_46672_(pos.m_7495_(), (Block)this);
            worldIn.m_186460_(pos, (Block)this, 20);
        }
    }

    private BlockPos findHighestWater(Level level, BlockPos pos) {
        BlockPos highest = pos;
        LinkedList queue = Lists.newLinkedList();
        queue.add(new Tuple((Object)pos, (Object)0));
        int i = 0;
        int maxDist = 5;
        while (!queue.isEmpty()) {
            Tuple tuple = (Tuple)queue.poll();
            BlockPos blockpos = (BlockPos)tuple.m_14418_();
            if (blockpos.m_123342_() > highest.m_123342_()) {
                highest = blockpos;
            }
            int j = (Integer)tuple.m_14419_();
            for (Direction direction : FIND_WATER_DIRECTIONS) {
                BlockPos blockpos1 = blockpos.m_121945_(direction);
                BlockState blockstate = level.m_8055_(blockpos1);
                if (blockstate.m_60819_().m_76178_() || blockstate.m_60734_() instanceof SimpleWaterloggedBlock) continue;
                ++i;
                if (j >= maxDist) continue;
                queue.add(new Tuple((Object)blockpos1, (Object)(j + 1)));
            }
            if (i <= 10024) continue;
            break;
        }
        return highest;
    }

    private BlockPos getFirstEmptyNeighborPosition(Level level, BlockPos pos, FluidType ourType, int tries, List<BlockPos> ignoredPoses) {
        if (tries < 20 && !ignoredPoses.contains(pos)) {
            ignoredPoses.add(pos);
            if (this.canMergeWith(level, pos)) {
                return pos;
            }
            for (Direction direction : FILL_DIRECTIONS) {
                BlockPos pos2;
                BlockPos pos1 = pos.m_121945_(direction);
                if (this.canMergeWith(level, pos1)) {
                    return pos1;
                }
                if (level.m_6425_(pos1).getFluidType() == ourType && (pos2 = this.getFirstEmptyNeighborPosition(level, pos1, ourType, tries + 1, ignoredPoses)) != null) {
                    return pos2;
                }
                ignoredPoses.add(pos1);
            }
        }
        return null;
    }

    private boolean canMergeWith(Level level, BlockPos pos) {
        return level.m_8055_(pos).m_60795_() && level.m_6425_(pos).m_76178_() || !level.m_6425_(pos).m_76178_() && !level.m_6425_(pos).m_76170_();
    }

    private int removeWaterBreadthFirstSearch(Level level, BlockPos pos) {
        LinkedList queue = Lists.newLinkedList();
        queue.add(new Tuple((Object)pos, (Object)0));
        int i = 0;
        int fullBlocks = 0;
        FluidState lastFluidState = null;
        while (!queue.isEmpty()) {
            Tuple tuple = (Tuple)queue.poll();
            BlockPos blockpos = (BlockPos)tuple.m_14418_();
            BlockState state = level.m_8055_(blockpos);
            int j = (Integer)tuple.m_14419_();
            if (!state.m_60819_().m_76178_()) {
                ++fullBlocks;
                if (state.m_60734_() instanceof BucketPickup) {
                    ((BucketPickup)state.m_60734_()).m_142598_((LevelAccessor)level, blockpos, state);
                } else {
                    level.m_46597_(blockpos, Blocks.f_50016_.m_49966_());
                }
            }
            for (Direction direction : DRAIN_DIRECTIONS) {
                BlockPos blockpos1 = blockpos.m_121945_(direction);
                BlockState blockstate = level.m_8055_(blockpos1);
                FluidState fluidstate = level.m_6425_(blockpos1);
                if (lastFluidState != null && !fluidstate.m_76178_() && lastFluidState.getFluidType() != fluidstate.getFluidType()) continue;
                if (blockstate.m_60734_() instanceof SimpleWaterloggedBlock) {
                    if (!fluidstate.m_76178_()) {
                        lastFluidState = fluidstate;
                    }
                    ++i;
                    ++fullBlocks;
                    level.m_46597_(blockpos1, (BlockState)blockstate.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(false)));
                    if (j >= 10) continue;
                    queue.add(new Tuple((Object)blockpos1, (Object)(j + 1)));
                    continue;
                }
                if (blockstate.m_60734_() instanceof BucketPickup) {
                    if (!fluidstate.m_76178_()) {
                        lastFluidState = fluidstate;
                    }
                    ++i;
                    ++fullBlocks;
                    ((BucketPickup)blockstate.m_60734_()).m_142598_((LevelAccessor)level, blockpos1, blockstate);
                    if (j >= 10) continue;
                    queue.add(new Tuple((Object)blockpos1, (Object)(j + 1)));
                    continue;
                }
                if (blockstate.m_60734_() instanceof LiquidBlock) {
                    if (!fluidstate.m_76178_()) {
                        lastFluidState = fluidstate;
                    }
                    level.m_46597_(blockpos1, Blocks.f_50016_.m_49966_());
                    ++i;
                    if (blockstate.m_60819_().m_76170_()) {
                        ++fullBlocks;
                    }
                    if (j >= 10) continue;
                    queue.add(new Tuple((Object)blockpos1, (Object)(j + 1)));
                    continue;
                }
                if (!blockstate.m_204336_(ACTagRegistry.DRAIN_BREAKS)) continue;
                if (!fluidstate.m_76178_()) {
                    lastFluidState = fluidstate;
                }
                BlockEntity blockentity = blockstate.m_155947_() ? level.m_7702_(blockpos1) : null;
                DrainBlock.m_49892_((BlockState)blockstate, (LevelAccessor)level, (BlockPos)blockpos1, (BlockEntity)blockentity);
                if (blockstate.m_60819_().m_76170_()) {
                    ++fullBlocks;
                }
                level.m_46597_(blockpos1, Blocks.f_50016_.m_49966_());
                ++i;
                if (j >= 10) continue;
                queue.add(new Tuple((Object)blockpos1, (Object)(j + 1)));
            }
            if (i <= 64) continue;
            break;
        }
        return fullBlocks;
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }
}

