/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.client.model;

import com.github.alexmodguy.alexscaves.server.entity.living.HullbreakerEntity;
import com.github.alexmodguy.alexscaves.server.misc.ACMath;
import com.github.alexthe666.citadel.animation.IAnimatedEntity;
import com.github.alexthe666.citadel.client.model.AdvancedEntityModel;
import com.github.alexthe666.citadel.client.model.AdvancedModelBox;
import com.github.alexthe666.citadel.client.model.ModelAnimator;
import com.github.alexthe666.citadel.client.model.basic.BasicModelPart;
import com.google.common.collect.ImmutableList;

public class HullbreakerModel
extends AdvancedEntityModel<HullbreakerEntity> {
    private final AdvancedModelBox root;
    private final AdvancedModelBox body;
    private final AdvancedModelBox dorsal;
    private final AdvancedModelBox bottomFlipper;
    private final AdvancedModelBox lflipper;
    private final AdvancedModelBox rflipper;
    private final AdvancedModelBox body2;
    private final AdvancedModelBox tail;
    private final AdvancedModelBox tail2;
    private final AdvancedModelBox tail3;
    private final AdvancedModelBox dorsal2;
    private final AdvancedModelBox rbarb;
    private final AdvancedModelBox rbarb2;
    private final AdvancedModelBox rbarbLure;
    private final AdvancedModelBox lbarb;
    private final AdvancedModelBox lbarb2;
    private final AdvancedModelBox lbarbLure;
    private final AdvancedModelBox head;
    private final AdvancedModelBox teeth1;
    private final AdvancedModelBox teeth2;
    private final AdvancedModelBox teeth3;
    private final AdvancedModelBox jaw;
    private final AdvancedModelBox teeth4;
    private final AdvancedModelBox teeth5;
    private final ModelAnimator animator;
    public boolean straighten = false;

    public HullbreakerModel() {
        this.texWidth = 512;
        this.texHeight = 512;
        this.root = new AdvancedModelBox((AdvancedEntityModel)this);
        this.root.setRotationPoint(0.0f, 0.0f, 0.0f);
        this.body = new AdvancedModelBox((AdvancedEntityModel)this);
        this.body.setRotationPoint(0.0f, 0.0f, -15.0f);
        this.root.addChild((BasicModelPart)this.body);
        this.body.setTextureOffset(0, 0).addBox(-12.0f, -41.0f, -12.0f, 24.0f, 41.0f, 53.0f, 0.0f, false);
        this.dorsal = new AdvancedModelBox((AdvancedEntityModel)this);
        this.dorsal.setRotationPoint(0.0f, -30.5f, -8.5f);
        this.body.addChild((BasicModelPart)this.dorsal);
        this.dorsal.setTextureOffset(0, 41).addBox(0.0f, -67.5f, -10.5f, 0.0f, 75.0f, 53.0f, 0.0f, false);
        this.bottomFlipper = new AdvancedModelBox((AdvancedEntityModel)this);
        this.bottomFlipper.setRotationPoint(0.0f, -1.5f, 32.0f);
        this.body.addChild((BasicModelPart)this.bottomFlipper);
        this.bottomFlipper.setTextureOffset(122, 245).addBox(0.0f, -3.5f, -6.0f, 0.0f, 39.0f, 32.0f, 0.0f, false);
        this.lflipper = new AdvancedModelBox((AdvancedEntityModel)this);
        this.lflipper.setRotationPoint(12.0f, -9.5f, -2.0f);
        this.body.addChild((BasicModelPart)this.lflipper);
        this.setRotateAngle(this.lflipper, 0.3927f, -0.7854f, 0.0f);
        this.lflipper.setTextureOffset(101, 0).addBox(0.0f, -31.5f, 0.0f, 47.0f, 41.0f, 0.0f, 0.0f, false);
        this.rflipper = new AdvancedModelBox((AdvancedEntityModel)this);
        this.rflipper.setRotationPoint(-12.0f, -9.5f, -2.0f);
        this.body.addChild((BasicModelPart)this.rflipper);
        this.setRotateAngle(this.rflipper, 0.3927f, 0.7854f, 0.0f);
        this.rflipper.setTextureOffset(101, 0).addBox(-47.0f, -31.5f, 0.0f, 47.0f, 41.0f, 0.0f, 0.0f, true);
        this.body2 = new AdvancedModelBox((AdvancedEntityModel)this);
        this.body2.setRotationPoint(0.0f, -17.0f, 40.0f);
        this.body.addChild((BasicModelPart)this.body2);
        this.body2.setTextureOffset(210, 106).addBox(-10.0f, -14.0f, -2.0f, 20.0f, 28.0f, 46.0f, 0.0f, false);
        this.tail = new AdvancedModelBox((AdvancedEntityModel)this);
        this.tail.setRotationPoint(0.0f, 1.5f, 43.75f);
        this.body2.addChild((BasicModelPart)this.tail);
        this.tail.setTextureOffset(0, 117).addBox(0.0f, -35.5f, 6.25f, 0.0f, 67.0f, 52.0f, 0.0f, false);
        this.tail.setTextureOffset(0, 236).addBox(-6.0f, -9.5f, -2.75f, 12.0f, 19.0f, 49.0f, 0.0f, false);
        this.tail2 = new AdvancedModelBox((AdvancedEntityModel)this);
        this.tail2.setRotationPoint(0.0f, 0.0f, 58.25f);
        this.tail.addChild((BasicModelPart)this.tail2);
        this.tail2.setTextureOffset(106, 109).addBox(0.0f, -35.5f, 0.0f, 0.0f, 67.0f, 52.0f, 0.0f, false);
        this.tail3 = new AdvancedModelBox((AdvancedEntityModel)this);
        this.tail3.setRotationPoint(0.0f, 0.0f, 52.0f);
        this.tail2.addChild((BasicModelPart)this.tail3);
        this.tail3.setTextureOffset(106, 42).addBox(0.0f, -35.5f, 0.0f, 0.0f, 67.0f, 52.0f, 0.0f, false);
        this.tail3.setTextureOffset(0, 0).addBox(-3.5f, -5.5f, 44.0f, 7.0f, 7.0f, 7.0f, 0.0f, false);
        this.dorsal2 = new AdvancedModelBox((AdvancedEntityModel)this);
        this.dorsal2.setRotationPoint(0.0f, -14.5f, -3.5f);
        this.body2.addChild((BasicModelPart)this.dorsal2);
        this.dorsal2.setTextureOffset(104, 173).addBox(0.0f, -48.5f, -2.5f, 0.0f, 49.0f, 55.0f, 0.0f, false);
        this.rbarb = new AdvancedModelBox((AdvancedEntityModel)this);
        this.rbarb.setRotationPoint(-9.0f, -0.5f, -3.0f);
        this.body.addChild((BasicModelPart)this.rbarb);
        this.rbarb.setTextureOffset(214, 208).addBox(-1.0f, 0.5f, -1.0f, 2.0f, 17.0f, 2.0f, 0.0f, true);
        this.rbarb2 = new AdvancedModelBox((AdvancedEntityModel)this);
        this.rbarb2.setRotationPoint(0.0f, 17.0f, 0.0f);
        this.rbarb.addChild((BasicModelPart)this.rbarb2);
        this.rbarb2.setTextureOffset(214, 208).addBox(-1.0f, 0.5f, -1.0f, 2.0f, 17.0f, 2.0f, 0.0f, true);
        this.rbarbLure = new AdvancedModelBox((AdvancedEntityModel)this);
        this.rbarbLure.setRotationPoint(0.0f, 17.0f, 0.0f);
        this.rbarb2.addChild((BasicModelPart)this.rbarbLure);
        this.rbarbLure.setTextureOffset(214, 208).addBox(0.0f, 0.5f, -3.0f, 0.0f, 24.0f, 32.0f, 0.0f, true);
        this.rbarbLure.setTextureOffset(30, 4).addBox(-2.5f, 21.5f, 3.0f, 5.0f, 5.0f, 5.0f, 0.0f, true);
        this.lbarb = new AdvancedModelBox((AdvancedEntityModel)this);
        this.lbarb.setRotationPoint(9.0f, -0.5f, -3.0f);
        this.body.addChild((BasicModelPart)this.lbarb);
        this.lbarb.setTextureOffset(214, 208).addBox(-1.0f, 0.5f, -1.0f, 2.0f, 17.0f, 2.0f, 0.0f, false);
        this.lbarb2 = new AdvancedModelBox((AdvancedEntityModel)this);
        this.lbarb2.setRotationPoint(0.0f, 17.0f, 0.0f);
        this.lbarb.addChild((BasicModelPart)this.lbarb2);
        this.lbarb2.setTextureOffset(214, 208).addBox(-1.0f, 0.5f, -1.0f, 2.0f, 17.0f, 2.0f, 0.0f, false);
        this.lbarbLure = new AdvancedModelBox((AdvancedEntityModel)this);
        this.lbarbLure.setRotationPoint(0.0f, 17.0f, 0.0f);
        this.lbarb2.addChild((BasicModelPart)this.lbarbLure);
        this.lbarbLure.setTextureOffset(214, 208).addBox(0.0f, 0.5f, -3.0f, 0.0f, 24.0f, 32.0f, 0.0f, false);
        this.lbarbLure.setTextureOffset(30, 4).addBox(-2.5f, 21.5f, 3.0f, 5.0f, 5.0f, 5.0f, 0.0f, false);
        this.head = new AdvancedModelBox((AdvancedEntityModel)this);
        this.head.setRotationPoint(1.0f, -27.0f, -10.0f);
        this.body.addChild((BasicModelPart)this.head);
        this.head.setTextureOffset(278, 255).addBox(-10.0f, 8.0f, -12.0f, 18.0f, 18.0f, 13.0f, -0.01f, false);
        this.head.setTextureOffset(154, 0).addBox(-11.0f, 0.0f, -52.0f, 20.0f, 26.0f, 53.0f, 0.0f, false);
        this.head.setTextureOffset(0, 304).addBox(-11.0f, 0.0f, -51.0f, 20.0f, 11.0f, 38.0f, 0.0f, false);
        this.teeth1 = new AdvancedModelBox((AdvancedEntityModel)this);
        this.teeth1.setRotationPoint(-1.0f, 15.0f, -51.1464f);
        this.head.addChild((BasicModelPart)this.teeth1);
        this.setRotateAngle(this.teeth1, 0.0f, -0.7854f, 0.0f);
        this.teeth1.setTextureOffset(0, 304).addBox(-6.5f, -4.0f, -6.5f, 13.0f, 8.0f, 13.0f, 0.01f, false);
        this.teeth2 = new AdvancedModelBox((AdvancedEntityModel)this);
        this.teeth2.setRotationPoint(-1.0f, 11.5f, -52.0f);
        this.head.addChild((BasicModelPart)this.teeth2);
        this.setRotateAngle(this.teeth2, 0.0f, 0.7854f, 0.0f);
        this.teeth2.setTextureOffset(278, 240).addBox(-39.0f, -11.44f, -7.0f, 32.0f, 5.0f, 10.0f, 0.07f, true);
        this.teeth3 = new AdvancedModelBox((AdvancedEntityModel)this);
        this.teeth3.setRotationPoint(-1.0f, 11.5f, -52.0f);
        this.head.addChild((BasicModelPart)this.teeth3);
        this.setRotateAngle(this.teeth3, 0.0f, -0.7854f, 0.0f);
        this.teeth3.setTextureOffset(278, 240).addBox(7.0f, -11.44f, -7.0f, 32.0f, 5.0f, 10.0f, 0.07f, false);
        this.teeth3.setTextureOffset(247, 0).addBox(-7.0f, -11.44f, -7.0f, 14.0f, 36.0f, 14.0f, 0.07f, false);
        this.jaw = new AdvancedModelBox((AdvancedEntityModel)this);
        this.jaw.setRotationPoint(-1.0f, 26.0f, -12.0f);
        this.head.addChild((BasicModelPart)this.jaw);
        this.jaw.setTextureOffset(0, 0).addBox(-9.0f, -19.0f, -54.0f, 0.0f, 39.0f, 14.0f, 0.0f, true);
        this.jaw.setTextureOffset(284, 136).addBox(-9.0f, 7.0f, -54.0f, 18.0f, 0.0f, 14.0f, 0.0f, true);
        this.jaw.setTextureOffset(0, 0).addBox(9.0f, -19.0f, -54.0f, 0.0f, 39.0f, 14.0f, 0.0f, false);
        this.jaw.setTextureOffset(214, 180).addBox(-9.0f, 0.0f, -40.0f, 18.0f, 7.0f, 53.0f, 0.0f, false);
        this.teeth4 = new AdvancedModelBox((AdvancedEntityModel)this);
        this.teeth4.setRotationPoint(9.0f, 0.0f, -13.5f);
        this.jaw.addChild((BasicModelPart)this.teeth4);
        this.setRotateAngle(this.teeth4, 0.0f, 0.0f, 0.3927f);
        this.teeth4.setTextureOffset(210, 20).addBox(0.0f, -26.0f, -33.5f, 0.0f, 26.0f, 60.0f, 0.0f, false);
        this.teeth5 = new AdvancedModelBox((AdvancedEntityModel)this);
        this.teeth5.setRotationPoint(-9.0f, 0.0f, -13.5f);
        this.jaw.addChild((BasicModelPart)this.teeth5);
        this.setRotateAngle(this.teeth5, 0.0f, 0.0f, -0.3927f);
        this.teeth5.setTextureOffset(210, 20).addBox(0.0f, -26.0f, -33.5f, 0.0f, 26.0f, 60.0f, 0.0f, true);
        this.updateDefaultPose();
        this.animator = ModelAnimator.create();
    }

    public Iterable<AdvancedModelBox> getAllParts() {
        return ImmutableList.of((Object)this.root, (Object)this.body, (Object)this.body2, (Object)this.tail, (Object)this.head, (Object)this.tail, (Object)this.tail2, (Object)this.tail3, (Object)this.dorsal, (Object)this.dorsal2, (Object)this.jaw, (Object)this.rbarb, (Object[])new AdvancedModelBox[]{this.rbarb2, this.rbarbLure, this.lbarb, this.lbarb2, this.lbarbLure, this.teeth1, this.teeth2, this.teeth3, this.teeth4, this.teeth5, this.rflipper, this.lflipper});
    }

    public Iterable<BasicModelPart> parts() {
        return ImmutableList.of((Object)this.root);
    }

    public void animate(IAnimatedEntity entity) {
        this.animator.update(entity);
        this.animator.setAnimation(HullbreakerEntity.ANIMATION_PUZZLE);
        this.animator.startKeyframe(10);
        this.animator.move(this.head, -5.0f, -5.0f, 0.0f);
        this.animator.rotate(this.head, 0.0f, (float)Math.toRadians(-5.0), (float)Math.toRadians(-20.0));
        this.animator.endKeyframe();
        this.animator.startKeyframe(20);
        this.animator.move(this.head, 5.0f, -5.0f, 0.0f);
        this.animator.rotate(this.head, 0.0f, (float)Math.toRadians(5.0), (float)Math.toRadians(20.0));
        this.animator.endKeyframe();
        this.animator.startKeyframe(20);
        this.animator.move(this.head, -5.0f, -5.0f, 0.0f);
        this.animator.rotate(this.head, 0.0f, (float)Math.toRadians(-5.0), (float)Math.toRadians(-20.0));
        this.animator.endKeyframe();
        this.animator.resetKeyframe(10);
        this.animator.setAnimation(HullbreakerEntity.ANIMATION_BITE);
        this.animator.startKeyframe(10);
        this.animator.move(this.head, 0.0f, -2.0f, 10.0f);
        this.animator.rotate(this.head, (float)Math.toRadians(-40.0), 0.0f, 0.0f);
        this.animator.rotate(this.jaw, (float)Math.toRadians(80.0), 0.0f, 0.0f);
        this.animator.endKeyframe();
        this.animator.startKeyframe(5);
        this.animator.move(this.body, 0.0f, 0.0f, -10.0f);
        this.animator.rotate(this.head, (float)Math.toRadians(-10.0), 0.0f, 0.0f);
        this.animator.rotate(this.jaw, (float)Math.toRadians(10.0), 0.0f, 0.0f);
        this.animator.endKeyframe();
        this.animator.resetKeyframe(5);
        this.animator.setAnimation(HullbreakerEntity.ANIMATION_BASH);
        this.animator.startKeyframe(10);
        this.animator.move(this.head, 0.0f, -11.0f, -3.0f);
        this.animator.rotate(this.body, (float)Math.toRadians(-15.0), 0.0f, 0.0f);
        this.animator.rotate(this.body2, (float)Math.toRadians(15.0), 0.0f, 0.0f);
        this.animator.rotate(this.head, (float)Math.toRadians(50.0), 0.0f, 0.0f);
        this.animator.endKeyframe();
        this.animator.startKeyframe(5);
        this.animator.move(this.body, 0.0f, -5.0f, -20.0f);
        this.animator.move(this.head, 0.0f, -9.0f, -3.0f);
        this.animator.rotate(this.head, (float)Math.toRadians(30.0), 0.0f, 0.0f);
        this.animator.endKeyframe();
        this.animator.resetKeyframe(10);
        this.animator.setAnimation(HullbreakerEntity.ANIMATION_DIE);
        this.animator.startKeyframe(10);
        this.animator.move(this.head, 0.0f, -2.0f, 10.0f);
        this.animator.rotate(this.head, (float)Math.toRadians(-40.0), 0.0f, 0.0f);
        this.animator.rotate(this.jaw, (float)Math.toRadians(80.0), 0.0f, 0.0f);
        this.animator.rotate(this.body, 0.0f, 0.0f, (float)Math.toRadians(5.0));
        this.animator.endKeyframe();
        this.animator.startKeyframe(35);
        this.animator.move(this.head, 0.0f, -2.0f, 10.0f);
        this.animator.rotate(this.head, (float)Math.toRadians(-30.0), 0.0f, (float)Math.toRadians(-20.0));
        this.animator.rotate(this.jaw, (float)Math.toRadians(40.0), 0.0f, 0.0f);
        this.animator.rotate(this.body, 0.0f, 0.0f, (float)Math.toRadians(10.0));
        this.animator.endKeyframe();
        this.animator.resetKeyframe(5);
    }

    public void setupAnim(HullbreakerEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.resetToDefaultPose();
        this.animate(entity);
        float partialTicks = ageInTicks - (float)entity.f_19797_;
        float bodyYRot = entity.f_20884_ + (entity.f_20883_ - entity.f_20884_) * partialTicks;
        float clampedYaw = netHeadYaw / 57.295776f;
        float fishPitchAmount = entity.getFishPitch(partialTicks) / 57.295776f;
        float headPitchAmount = headPitch / 57.295776f;
        float idleSpeed = 0.1f;
        float idleDegree = 0.5f;
        float swimSpeed = 0.45f;
        float swimDegree = 0.4f;
        float landProgress = entity.getLandProgress(partialTicks);
        float stillAmount = (1.0f - limbSwingAmount) * (1.0f - landProgress);
        this.body.rotationPointY -= ACMath.walkValue(ageInTicks, 1.0f, idleSpeed, 1.5f, 3.0f, true) * stillAmount;
        this.walk(this.jaw, idleSpeed, idleDegree * 0.15f, false, 2.0f, 0.2f, ageInTicks, stillAmount);
        this.flap(this.head, idleSpeed, idleDegree * 0.05f, false, 1.0f, 0.0f, ageInTicks, 1.0f);
        this.walk(this.dorsal, idleSpeed, idleDegree * 0.1f, false, 4.0f, -0.1f, ageInTicks, 1.0f);
        this.walk(this.dorsal2, idleSpeed, idleDegree * 0.1f, false, 3.0f, -0.1f, ageInTicks, 1.0f);
        this.walk(this.rbarb, idleSpeed, idleDegree * 0.2f, false, -1.0f, 0.2f, ageInTicks, 1.0f);
        this.walk(this.lbarb, idleSpeed, idleDegree * 0.2f, false, -1.0f, 0.2f, ageInTicks, 1.0f);
        this.walk(this.rbarb2, idleSpeed, idleDegree * 0.2f, false, -1.0f, 0.2f, ageInTicks, 1.0f);
        this.walk(this.lbarb2, idleSpeed, idleDegree * 0.2f, false, -1.0f, 0.2f, ageInTicks, 1.0f);
        this.swing(this.rbarb, idleSpeed, idleDegree * 0.2f, true, -1.0f, 0.2f, ageInTicks, stillAmount);
        this.swing(this.lbarb, idleSpeed, idleDegree * 0.2f, false, -1.0f, 0.2f, ageInTicks, stillAmount);
        this.walk(this.rflipper, idleSpeed * 2.0f, idleDegree * 0.4f, false, 0.0f, 0.0f, ageInTicks, stillAmount);
        this.swing(this.rflipper, idleSpeed * 2.0f, idleDegree * 0.8f, false, 2.0f, -0.25f, ageInTicks, stillAmount);
        this.flap(this.rflipper, idleSpeed * 2.0f, idleDegree * 0.5f, true, 0.0f, 0.2f, ageInTicks, stillAmount);
        this.walk(this.lflipper, idleSpeed * 2.0f, idleDegree * 0.4f, true, 2.0f, 0.0f, ageInTicks, stillAmount);
        this.swing(this.lflipper, idleSpeed * 2.0f, idleDegree * 0.8f, true, 4.0f, -0.25f, ageInTicks, stillAmount);
        this.flap(this.lflipper, idleSpeed * 2.0f, idleDegree * 0.5f, false, 2.0f, 0.2f, ageInTicks, stillAmount);
        this.body.rotationPointY -= ACMath.walkValue(limbSwingAmount, 1.0f, swimSpeed, 1.5f, 6.0f, true);
        this.swing(this.body, swimSpeed, swimDegree * 0.05f, true, 1.0f, 0.0f, limbSwing, limbSwingAmount);
        this.flap(this.body, swimSpeed, swimDegree * 0.05f, true, -1.0f, 0.0f, limbSwing, limbSwingAmount);
        this.walk(this.head, swimSpeed, swimDegree * 0.1f, true, 2.0f, 0.1f, limbSwing, limbSwingAmount);
        this.walk(this.jaw, swimSpeed, swimDegree * 0.1f, true, 3.0f, -0.1f, limbSwing, limbSwingAmount);
        this.walk(this.dorsal, swimSpeed, swimDegree * 0.2f, true, 2.0f, 0.4f, limbSwing, limbSwingAmount);
        this.walk(this.dorsal2, swimSpeed, swimDegree * 0.2f, true, 1.0f, 0.4f, limbSwing, limbSwingAmount);
        this.walk(this.rbarb, swimSpeed, swimDegree * 0.01f, false, -1.0f, 0.9f, limbSwing, limbSwingAmount);
        this.walk(this.lbarb, swimSpeed, swimDegree * 0.01f, false, -1.0f, 0.9f, limbSwing, limbSwingAmount);
        this.swing(this.rflipper, swimSpeed, swimDegree * 1.0f, false, -1.0f, 0.3f, limbSwing, limbSwingAmount);
        this.swing(this.lflipper, swimSpeed, swimDegree * 1.0f, false, -1.0f, -0.3f, limbSwing, limbSwingAmount);
        this.flap(this.rflipper, swimSpeed, swimDegree * 0.5f, true, -2.5f, 0.2f, limbSwing, limbSwingAmount);
        this.flap(this.lflipper, swimSpeed, swimDegree * 0.5f, false, -2.5f, 0.2f, limbSwing, limbSwingAmount);
        this.progressPositionPrev(this.root, landProgress, 0.0f, 17.0f, 0.0f, 1.0f);
        this.progressPositionPrev(this.head, landProgress, 0.0f, -5.0f, 0.0f, 1.0f);
        this.progressRotationPrev(this.head, landProgress, (float)Math.toRadians(-10.0), 0.0f, (float)Math.toRadians(30.0), 1.0f);
        this.progressRotationPrev(this.body, landProgress, 0.0f, 0.0f, (float)Math.toRadians(-40.0), 1.0f);
        this.progressRotationPrev(this.body2, landProgress, 0.0f, 0.0f, (float)Math.toRadians(-30.0), 1.0f);
        this.progressRotationPrev(this.tail, landProgress, 0.0f, (float)Math.toRadians(-10.0), (float)Math.toRadians(-20.0), 1.0f);
        this.progressRotationPrev(this.tail2, landProgress, 0.0f, (float)Math.toRadians(5.0), 0.0f, 1.0f);
        this.progressRotationPrev(this.rflipper, landProgress, 0.0f, (float)Math.toRadians(40.0), 0.0f, 1.0f);
        this.progressRotationPrev(this.lflipper, landProgress, 0.0f, (float)Math.toRadians(-40.0), 0.0f, 1.0f);
        this.progressRotationPrev(this.rbarb, landProgress, (float)Math.toRadians(20.0), 0.0f, (float)Math.toRadians(-60.0), 1.0f);
        this.progressRotationPrev(this.lbarb, landProgress, 0.0f, 0.0f, (float)Math.toRadians(-40.0), 1.0f);
        this.body.rotateAngleX += fishPitchAmount * 0.75f;
        this.head.rotateAngleX += headPitchAmount;
        this.head.rotateAngleY += clampedYaw;
        if (!this.straighten) {
            this.body2.rotateAngleX = (float)((double)this.body2.rotateAngleX + Math.toRadians(entity.tail1Part.calculateAnimationAngle(partialTicks, true)));
            this.body2.rotateAngleY = (float)((double)this.body2.rotateAngleY + Math.toRadians(entity.tail1Part.calculateAnimationAngle(partialTicks, false)));
            this.tail.rotateAngleX = (float)((double)this.tail.rotateAngleX + Math.toRadians(entity.tail2Part.calculateAnimationAngle(partialTicks, true)));
            this.tail.rotateAngleY = (float)((double)this.tail.rotateAngleY + Math.toRadians(entity.tail2Part.calculateAnimationAngle(partialTicks, false)));
            float tail2XRot = entity.tail3Part.calculateAnimationAngle(partialTicks, true);
            float tail3XRot = entity.tail4Part.calculateAnimationAngle(partialTicks, true);
            this.tail2.rotateAngleX = (float)((double)this.tail2.rotateAngleX + Math.toRadians(tail2XRot));
            this.tail2.rotationPointZ -= 5.0f * Math.abs(tail2XRot / 20.0f);
            this.tail2.rotateAngleY = (float)((double)this.tail2.rotateAngleY + Math.toRadians(entity.tail3Part.calculateAnimationAngle(partialTicks, false)));
            this.tail3.rotateAngleX = (float)((double)this.tail3.rotateAngleX + Math.toRadians(tail3XRot));
            this.tail3.rotationPointZ -= 5.0f * Math.abs(tail3XRot / 20.0f);
            this.tail3.rotateAngleY = (float)((double)this.tail3.rotateAngleY + Math.toRadians(entity.tail4Part.calculateAnimationAngle(partialTicks, false)));
            this.lbarb.rotateAngleY = (float)((double)this.lbarb.rotateAngleY + Math.toRadians(entity.getYawFromBuffer(2, partialTicks) - bodyYRot));
            this.rbarb.rotateAngleY = (float)((double)this.rbarb.rotateAngleY + Math.toRadians(entity.getYawFromBuffer(2, partialTicks) - bodyYRot));
            this.lbarb2.rotateAngleY = (float)((double)this.lbarb2.rotateAngleY + Math.toRadians(entity.getYawFromBuffer(4, partialTicks) - bodyYRot));
            this.rbarb2.rotateAngleY = (float)((double)this.rbarb2.rotateAngleY + Math.toRadians(entity.getYawFromBuffer(4, partialTicks) - bodyYRot));
        }
    }
}

