/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.client.gui;

import com.github.alexmodguy.alexscaves.client.gui.ColorBlitHelper;
import com.github.alexmodguy.alexscaves.server.misc.ACMath;
import java.util.Locale;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.DisplayInfo;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.advancements.AdvancementWidget;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;

public class ACAdvancementTabs {
    private static final float MAX_TRANSITION_TIME = 25.0f;
    private static Type hoverType = Type.DEFAULT;
    private static Type previousHoverType = Type.DEFAULT;
    private static float hoverChangeProgress = 25.0f;
    private static float previousHoverChangeProgress = 25.0f;
    private static int windowWidth;
    private static int windowHeight;
    private static boolean[][] foregroundBlocks;

    public static boolean isAlexsCavesWidget(Advancement root) {
        return root.m_138327_().m_135827_().equals("alexscaves");
    }

    public static void renderTabBackground(GuiGraphics guiGraphics, int topX, int topY, DisplayInfo displayInfo, double scrollX, double scrollY) {
        float partialTick = Minecraft.m_91087_().getPartialTick();
        float hoverProgress = ACAdvancementTabs.getHoverChangeAmount(partialTick);
        float priorHoverProgress = 1.0f - hoverProgress;
        int fastColor = FastColor.ARGB32.m_269105_((float)hoverProgress, (int)ACAdvancementTabs.previousHoverType.backgroundColor, (int)ACAdvancementTabs.hoverType.backgroundColor);
        guiGraphics.m_280509_(0, 0, windowWidth + 100, windowHeight, fastColor | 0xFF000000);
        ACAdvancementTabs.renderTabBackgroundForType(guiGraphics, topX, topY, partialTick, scrollX, scrollY, previousHoverType, priorHoverProgress);
        ACAdvancementTabs.renderTabBackgroundForType(guiGraphics, topX, topY, partialTick, scrollX, scrollY, hoverType, hoverProgress);
    }

    private static void renderTabBackgroundForType(GuiGraphics guiGraphics, int topX, int topY, float partialTick, double scrollX, double scrollY, Type type, float alpha) {
        int j;
        int i;
        guiGraphics.m_280168_().m_85836_();
        if (type != Type.DEFAULT) {
            i = (int)Math.round(scrollX);
            j = (int)Math.round(scrollY);
            for (int parallaxX = -1; parallaxX <= (windowWidth + 128) / 128; ++parallaxX) {
                for (int parallaxY = -1; parallaxY <= (windowWidth + 128) / 128; ++parallaxY) {
                    ColorBlitHelper.blitWithColor(guiGraphics, type.background, parallaxX * 128 + i / 4, parallaxY * 128 + j / 4, 0.0f, 0.0f, 128, 128, 128, 128, 1.0f, 1.0f, 1.0f, alpha);
                    ColorBlitHelper.blitWithColor(guiGraphics, type.midground, parallaxX * 128 + i / 2 - 1, parallaxY * 128 + j / 2, 0.0f, 0.0f, 128, 128, 128, 128, 1.0f, 1.0f, 1.0f, alpha);
                }
            }
        }
        i = Mth.m_14107_((double)scrollX);
        j = Mth.m_14107_((double)scrollY);
        int scrollPixelOffsetX = i % 16;
        int scrollPixelOffsetY = j % 16;
        int blockCoordOffsetX = i / 16;
        int blockCoordOffsetY = j / 16;
        int screenWidthInBlocks = windowWidth / 16 + 6;
        int screenHeightInBlocks = windowHeight / 16 + 6;
        for (int relativeBlockX = -2; relativeBlockX <= screenWidthInBlocks; ++relativeBlockX) {
            for (int relativeBlockY = -2; relativeBlockY <= screenHeightInBlocks; ++relativeBlockY) {
                int blockX = relativeBlockX - blockCoordOffsetX;
                int blockY = relativeBlockY - blockCoordOffsetY;
                if (type != Type.DEFAULT && ACAdvancementTabs.isBlockCarvedOut(blockX, blockY, type)) continue;
                ColorBlitHelper.blitWithColor(guiGraphics, type.baseStone, 16 * relativeBlockX + scrollPixelOffsetX, 16 * relativeBlockY + scrollPixelOffsetY, 0.0f, 0.0f, 16, 16, 16, 16, 1.0f, 1.0f, 1.0f, alpha);
            }
        }
        guiGraphics.m_280168_().m_85849_();
    }

    private static boolean isBlockCarvedOut(int blockX, int blockY, Type type) {
        int biomeTypeOffset = type.ordinal() * 120;
        float noise = ACMath.sampleNoise2D(blockX + biomeTypeOffset, blockY + biomeTypeOffset, 20.0f);
        return noise < -0.25f || noise > 0.25f;
    }

    public static void tick() {
        previousHoverChangeProgress = hoverChangeProgress;
        if (previousHoverType != hoverType) {
            if (hoverChangeProgress < 25.0f) {
                hoverChangeProgress += 1.0f;
            } else if (hoverChangeProgress > 25.0f) {
                previousHoverType = hoverType;
            }
        } else {
            hoverChangeProgress = 25.0f;
        }
    }

    private static float getHoverChangeAmount(float partialTick) {
        return (previousHoverChangeProgress + (hoverChangeProgress - previousHoverChangeProgress) * partialTick) / 25.0f;
    }

    public static void setHoverType(Type type) {
        if (hoverChangeProgress >= 25.0f && type != hoverType) {
            previousHoverChangeProgress = 0.0f;
            hoverChangeProgress = 0.0f;
            previousHoverType = hoverType;
            hoverType = type;
        }
    }

    public static void setDimensions(int width, int height) {
        windowWidth = width;
        windowHeight = height;
    }

    public static enum Type {
        DEFAULT(new ResourceLocation("alexscaves", "alexscaves/root"), 0, new ResourceLocation("textures/block/stone.png")),
        MAGNETIC(new ResourceLocation("alexscaves", "alexscaves/discover_magnetic_caves"), 394759, new ResourceLocation("alexscaves", "textures/block/galena.png")),
        PRIMORDIAL(new ResourceLocation("alexscaves", "alexscaves/discover_primordial_caves"), 15915104, new ResourceLocation("alexscaves", "textures/block/limestone.png")),
        TOXIC(new ResourceLocation("alexscaves", "alexscaves/discover_toxic_caves"), 8322816, new ResourceLocation("alexscaves", "textures/block/radrock.png")),
        ABYSSAL(new ResourceLocation("alexscaves", "alexscaves/discover_abyssal_chasm"), 70711, new ResourceLocation("alexscaves", "textures/block/abyssmarine.png")),
        FORLORN(new ResourceLocation("alexscaves", "alexscaves/discover_forlorn_hollows"), 1380622, new ResourceLocation("alexscaves", "textures/block/guanostone.png")),
        CANDY(new ResourceLocation("alexscaves", "alexscaves/discover_candy_cavity"), 16225738, new ResourceLocation("alexscaves", "textures/block/block_of_chocolate.png"));

        ResourceLocation root;
        private final int backgroundColor;
        private final ResourceLocation baseStone;
        private final ResourceLocation midground;
        private final ResourceLocation background;

        private Type(ResourceLocation root, int backgroundColor, ResourceLocation baseStone) {
            this.root = root;
            this.backgroundColor = backgroundColor;
            this.baseStone = baseStone;
            this.midground = this.generateTexture("midground");
            this.background = this.generateTexture("background");
        }

        private ResourceLocation generateTexture(String type) {
            return this == DEFAULT ? null : new ResourceLocation("alexscaves", "textures/misc/advancement/" + this.name().toLowerCase(Locale.ROOT) + "_" + type + ".png");
        }

        private static Type getDirectType(Advancement advancement) {
            for (Type type : Type.values()) {
                if (!type.root.equals((Object)advancement.m_138327_())) continue;
                return type;
            }
            return DEFAULT;
        }

        public static Type forAdvancement(Advancement advancement) {
            Type direct = Type.getDirectType(advancement);
            Advancement next = advancement;
            while (direct == DEFAULT && next.m_138319_() != null) {
                next = next.m_138319_();
                direct = Type.getDirectType(next);
            }
            return direct;
        }

        public static boolean isTreeNodeUnlocked(AdvancementWidget advancementWidget) {
            if (advancementWidget.f_97250_.m_8193_()) {
                return true;
            }
            Type direct = Type.getDirectType(advancementWidget.f_97242_);
            AdvancementWidget next = advancementWidget;
            while (direct == DEFAULT && next.f_97242_.m_138319_() != null) {
                next = next.f_97248_;
                direct = Type.getDirectType(next.f_97242_);
            }
            return direct == DEFAULT || next.f_97250_ != null && next.f_97250_.m_8193_();
        }
    }
}

