/*
 * Decompiled with CFR 0.152.
 */
package sereneseasons.init;

import glitchcore.event.EventManager;
import glitchcore.event.client.RegisterColorsEvent;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.item.ClampedItemPropertyFunction;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.renderer.item.ItemPropertyFunction;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.FoliageColor;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import sereneseasons.api.SSItems;
import sereneseasons.api.season.ISeasonState;
import sereneseasons.api.season.SeasonHelper;
import sereneseasons.init.ModConfig;
import sereneseasons.init.ModFertility;
import sereneseasons.init.ModTags;
import sereneseasons.season.SeasonColorHandlers;
import sereneseasons.season.SeasonHandlerClient;
import sereneseasons.season.SeasonTime;
import sereneseasons.util.SeasonColorUtil;

public class ModClient {
    public static void setup() {
        SeasonColorHandlers.setup();
    }

    public static void addClientHandlers() {
        EventManager.addListener(SeasonHandlerClient::onClientTick);
        EventManager.addListener(ModFertility::setupTooltips);
        EventManager.addListener(ModClient::registerBlockColors);
    }

    public static void registerItemProperties() {
        ItemProperties.register((Item)SSItems.CALENDAR, (ResourceLocation)new ResourceLocation("sereneseasons", "time"), (ItemPropertyFunction)new ClampedItemPropertyFunction(){

            public float m_142187_(ItemStack stack, ClientLevel clientWorld, LivingEntity entity, int seed) {
                LivingEntity holder;
                ClientLevel world = clientWorld;
                Object object = holder = entity != null ? entity : stack.m_41795_();
                if (world == null && holder != null) {
                    world = holder.m_9236_();
                }
                if (world == null) {
                    return 0.0f;
                }
                int seasonCycleTicks = SeasonHelper.getSeasonState((Level)world).getSeasonCycleTicks();
                double d0 = (float)seasonCycleTicks / (float)SeasonTime.ZERO.getCycleDuration();
                return Mth.m_14091_((float)((float)d0), (float)1.0f);
            }
        });
        ItemProperties.register((Item)SSItems.CALENDAR, (ResourceLocation)new ResourceLocation("sereneseasons", "seasontype"), (ItemPropertyFunction)new ClampedItemPropertyFunction(){

            public float m_142187_(ItemStack stack, ClientLevel clientWorld, LivingEntity entity, int seed) {
                Holder biome;
                LivingEntity holder;
                ClientLevel level = clientWorld;
                Object object = holder = entity != null ? entity : stack.m_41795_();
                if (level == null && holder != null) {
                    level = holder.m_9236_();
                }
                if (level == null) {
                    return 2.0f;
                }
                float type = ModConfig.seasons.isDimensionWhitelisted((ResourceKey<Level>)level.m_46472_()) ? (holder != null ? ((biome = level.m_204166_(holder.m_20183_())).m_203656_(ModTags.Biomes.TROPICAL_BIOMES) ? 1.0f : 0.0f) : 0.0f) : 2.0f;
                return type;
            }
        });
    }

    private static void registerBlockColors(RegisterColorsEvent.Block event) {
        event.register((state, dimensionReader, pos, tintIndex) -> {
            Holder biome;
            int birchColor = FoliageColor.m_46112_();
            Level level = Minecraft.m_91087_().f_91074_.m_9236_();
            ResourceKey dimension = Minecraft.m_91087_().f_91074_.m_9236_().m_46472_();
            if (level != null && pos != null && ModConfig.seasons.changeBirchColor && ModConfig.seasons.isDimensionWhitelisted((ResourceKey<Level>)dimension) && !(biome = level.m_204166_(pos)).m_203656_(ModTags.Biomes.BLACKLISTED_BIOMES)) {
                ISeasonState calendar = SeasonHelper.getSeasonState(level);
                Enum colorProvider = biome.m_203656_(ModTags.Biomes.TROPICAL_BIOMES) ? calendar.getTropicalSeason() : calendar.getSubSeason();
                birchColor = colorProvider.getBirchColor();
                if (biome.m_203656_(ModTags.Biomes.LESSER_COLOR_CHANGE_BIOMES)) {
                    birchColor = SeasonColorUtil.mixColours(colorProvider.getBirchColor(), FoliageColor.m_46112_(), 0.75f);
                }
            }
            return birchColor;
        }, (Object[])new Block[]{Blocks.f_50052_});
    }
}

