/*
 * Decompiled with CFR 0.152.
 */
package com.onesaw.drinkupgrade;

import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegisterEvent;
import net.minecraftforge.registries.RegistryObject;
import net.p3pp3rf1y.sophisticatedbackpacks.init.ModItems;
import net.p3pp3rf1y.sophisticatedcore.client.gui.UpgradeGuiManager;
import net.p3pp3rf1y.sophisticatedcore.common.gui.UpgradeContainerRegistry;
import net.p3pp3rf1y.sophisticatedcore.common.gui.UpgradeContainerType;
import net.p3pp3rf1y.sophisticatedcore.upgrades.IUpgradeCountLimitConfig;
import net.p3pp3rf1y.sophisticatedcore.upgrades.UpgradeGroup;
import org.jetbrains.annotations.Nullable;
import upgrades.drink.DrinkUpgradeContainer;
import upgrades.drink.DrinkUpgradeItem;
import upgrades.drink.DrinkUpgradeTab;
import upgrades.drink.DrinkUpgradeWrapper;

@Mod(value="drinkupgrade")
public class DrinkUpgradeMod {
    public static final String MODID = "drinkupgrade";
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"drinkupgrade");
    private static final IUpgradeCountLimitConfig LIMIT_ONE = new IUpgradeCountLimitConfig(){

        public int getMaxUpgradesPerStorage(String id, @Nullable ResourceLocation type) {
            return 1;
        }

        public int getMaxUpgradesInGroupPerStorage(String id, UpgradeGroup group) {
            return Integer.MAX_VALUE;
        }
    };
    public static final RegistryObject<DrinkUpgradeItem> DRINK_UPGRADE = ITEMS.register("drink_upgrade", () -> new DrinkUpgradeItem(() -> 9, LIMIT_ONE));
    public static final RegistryObject<DrinkUpgradeItem> ADVANCED_DRINK_UPGRADE = ITEMS.register("advanced_drink_upgrade", () -> new DrinkUpgradeItem(() -> 16, LIMIT_ONE));
    private static final UpgradeContainerType<DrinkUpgradeWrapper, DrinkUpgradeContainer> DRINK_TYPE = new UpgradeContainerType(DrinkUpgradeContainer::new);

    public DrinkUpgradeMod() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        bus.addListener(this::registerContainers);
        bus.addListener(this::addCreative);
        ITEMS.register(bus);
    }

    private void addCreative(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() == ModItems.CREATIVE_TAB.getKey()) {
            event.accept(DRINK_UPGRADE);
            event.accept(ADVANCED_DRINK_UPGRADE);
        }
    }

    private void registerContainers(RegisterEvent event) {
        if (!event.getRegistryKey().equals((Object)ForgeRegistries.Keys.MENU_TYPES)) {
            return;
        }
        UpgradeContainerRegistry.register((ResourceLocation)DRINK_UPGRADE.getId(), DRINK_TYPE);
        UpgradeContainerRegistry.register((ResourceLocation)ADVANCED_DRINK_UPGRADE.getId(), DRINK_TYPE);
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> UpgradeGuiManager.registerTab(DRINK_TYPE, DrinkUpgradeTab::construct));
    }
}

