/*
 * Decompiled with CFR 0.152.
 */
package team.creative.ambientsounds;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.util.concurrent.CompletableFuture;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ReloadableResourceManager;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraftforge.fml.common.Mod;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import team.creative.ambientsounds.AmbientSoundsConfig;
import team.creative.ambientsounds.engine.AmbientEngine;
import team.creative.ambientsounds.engine.AmbientTickHandler;
import team.creative.creativecore.CreativeCore;
import team.creative.creativecore.ICreativeLoader;
import team.creative.creativecore.client.ClientLoader;
import team.creative.creativecore.client.CreativeCoreClient;

@Mod(value="ambientsounds")
public class AmbientSounds
implements ClientLoader {
    public static final Logger LOGGER = LogManager.getLogger((String)"ambientsounds");
    public static final String MODID = "ambientsounds";
    public static final AmbientSoundsConfig CONFIG = new AmbientSoundsConfig();
    public static AmbientTickHandler TICK_HANDLER;

    public AmbientSounds() {
        ICreativeLoader loader = CreativeCore.loader();
        loader.registerClient((ClientLoader)this);
    }

    public static void scheduleReload() {
        TICK_HANDLER.scheduleReload();
    }

    public static void reloadAsync() {
        CompletableFuture.runAsync(AmbientSounds::reload, Util.m_183991_());
    }

    private static synchronized void reload() {
        if (AmbientSounds.TICK_HANDLER.engine != null) {
            AmbientSounds.TICK_HANDLER.engine.stopEngine();
        }
        if (AmbientSounds.TICK_HANDLER.environment != null) {
            AmbientSounds.TICK_HANDLER.environment.reload();
        }
        TICK_HANDLER.setEngine(AmbientEngine.loadAmbientEngine(AmbientSounds.TICK_HANDLER.soundEngine));
    }

    public void onInitializeClient() {
        ICreativeLoader loader = CreativeCore.loader();
        loader.registerDisplayTest(() -> loader.ignoreServerNetworkConstant(), (a, b) -> true);
        TICK_HANDLER = new AmbientTickHandler();
        loader.registerClientTick(TICK_HANDLER::onTick);
        loader.registerClientRenderGui(TICK_HANDLER::onRender);
        loader.registerLoadLevel(TICK_HANDLER::loadLevel);
        loader.registerClientStarted(() -> {
            Minecraft minecraft = Minecraft.m_91087_();
            ReloadableResourceManager reloadableResourceManager = (ReloadableResourceManager)minecraft.m_91098_();
            reloadableResourceManager.m_7217_((PreparableReloadListener)new SimplePreparableReloadListener<Void>(){

                protected Void prepare(@NotNull ResourceManager resourceManager, @NotNull ProfilerFiller profilerFiller) {
                    AmbientSounds.reloadAsync();
                    return null;
                }

                protected void apply(Void object, @NotNull ResourceManager resourceManager, @NotNull ProfilerFiller profilerFiller) {
                }
            });
        });
        CreativeCoreClient.registerClientConfig((String)MODID);
    }

    public <T> void registerClientCommands(CommandDispatcher<T> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"ambient-debug").executes(x -> {
            AmbientSounds.TICK_HANDLER.showDebugInfo = !AmbientSounds.TICK_HANDLER.showDebugInfo;
            return 1;
        }));
        dispatcher.register((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"ambient-reload").executes(x -> {
            AmbientSounds.reloadAsync();
            return 1;
        }));
    }
}

