/*
 * Decompiled with CFR 0.152.
 */
package com.obscuria.obscureapi.api.common.classes;

import com.obscuria.obscureapi.api.ClassManager;
import com.obscuria.obscureapi.api.common.classes.ObscureClass;
import com.obscuria.obscureapi.api.common.classes.ObscureType;
import com.obscuria.obscureapi.util.ClassUtils;
import com.obscuria.obscureapi.util.TextUtils;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import org.jetbrains.annotations.Contract;

public class Bonus {
    private final ObscureClass ITEM_CLASS;
    private final ObscureType ITEM_TYPE;
    private final Type TYPE;
    private final Operation OPERATION;
    private final int VALUE;

    @Contract(pure=true)
    private Bonus(@Nonnull Builder builder) {
        this.ITEM_CLASS = builder.itemClass;
        this.ITEM_TYPE = builder.itemType;
        this.TYPE = builder.type;
        this.OPERATION = builder.operation;
        this.VALUE = builder.value;
    }

    @Nonnull
    @Contract(value=" -> new")
    public static Builder create() {
        return new Builder();
    }

    public String getBonusString() {
        return TextUtils.translation("class_bonus." + this.ITEM_TYPE.getName() + "_" + this.TYPE.getName() + "." + (this.VALUE >= 0 ? "plus" : "minus")).replace("#", this.VALUE + this.OPERATION.getName());
    }

    public boolean canBeApplied(Item item) {
        return ClassUtils.isClassItem(item) && ClassUtils.getItemClass(item).equals(this.ITEM_CLASS) && ClassUtils.getItemType(item).equals(this.ITEM_TYPE);
    }

    public boolean canBeApplied(@Nonnull ObscureClass itemClass, ObscureType itemType) {
        return itemClass.equals(this.ITEM_CLASS) && itemType.equals(this.ITEM_TYPE);
    }

    public boolean canBeApplied(ObscureClass itemClass, ObscureType itemType, Type type, Operation operation) {
        return this.canBeApplied(itemClass, itemType) && type.equals((Object)this.TYPE) && operation.equals((Object)this.OPERATION);
    }

    public ObscureClass getObscureClass() {
        return this.ITEM_CLASS;
    }

    public ObscureType getObscureType() {
        return this.ITEM_TYPE;
    }

    public Type getType() {
        return this.TYPE;
    }

    public Operation getOperation() {
        return this.OPERATION;
    }

    public int getValue() {
        return this.VALUE;
    }

    public static class Builder {
        private ObscureClass itemClass = ClassManager.BLANK;
        private ObscureType itemType = ObscureType.create("blank");
        private Type type = Type.POWER;
        private Operation operation = Operation.AMOUNT;
        private int value;

        private Builder() {
        }

        public Builder target(String itemClass, String itemType) {
            return this.target(ClassManager.get(new ResourceLocation(itemClass)), ObscureType.create(itemType));
        }

        public Builder target(ObscureClass itemClass, String itemType) {
            return this.target(itemClass, ObscureType.create(itemType));
        }

        public Builder target(ObscureClass itemClass, ObscureType itemType) {
            this.itemClass = itemClass;
            this.itemType = itemType;
            return this;
        }

        public Builder type(Type type, Operation operation) {
            this.type = type;
            this.operation = operation;
            return this;
        }

        public Builder value(int v) {
            this.value = v;
            return this;
        }

        public Bonus build() {
            return new Bonus(this);
        }
    }

    public static enum Type {
        POWER("power"),
        COOLDOWN("cooldown");

        private final String NAME;

        private Type(String name) {
            this.NAME = name;
        }

        public String getName() {
            return this.NAME;
        }
    }

    public static enum Operation {
        AMOUNT(""),
        PERCENT("%");

        private final String NAME;

        private Operation(String name) {
            this.NAME = name;
        }

        public String getName() {
            return this.NAME;
        }
    }
}

