/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.fuel.tank;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.railwayteam.railways.content.fuel.tank.FuelTankBlockEntity;
import com.railwayteam.railways.registry.forge.CRMountedStorageTypesImpl;
import com.simibubi.create.api.contraption.storage.SyncedMountedStorage;
import com.simibubi.create.api.contraption.storage.fluid.MountedFluidStorageType;
import com.simibubi.create.api.contraption.storage.fluid.WrapperMountedFluidStorage;
import com.simibubi.create.content.contraptions.Contraption;
import java.util.Objects;
import net.createmod.catnip.animation.LerpedFloat;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import org.jetbrains.annotations.Nullable;

public class FuelTankMountedStorage
extends WrapperMountedFluidStorage<Handler>
implements SyncedMountedStorage {
    public static final Codec<FuelTankMountedStorage> CODEC = RecordCodecBuilder.create(i -> i.group((App)ExtraCodecs.f_144628_.fieldOf("capacity").forGetter(FuelTankMountedStorage::getCapacity), (App)FluidStack.CODEC.fieldOf("fluid").forGetter(FuelTankMountedStorage::getFluid)).apply((Applicative)i, FuelTankMountedStorage::new));
    private boolean dirty;

    protected FuelTankMountedStorage(int capacity, FluidStack stack) {
        super((MountedFluidStorageType)CRMountedStorageTypesImpl.FUEL_TANK.get(), (IFluidHandler)new Handler(capacity, stack));
        ((Handler)this.wrapped).onChange = () -> {
            this.dirty = true;
        };
    }

    public void unmount(Level level, BlockState state, BlockPos pos, @Nullable BlockEntity be) {
        FuelTankBlockEntity tank;
        if (be instanceof FuelTankBlockEntity && (tank = (FuelTankBlockEntity)be).isController()) {
            FluidTank inventory = tank.getTankInventory();
            inventory.setFluid(((Handler)this.wrapped).getFluid());
        }
    }

    public FluidStack getFluid() {
        return Objects.requireNonNull(((Handler)this.wrapped).getFluid());
    }

    public int getCapacity() {
        return ((Handler)this.wrapped).getCapacity();
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void markClean() {
        this.dirty = false;
    }

    public void afterSync(Contraption contraption, BlockPos localPos) {
        BlockEntity be = contraption.getOrCreateClientContraptionLazy().getBlockEntity(localPos);
        if (!(be instanceof FuelTankBlockEntity)) {
            return;
        }
        FuelTankBlockEntity tank = (FuelTankBlockEntity)be;
        FluidTank inv = tank.getTankInventory();
        inv.setFluid(this.getFluid());
        float fillLevel = (float)inv.getFluidAmount() / (float)inv.getCapacity();
        if (tank.getFluidLevel() == null) {
            tank.setFluidLevel(LerpedFloat.linear().startWithValue((double)fillLevel));
        }
        tank.getFluidLevel().chase((double)fillLevel, 0.5, LerpedFloat.Chaser.EXP);
    }

    public static FuelTankMountedStorage fromTank(FuelTankBlockEntity tank) {
        FluidTank inventory = tank.getTankInventory();
        return new FuelTankMountedStorage(inventory.getCapacity(), inventory.getFluid().copy());
    }

    public static FuelTankMountedStorage fromLegacy(CompoundTag nbt) {
        int capacity = nbt.m_128451_("Capacity");
        FluidStack fluid = FluidStack.loadFluidStackFromNBT((CompoundTag)nbt);
        return new FuelTankMountedStorage(capacity, fluid);
    }

    public static final class Handler
    extends FluidTank {
        private Runnable onChange = () -> {};

        public Handler(int capacity, FluidStack stack) {
            super(capacity);
            Objects.requireNonNull(stack);
            this.setFluid(stack);
        }

        protected void onContentsChanged() {
            this.onChange.run();
        }
    }
}

