/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.dataObjects.render.bufferBuilding;

import com.seibel.distanthorizons.core.config.Config;
import com.seibel.distanthorizons.core.dataObjects.render.bufferBuilding.LodQuadBuilder;
import com.seibel.distanthorizons.core.dataObjects.render.columnViews.ColumnArrayView;
import com.seibel.distanthorizons.core.dependencyInjection.SingletonInjector;
import com.seibel.distanthorizons.core.enums.EDhDirection;
import com.seibel.distanthorizons.core.level.IDhClientLevel;
import com.seibel.distanthorizons.core.pooling.PhantomArrayListCheckout;
import com.seibel.distanthorizons.core.util.ColorUtil;
import com.seibel.distanthorizons.core.util.RenderDataPointUtil;
import com.seibel.distanthorizons.core.wrapperInterfaces.minecraft.IMinecraftRenderWrapper;
import com.seibel.distanthorizons.coreapi.util.MathUtil;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongList;
import org.jetbrains.annotations.NotNull;

public class ColumnBox {
    private static final IMinecraftRenderWrapper MC_RENDER = SingletonInjector.INSTANCE.get(IMinecraftRenderWrapper.class);
    private static final byte SKYLIGHT_COVERED = -1;

    public static void addBoxQuadsToBuilder(LodQuadBuilder builder, PhantomArrayListCheckout phantomArrayCheckout, IDhClientLevel clientLevel, short width, short yHeight, short minX, short minY, short minZ, int color, byte irisBlockMaterialId, byte skyLight, byte blockLight, long topData, long bottomData, ColumnArrayView[] adjData, boolean[] isAdjDataSameDetailLevel) {
        boolean skipBottom;
        boolean skipTop;
        short maxX = (short)(minX + width);
        short maxY = (short)(minY + yHeight);
        short maxZ = (short)(minZ + width);
        byte skyLightTop = skyLight;
        byte skyLightBot = RenderDataPointUtil.doesDataPointExist(bottomData) ? RenderDataPointUtil.getLightSky(bottomData) : (byte)0;
        boolean transparencyEnabled = Config.Client.Advanced.Graphics.Quality.transparency.get().transparencyEnabled;
        boolean fakeOceanFloor = Config.Client.Advanced.Graphics.Quality.transparency.get().fakeTransparencyEnabled;
        boolean isTransparent = ColorUtil.getAlpha(color) < 255 && transparencyEnabled;
        boolean overVoid = !RenderDataPointUtil.doesDataPointExist(bottomData);
        boolean isTopTransparent = RenderDataPointUtil.getAlpha(topData) < 255 && transparencyEnabled;
        boolean isBottomTransparent = RenderDataPointUtil.getAlpha(bottomData) < 255 && transparencyEnabled;
        int caveCullingMaxY = Integer.MIN_VALUE;
        if (Config.Client.Advanced.Graphics.Culling.enableCaveCulling.get().booleanValue()) {
            caveCullingMaxY = Config.Client.Advanced.Graphics.Culling.caveCullingHeight.get() - clientLevel.getLevelWrapper().getMinHeight();
        }
        if (!RenderDataPointUtil.doesDataPointExist(bottomData)) {
            color = ColorUtil.setAlpha(color, 255);
        }
        if (transparencyEnabled && fakeOceanFloor) {
            if (!isTransparent && isTopTransparent && RenderDataPointUtil.doesDataPointExist(topData)) {
                skyLightTop = (byte)MathUtil.clamp(0, 15 - (RenderDataPointUtil.getYMax(topData) - minY), 15);
                yHeight = (short)(RenderDataPointUtil.getYMax(topData) - minY - 1);
            } else if (isTransparent && !isBottomTransparent && RenderDataPointUtil.doesDataPointExist(bottomData)) {
                minY = (short)(minY + yHeight - 1);
                yHeight = 1;
            }
            maxY = (short)(minY + yHeight);
        }
        boolean bl = skipTop = RenderDataPointUtil.doesDataPointExist(topData) && RenderDataPointUtil.getYMin(topData) == maxY && !isTopTransparent;
        if (!skipTop) {
            builder.addQuadUp(minX, maxY, minZ, width, width, ColorUtil.applyShade(color, MC_RENDER.getShade(EDhDirection.UP)), irisBlockMaterialId, skyLightTop, blockLight);
        }
        boolean bl2 = skipBottom = RenderDataPointUtil.doesDataPointExist(bottomData) && RenderDataPointUtil.getYMax(bottomData) == minY && !isBottomTransparent;
        if (!skipBottom) {
            builder.addQuadDown(minX, minY, minZ, width, width, ColorUtil.applyShade(color, MC_RENDER.getShade(EDhDirection.DOWN)), irisBlockMaterialId, skyLightBot, blockLight);
        }
        ColumnArrayView adjCol = adjData[EDhDirection.NORTH.compassIndex];
        boolean adjSameDetailLevel = isAdjDataSameDetailLevel[EDhDirection.NORTH.compassIndex];
        if (adjCol == null) {
            if (!isTransparent || overVoid) {
                builder.addQuadAdj(EDhDirection.NORTH, minX, minY, minZ, width, yHeight, color, irisBlockMaterialId, (byte)15, blockLight);
            }
        } else {
            ColumnBox.makeAdjVerticalQuad(builder, phantomArrayCheckout, adjCol, adjSameDetailLevel, caveCullingMaxY, EDhDirection.NORTH, minX, minY, minZ, width, yHeight, color, irisBlockMaterialId, blockLight);
        }
        adjCol = adjData[EDhDirection.SOUTH.compassIndex];
        adjSameDetailLevel = isAdjDataSameDetailLevel[EDhDirection.SOUTH.compassIndex];
        if (adjCol == null) {
            if (!isTransparent || overVoid) {
                builder.addQuadAdj(EDhDirection.SOUTH, minX, minY, maxZ, width, yHeight, color, irisBlockMaterialId, (byte)15, blockLight);
            }
        } else {
            ColumnBox.makeAdjVerticalQuad(builder, phantomArrayCheckout, adjCol, adjSameDetailLevel, caveCullingMaxY, EDhDirection.SOUTH, minX, minY, maxZ, width, yHeight, color, irisBlockMaterialId, blockLight);
        }
        adjCol = adjData[EDhDirection.WEST.compassIndex];
        adjSameDetailLevel = isAdjDataSameDetailLevel[EDhDirection.WEST.compassIndex];
        if (adjCol == null) {
            if (!isTransparent || overVoid) {
                builder.addQuadAdj(EDhDirection.WEST, minX, minY, minZ, width, yHeight, color, irisBlockMaterialId, (byte)15, blockLight);
            }
        } else {
            ColumnBox.makeAdjVerticalQuad(builder, phantomArrayCheckout, adjCol, adjSameDetailLevel, caveCullingMaxY, EDhDirection.WEST, minX, minY, minZ, width, yHeight, color, irisBlockMaterialId, blockLight);
        }
        adjCol = adjData[EDhDirection.EAST.compassIndex];
        adjSameDetailLevel = isAdjDataSameDetailLevel[EDhDirection.EAST.compassIndex];
        if (adjCol == null) {
            if (!isTransparent || overVoid) {
                builder.addQuadAdj(EDhDirection.EAST, maxX, minY, minZ, width, yHeight, color, irisBlockMaterialId, (byte)15, blockLight);
            }
        } else {
            ColumnBox.makeAdjVerticalQuad(builder, phantomArrayCheckout, adjCol, adjSameDetailLevel, caveCullingMaxY, EDhDirection.EAST, maxX, minY, minZ, width, yHeight, color, irisBlockMaterialId, blockLight);
        }
    }

    private static void makeAdjVerticalQuad(LodQuadBuilder builder, PhantomArrayListCheckout phantomArrayCheckout, @NotNull ColumnArrayView adjColumnView, boolean adjacentIsSameDetailLevel, int caveCullingMaxY, EDhDirection direction, short x, short yMin, short z, short horizontalWidth, short ySize, int color, byte irisBlockMaterialId, byte blockLight) {
        LongArrayList segments = phantomArrayCheckout.getLongArray(0, 0);
        LongArrayList newSegments = phantomArrayCheckout.getLongArray(1, 0);
        color = ColorUtil.applyShade(color, MC_RENDER.getShade(direction));
        if (adjColumnView.size == 0 || RenderDataPointUtil.hasZeroHeight(adjColumnView.get(0))) {
            builder.addQuadAdj(direction, x, yMin, z, horizontalWidth, ySize, color, irisBlockMaterialId, (byte)15, blockLight);
            return;
        }
        boolean transparencyEnabled = Config.Client.Advanced.Graphics.Quality.transparency.get().transparencyEnabled;
        boolean inputTransparent = ColorUtil.getAlpha(color) < 255 && transparencyEnabled;
        short yMax = (short)(yMin + ySize);
        int adjCount = adjColumnView.size();
        segments.add(YSegmentUtil.encode(yMin, yMax, (byte)15));
        for (int adjIndex = 0; adjIndex < adjCount; ++adjIndex) {
            byte lightToApply;
            long adjPoint = adjColumnView.get(adjIndex);
            short adjMinY = RenderDataPointUtil.getYMin(adjPoint);
            short adjMaxY = RenderDataPointUtil.getYMax(adjPoint);
            if (!RenderDataPointUtil.doesDataPointExist(adjPoint) || RenderDataPointUtil.hasZeroHeight(adjPoint) || yMax <= adjMinY) continue;
            long adjAbovePoint = adjIndex != 0 ? adjColumnView.get(adjIndex - 1) : 0L;
            long adjBelowPoint = adjIndex + 1 < adjCount ? adjColumnView.get(adjIndex + 1) : 0L;
            boolean adjOverVoid = !RenderDataPointUtil.doesDataPointExist(adjBelowPoint);
            boolean adjTransparent = !adjOverVoid && RenderDataPointUtil.getAlpha(adjPoint) < 255 && transparencyEnabled;
            byte adjSkyLight = RenderDataPointUtil.getLightSky(adjPoint);
            if (!adjTransparent) {
                boolean adjacentCoversThis = !adjacentIsSameDetailLevel && RenderDataPointUtil.getYMax(adjPoint) >= caveCullingMaxY && (x == 0 && direction == EDhDirection.WEST || z == 0 && direction == EDhDirection.NORTH || x == 256 && direction == EDhDirection.EAST || z == 256 && direction == EDhDirection.SOUTH);
                lightToApply = adjacentCoversThis ? adjSkyLight : (byte)-1;
            } else {
                lightToApply = RenderDataPointUtil.getLightSky(adjBelowPoint);
            }
            ColumnBox.applyLightToRange(segments, newSegments, adjMinY, adjMaxY, lightToApply);
            short adjAboveMinY = RenderDataPointUtil.getYMin(adjAbovePoint);
            if (adjMaxY >= adjAboveMinY) continue;
            ColumnBox.applyLightToRange(segments, newSegments, adjMaxY, adjAboveMinY, adjSkyLight);
        }
        for (int i = 0; i < segments.size(); ++i) {
            long segment = segments.getLong(i);
            ColumnBox.tryAddVerticalFaceWithSkyLightToBuilder(builder, direction, x, z, horizontalWidth, color, irisBlockMaterialId, blockLight, YSegmentUtil.getSkyLight(segment), inputTransparent, YSegmentUtil.getEndY(segment), YSegmentUtil.getStartY(segment));
        }
    }

    private static void applyLightToRange(LongArrayList segments, LongArrayList newSegments, short rangeStart, short rangeEnd, byte newLight) {
        newSegments.clear();
        for (int i = 0; i < segments.size(); ++i) {
            long seg = segments.getLong(i);
            short endY = YSegmentUtil.getEndY(seg);
            short startY = YSegmentUtil.getStartY(seg);
            byte skyLight = YSegmentUtil.getSkyLight(seg);
            if (endY <= rangeStart || startY >= rangeEnd) {
                newSegments.add(seg);
                continue;
            }
            if (startY < rangeStart) {
                newSegments.add(YSegmentUtil.encode(startY, rangeStart, skyLight));
            }
            short overlapStart = (short)Math.max(startY, rangeStart);
            short overlapEnd = (short)Math.min(endY, rangeEnd);
            byte minLight = (byte)Math.min(newLight, skyLight);
            newSegments.add(YSegmentUtil.encode(overlapStart, overlapEnd, minLight));
            if (endY <= rangeEnd) continue;
            newSegments.add(YSegmentUtil.encode(rangeEnd, endY, skyLight));
        }
        segments.clear();
        segments.addAll((LongList)newSegments);
    }

    private static void tryAddVerticalFaceWithSkyLightToBuilder(LodQuadBuilder builder, EDhDirection direction, short x, short z, short horizontalWidth, int color, byte irisBlockMaterialId, byte blockLight, byte lastSkyLight, boolean inputTransparent, int quadTopY, int quadBottomY) {
        if (lastSkyLight < 0) {
            return;
        }
        if (inputTransparent && lastSkyLight != 15) {
            return;
        }
        short height = (short)(quadTopY - quadBottomY);
        if (height <= 0) {
            return;
        }
        builder.addQuadAdj(direction, x, (short)quadBottomY, z, horizontalWidth, height, color, irisBlockMaterialId, lastSkyLight, blockLight);
    }

    private static class YSegmentUtil {
        private static final int HEIGHT_WIDTH = 16;
        private static final int SKY_LIGHT_WIDTH = 8;
        private static final int START_Y_MASK = (int)Math.pow(2.0, 16.0) - 1;
        private static final int END_Y_MASK = (int)Math.pow(2.0, 16.0) - 1;
        private static final int SKY_LIGHT_MASK = (int)Math.pow(2.0, 8.0) - 1;
        private static final int START_Y_OFFSET = 0;
        private static final int END_Y_OFFSET = 16;
        private static final int SKY_LIGHT_OFFSET = 32;

        private YSegmentUtil() {
        }

        public static long encode(short startY, short endY, byte skyLight) {
            long data = 0L;
            data |= (long)(startY & START_Y_MASK) << 0;
            data |= (long)(endY & END_Y_MASK) << 16;
            return data |= (long)(skyLight & SKY_LIGHT_MASK) << 32;
        }

        public static short getStartY(long data) {
            return (short)(data >> 0 & (long)START_Y_MASK);
        }

        public static short getEndY(long data) {
            return (short)(data >> 16 & (long)END_Y_MASK);
        }

        public static byte getSkyLight(long data) {
            return (byte)(data >> 32 & (long)SKY_LIGHT_MASK);
        }
    }
}

