/*
 * Decompiled with CFR 0.152.
 */
package de.mennomax.astikorcarts.util;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.GoalSelector;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.eventbus.api.IEventBus;

public final class GoalAdder<T extends Entity> {
    private final Class<T> type;
    private final Function<T, GoalSelector> selector;
    private final ImmutableList<GoalEntry<T>> goals;

    private GoalAdder(Builder<T> builder) {
        this.type = builder.type;
        this.selector = builder.selector;
        this.goals = builder.goals.build();
    }

    public void register(IEventBus bus) {
        bus.addListener(this::onEntityJoinWorld);
    }

    private void onEntityJoinWorld(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        if (!entity.m_9236_().f_46443_ && this.type.isInstance(entity)) {
            Set<WrappedGoal> oldGoals = this.getGoals((Entity)this.type.cast(entity));
            ArrayList<WrappedGoal> newGoals = new ArrayList<WrappedGoal>(oldGoals.size() + this.goals.size());
            for (GoalEntry goal : this.goals) {
                newGoals.add(new WrappedGoal(goal.priority, goal.factory.apply((Entity)this.type.cast(entity))));
            }
            newGoals.addAll(oldGoals);
            oldGoals.clear();
            oldGoals.addAll(newGoals);
        }
    }

    private Set<WrappedGoal> getGoals(T entity) {
        return this.selector.apply(entity).m_148105_();
    }

    public static <T extends Mob> Builder<T> mobGoal(Class<T> type) {
        return GoalAdder.builder(type, m -> m.f_21345_);
    }

    public static <T extends Mob> Builder<T> mobTarget(Class<T> type) {
        return GoalAdder.builder(type, m -> m.f_21346_);
    }

    public static <T extends Entity> Builder<T> builder(Class<T> type, Function<T, GoalSelector> selector) {
        return new Builder<T>(type, selector);
    }

    public static final class Builder<T extends Entity> {
        private final Class<T> type;
        private final Function<T, GoalSelector> selector;
        private final ImmutableList.Builder<GoalEntry<T>> goals = new ImmutableList.Builder();

        private Builder(Class<T> type, Function<T, GoalSelector> selector) {
            this.type = type;
            this.selector = selector;
        }

        public Builder<T> add(int priority, Function<T, Goal> factory) {
            this.goals.add(new GoalEntry<T>(priority, factory));
            return this;
        }

        public GoalAdder<T> build() {
            return new GoalAdder(this);
        }
    }

    private static final class GoalEntry<T extends Entity> {
        private final int priority;
        private final Function<T, Goal> factory;

        private GoalEntry(int priority, Function<T, Goal> factory) {
            this.priority = priority;
            this.factory = factory;
        }
    }
}

