/*
 * Decompiled with CFR 0.152.
 */
package fr.samlegamer.mcwbiomesoplenty;

import fr.addonslib.api.data.ModType;
import fr.samlegamer.addonslib.Finder;
import fr.samlegamer.addonslib.Registration;
import fr.samlegamer.addonslib.client.APIRenderTypes;
import fr.samlegamer.addonslib.generation.loot_tables.McwLootTables;
import fr.samlegamer.addonslib.generation.tags.McwBlockTags;
import fr.samlegamer.addonslib.generation.tags.McwItemTags;
import fr.samlegamer.addonslib.registry.McwRegistry;
import fr.samlegamer.addonslib.tab.APICreativeTab;
import fr.samlegamer.addonslib.tab.NewIconRandom;
import fr.samlegamer.addonslib.util.McwMod;
import fr.samlegamer.mcwbiomesoplenty.Mapping;
import fr.samlegamer.mcwbiomesoplenty.Recipes;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@Mod(value="mcwbiomesoplenty")
public class McwBOP
extends McwMod {
    public static final String MODID = "mcwbiomesoplenty";
    public static final Logger LOGGER = LogManager.getLogger();
    public static final List<String> WOOD = List.of("dead", "fir", "hellbark", "jacaranda", "magic", "mahogany", "palm", "redwood", "umbran", "willow", "empyreal", "maple", "pine");
    public static final List<String> LEAVE = List.of("dead", "fir", "hellbark", "jacaranda", "magic", "mahogany", "palm", "redwood", "umbran", "willow", "empyreal", "pine", "orange_maple", "red_maple", "yellow_maple", "cypress", "snowblossom", "flowering_oak", "rainbow_birch", "origin");
    private static final DeferredRegister<Block> block = Registration.blocks((String)"mcwbiomesoplenty");
    private static final DeferredRegister<Item> item = Registration.items((String)"mcwbiomesoplenty");
    public static final DeferredRegister<CreativeModeTab> ct = Registration.creativeModeTab((String)"mcwbiomesoplenty");
    public static final RegistryObject<CreativeModeTab> MCWBOP_TAB = ct.register("tab", () -> CreativeModeTab.builder().m_257737_(McwBOP::getIcon).m_257941_((Component)Component.m_237115_((String)"mcwbiomesoplenty.tab")).m_257652_());

    public McwBOP(FMLJavaModLoadingContext ctx) {
        super(ctx);
        List<String> woodClassic = List.of("dead", "fir", "mahogany", "palm", "redwood", "willow", "pine");
        List<String> leaveClassic = List.of("dead", "fir", "hellbark", "mahogany", "palm", "redwood", "umbran", "willow", "empyreal", "pine", "cypress", "flowering_oak", "rainbow_birch", "origin");
        Map mapWoodSoundCrimson = McwRegistry.makeDefaultFromList(List.of("hellbark", "umbran", "empyreal"), (SoundType)SoundType.f_244244_);
        Map mapWoodSoundCherry = McwRegistry.makeDefaultFromList(List.of("magic", "jacaranda", "maple"), (SoundType)SoundType.f_271497_);
        Map mapLeaveSoundCherry = McwRegistry.makeDefaultFromList(List.of("snowblossom", "orange_maple", "red_maple", "yellow_maple", "jacaranda", "magic"), (SoundType)SoundType.f_271239_);
        LOGGER.info("Macaw's Biomes O' Plenty Loading...");
        Registration.init((FMLJavaModLoadingContext)ctx, block, item, ct);
        McwRegistry.setRegistriesWood(woodClassic, block, item, (ModType[])Registration.getAllModTypeWood());
        McwRegistry.setRegistriesWood((Map)mapWoodSoundCrimson, block, item, (ModType[])Registration.getAllModTypeWood());
        McwRegistry.setRegistriesWood((Map)mapWoodSoundCherry, block, item, (ModType[])Registration.getAllModTypeWood());
        McwRegistry.setRegistriesLeave(leaveClassic, block, item);
        McwRegistry.setRegistriesLeave((Map)mapLeaveSoundCherry, block, item);
        ctx.getModEventBus().addListener(this::clientSetup);
        ctx.getModEventBus().addListener(this::commonSetup);
        ctx.getModEventBus().addListener(this::dataSetup);
        ctx.getModEventBus().addListener(this::tabSetup);
        MinecraftForge.EVENT_BUS.register(Mapping.class);
        LOGGER.info("Macaw's Biomes O' Plenty Is Charged !");
    }

    public void clientSetup(FMLClientSetupEvent event) {
        APIRenderTypes.initAllWood((FMLClientSetupEvent)event, (String)MODID, WOOD, (ModType[])Registration.getAllModTypeWood());
        APIRenderTypes.initAllLeave((FMLClientSetupEvent)event, (String)MODID, LEAVE);
    }

    public void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            McwLootTables.addBlockAllWood((String)MODID, WOOD);
            McwLootTables.addBlockHedges((String)MODID, LEAVE);
        });
    }

    public void dataSetup(GatherDataEvent gatherDataEvent) {
        DataGenerator generator = gatherDataEvent.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        CompletableFuture registries = gatherDataEvent.getLookupProvider();
        ExistingFileHelper existingFileHelper = gatherDataEvent.getExistingFileHelper();
        if (gatherDataEvent.includeServer()) {
            McwBlockTags mcwBlockTags = new McwBlockTags(packOutput, registries, MODID, existingFileHelper){

                protected void m_6577_(// Could not load outer class - annotation placement on inner may be incorrect
                 @NotNull HolderLookup.Provider p_256380_) {
                    this.addAllMcwTagsWood(McwBOP.MODID, WOOD, Registration.getAllModTypeWood());
                    this.addAllMcwTagsLeave(McwBOP.MODID, LEAVE);
                }
            };
            generator.addProvider(true, (DataProvider)new Recipes(packOutput));
            generator.addProvider(true, (DataProvider)mcwBlockTags);
            generator.addProvider(true, (DataProvider)new McwItemTags(packOutput, registries, mcwBlockTags.m_274426_(), MODID, existingFileHelper){

                protected void m_6577_(// Could not load outer class - annotation placement on inner may be incorrect
                 @NotNull HolderLookup.Provider p_256380_) {
                    this.addAllMcwTagsWood(McwBOP.MODID, WOOD, Registration.getAllModTypeWood());
                    this.addAllMcwTagsLeave(McwBOP.MODID, LEAVE);
                }
            });
        }
    }

    public void tabSetup(BuildCreativeModeTabContentsEvent event) {
        APICreativeTab.initAllWood((BuildCreativeModeTabContentsEvent)event, (String)MODID, WOOD, (CreativeModeTab)((CreativeModeTab)MCWBOP_TAB.get()), (ModType[])Registration.getAllModTypeWood());
        APICreativeTab.initAllLeave((BuildCreativeModeTabContentsEvent)event, (String)MODID, LEAVE, (CreativeModeTab)((CreativeModeTab)MCWBOP_TAB.get()));
    }

    private static ItemStack getIcon() {
        NewIconRandom.NewProperties prop = new NewIconRandom.NewProperties(Finder.findBlock((String)MODID, (String)"redwood_roof"), Finder.findBlock((String)MODID, (String)"redwood_picket_fence"), Finder.findBlock((String)MODID, (String)"redwood_wardrobe"), Finder.findBlock((String)MODID, (String)"redwood_log_bridge_middle"), Finder.findBlock((String)MODID, (String)"redwood_pane_window"), Finder.findBlock((String)MODID, (String)"redwood_modern_door"), Finder.findBlock((String)MODID, (String)"redwood_mystic_trapdoor"), Finder.findBlock((String)MODID, (String)"redwood_planks_path"), Finder.findBlock((String)MODID, (String)"redwood_skyline_stairs"));
        prop.addType(ModType.BRIDGES).addType(ModType.ROOFS).addType(ModType.FENCES).addType(ModType.FURNITURES).addType(ModType.STAIRS).addType(ModType.PATHS).addType(ModType.WINDOWS).addType(ModType.DOORS).addType(ModType.TRAPDOORS);
        Block icon = prop.buildIcon(new ModType[]{ModType.BRIDGES, ModType.ROOFS, ModType.FENCES, ModType.FURNITURES, ModType.STAIRS, ModType.PATHS, ModType.WINDOWS, ModType.DOORS, ModType.TRAPDOORS});
        return new ItemStack((ItemLike)icon);
    }
}

