/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.network;

import java.util.UUID;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.BackpackStorage;
import net.p3pp3rf1y.sophisticatedcore.client.render.ClientStorageContentsTooltipBase;
import net.p3pp3rf1y.sophisticatedcore.network.ISplittableMessage;

public class BackpackContentsMessage
implements ISplittableMessage {
    private final UUID backpackUuid;
    @Nullable
    private final CompoundTag backpackContents;

    public BackpackContentsMessage(UUID backpackUuid, @Nullable CompoundTag backpackContents) {
        this.backpackUuid = backpackUuid;
        this.backpackContents = backpackContents;
    }

    public static void encode(BackpackContentsMessage msg, FriendlyByteBuf packetBuffer) {
        packetBuffer.m_130077_(msg.backpackUuid);
        packetBuffer.m_130079_(msg.backpackContents);
    }

    public static BackpackContentsMessage decode(FriendlyByteBuf packetBuffer) {
        return new BackpackContentsMessage(packetBuffer.m_130259_(), packetBuffer.m_130261_());
    }

    static void onMessage(BackpackContentsMessage msg, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> BackpackContentsMessage.handleMessage(msg));
        context.setPacketHandled(true);
    }

    private static void handleMessage(BackpackContentsMessage msg) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null || msg.backpackContents == null) {
            return;
        }
        BackpackStorage.get().setBackpackContents(msg.backpackUuid, msg.backpackContents);
        ClientStorageContentsTooltipBase.refreshContents();
    }
}

