/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.hud;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.List;
import net.mehvahdjukaar.moonlight.api.platform.network.Message;
import net.mehvahdjukaar.supplementaries.client.hud.forge.SelectableContainerItemHudImpl;
import net.mehvahdjukaar.supplementaries.common.items.SelectableContainerItem;
import net.mehvahdjukaar.supplementaries.common.network.ModNetwork;
import net.mehvahdjukaar.supplementaries.common.network.ServerBoundCycleSelectableContainerItemPacket;
import net.mehvahdjukaar.supplementaries.common.utils.IQuiverPlayer;
import net.mehvahdjukaar.supplementaries.common.utils.SlotReference;
import net.mehvahdjukaar.supplementaries.configs.ClientConfigs;
import net.mehvahdjukaar.supplementaries.reg.ClientRegistry;
import net.mehvahdjukaar.supplementaries.reg.ModTextures;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public abstract class SelectableContainerItemHud {
    protected final Minecraft mc;
    @Nullable
    private SelectableContainerItem<?> itemUsed;
    private SlotReference stackSlot;
    private boolean usingKey = false;
    private double lastCumulativeMouseDx = 0.0;

    public static SelectableContainerItemHud getInstance() {
        return Holder.INSTANCE;
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static SelectableContainerItemHud makeInstance() {
        return SelectableContainerItemHudImpl.makeInstance();
    }

    protected SelectableContainerItemHud(Minecraft minecraft) {
        this.mc = minecraft;
    }

    public boolean isActive() {
        return this.itemUsed != null;
    }

    public boolean isUsingKey() {
        return this.itemUsed != null && this.usingKey;
    }

    public boolean isUsingItem() {
        return this.itemUsed != null && !this.usingKey;
    }

    public void setUsingItem(SlotReference slot, LivingEntity player) {
        SelectableContainerItem selectable;
        this.stackSlot = slot;
        Item item = slot.getItem(player);
        this.itemUsed = item instanceof SelectableContainerItem ? (selectable = (SelectableContainerItem)item) : null;
    }

    public void setUsingKeybind(SlotReference slot, Player player) {
        this.setUsingItem(slot, (LivingEntity)player);
        this.usingKey = this.itemUsed != null;
    }

    private void closeHud() {
        this.itemUsed = null;
        this.usingKey = false;
        this.stackSlot = SlotReference.EMPTY;
    }

    public boolean onMouseScrolled(double scrollDelta) {
        if (this.itemUsed != null) {
            int amount = scrollDelta > 0.0 ? -1 : 1;
            this.sendCycle(amount);
            return true;
        }
        return false;
    }

    public void ohMouseMoved(double deltaX) {
        if (this.itemUsed != null && ClientConfigs.Items.QUIVER_MOUSE_MOVEMENT.get().booleanValue()) {
            LocalPlayer player;
            double scale = (Double)Minecraft.m_91087_().f_91066_.m_231964_().m_231551_() * 0.02;
            int oldI = (int)(this.lastCumulativeMouseDx * scale);
            this.lastCumulativeMouseDx += deltaX;
            int slotsMoved = (int)(this.lastCumulativeMouseDx * scale) - oldI;
            if (slotsMoved != 0 && (player = Minecraft.m_91087_().f_91074_) != null) {
                this.sendCycle(slotsMoved);
            }
        }
    }

    private void sendCycle(int slotsMoved) {
        SelectableContainerItem.AbstractData data = this.getItemUsedData();
        if (data != null) {
            ModNetwork.CHANNEL.sendToServer((Message)new ServerBoundCycleSelectableContainerItemPacket(slotsMoved, this.stackSlot));
            data.cycle(slotsMoved);
        }
    }

    private void sendSetSlot(int number) {
        SelectableContainerItem.AbstractData data = this.getItemUsedData();
        if (data != null) {
            ModNetwork.CHANNEL.sendToServer((Message)new ServerBoundCycleSelectableContainerItemPacket(number, this.stackSlot, true));
            this.getItemUsedData().setSelectedSlot(number);
        }
    }

    public boolean onKeyPressed(int key, int action, int modifiers) {
        if (this.itemUsed == null) {
            return false;
        }
        if (action != 1) {
            return false;
        }
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        switch (key) {
            case 263: {
                this.sendCycle(-1);
                return true;
            }
            case 262: {
                this.sendCycle(1);
                return true;
            }
        }
        int number = key - 48;
        if (number >= 1 && number <= 9) {
            if (number <= this.itemUsed.getMaxSlots()) {
                this.sendSetSlot(number - 1);
            }
            return true;
        }
        return false;
    }

    @Nullable
    private SelectableContainerItem.AbstractData getItemUsedData() {
        if (this.itemUsed == null) {
            return null;
        }
        ItemStack stack = this.stackSlot.get((LivingEntity)Minecraft.m_91087_().f_91074_);
        if (!stack.m_150930_(this.itemUsed)) {
            return null;
        }
        return this.itemUsed.getData(stack);
    }

    public void render(GuiGraphics graphics, float partialTicks, int screenWidth, int screenHeight) {
        boolean keyDown;
        if (this.itemUsed == null) {
            return;
        }
        if (!(this.mc.m_91288_() instanceof IQuiverPlayer)) {
            this.closeHud();
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91080_ != null) {
            this.closeHud();
            return;
        }
        if (this.isUsingKey() && !ClientRegistry.QUIVER_KEYBIND.m_90862_() && !(keyDown = ClientRegistry.QUIVER_KEYBIND.m_90857_())) {
            this.closeHud();
            return;
        }
        SelectableContainerItem.AbstractData data = this.getItemUsedData();
        if (data == null) {
            this.closeHud();
            return;
        }
        PoseStack poseStack = graphics.m_280168_();
        poseStack.m_85836_();
        int selected = data.getSelectedSlot();
        List<ItemStack> items = data.getContentView();
        int slots = items.size();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        int centerX = screenWidth / 2;
        poseStack.m_85836_();
        poseStack.m_252880_(0.0f, 0.0f, -90.0f);
        int uWidth = slots * 20 + 2;
        int px = uWidth / 2;
        int py = screenHeight / 2 - 40;
        graphics.m_280218_(ModTextures.QUIVER_HUD, centerX - (px += ClientConfigs.Items.QUIVER_GUI_X.get().intValue()), py += ClientConfigs.Items.QUIVER_GUI_Y.get().intValue(), 0, 0, uWidth - 1, 22);
        graphics.m_280218_(ModTextures.QUIVER_HUD, centerX + px - 1, py, 0, 0, 1, 22);
        graphics.m_280218_(ModTextures.QUIVER_HUD, centerX - px - 1 + selected * 20, py - 1, 24, 22, 24, 24);
        poseStack.m_85849_();
        int i1 = 1;
        for (int i = 0; i < slots; ++i) {
            int kx = centerX - px + 3 + i * 20;
            this.renderSlot(graphics, kx, py + 3, items.get(i), i1++, mc.f_91062_);
        }
        RenderSystem.disableBlend();
        ItemStack selectedArrow = items.get(selected);
        if (!selectedArrow.m_41619_()) {
            this.drawHighlight(graphics, screenWidth, py, selectedArrow);
        }
        poseStack.m_85849_();
    }

    private void renderSlot(GuiGraphics graphics, int pX, int pY, ItemStack pStack, int seed, Font font) {
        if (!pStack.m_41619_()) {
            graphics.m_280256_(pStack, pX, pY, seed);
            RenderSystem.setShader(GameRenderer::m_172811_);
            graphics.m_280370_(font, pStack, pX, pY);
        }
    }

    protected abstract void drawHighlight(GuiGraphics var1, int var2, int var3, ItemStack var4);

    private static class Holder {
        private static final SelectableContainerItemHud INSTANCE = SelectableContainerItemHud.makeInstance();

        private Holder() {
        }
    }
}

