/*
 * Decompiled with CFR 0.152.
 */
package pigcart.particlerain.particle;

import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import pigcart.particlerain.VersionUtil;
import pigcart.particlerain.WeatherParticleManager;
import pigcart.particlerain.config.ConfigData;
import pigcart.particlerain.config.ConfigManager;

public abstract class WeatherParticle
extends TextureSheetParticle {
    protected BlockPos.MutableBlockPos pos;
    protected BlockPos.MutableBlockPos oPos;
    boolean doCollisionAnim = false;
    float baseTemp;
    float targetOpacity;
    float oQuadSize;
    float distance;

    protected WeatherParticle(ClientLevel level, double x, double y, double z, TextureAtlasSprite sprite) {
        super(level, x, y, z);
        this.m_108337_(sprite);
        this.f_107219_ = false;
        this.m_107250_(this.f_107663_, this.f_107663_);
        this.f_107225_ = ConfigManager.config.perf.particleDistance * 100;
        this.pos = new BlockPos.MutableBlockPos(x, y, z);
        this.oPos = new BlockPos.MutableBlockPos(x, y, z);
        this.baseTemp = ((Biome)level.m_204166_((BlockPos)this.pos).m_203334_()).m_47554_();
        ++WeatherParticleManager.particleCount;
    }

    public void m_107274_() {
        if (this.m_107276_()) {
            --WeatherParticleManager.particleCount;
        }
        super.m_107274_();
    }

    public ParticleRenderType m_7556_() {
        return ConfigData.RenderType.TRANSLUCENT.get();
    }

    public void m_5989_() {
        super.m_5989_();
        this.oQuadSize = this.f_107663_;
        this.distance = (float)VersionUtil.camPos(Minecraft.m_91087_().f_91063_.m_109153_()).m_82554_(new Vec3(this.f_107212_, this.f_107213_, this.f_107214_));
        this.pos.m_122169_(this.f_107212_, this.f_107213_, this.f_107214_);
        if (!this.pos.equals((Object)this.oPos)) {
            this.onPositionUpdate();
            this.oPos.m_122190_((Vec3i)this.pos);
        }
        if (this.doCollisionAnim) {
            this.tickCollisionAnim();
        }
        this.tickDistanceFade();
    }

    public void onPositionUpdate() {
        if (!ConfigManager.config.compat.crossBiomeBorder && (double)Mth.m_14154_((float)(((Biome)this.f_107208_.m_204166_((BlockPos)this.pos).m_203334_()).m_47554_() - this.baseTemp)) > 0.4) {
            this.doCollisionAnim = true;
        }
        if (this.f_107208_.m_8055_((BlockPos)this.pos).m_60838_((BlockGetter)this.f_107208_, (BlockPos)this.pos) || !this.f_107208_.m_6425_((BlockPos)this.pos).m_76178_()) {
            this.m_107274_();
        }
    }

    public void tickDistanceFade() {
        float renderDistance = ConfigManager.config.perf.particleDistance;
        if (this.distance > renderDistance) {
            this.m_107274_();
        } else {
            this.f_107230_ = Mth.m_14179_((float)(this.distance / renderDistance), (float)this.targetOpacity, (float)0.0f);
        }
    }

    public float m_5902_(float scaleFactor) {
        return Mth.m_14179_((float)scaleFactor, (float)this.oQuadSize, (float)this.f_107663_);
    }

    public void tickCollisionAnim() {
        float deltaMovement = (float)new Vec3(this.f_107215_, this.f_107216_, this.f_107217_).m_82553_();
        this.f_107663_ -= deltaMovement;
        if (this.f_107663_ <= 0.0f) {
            this.m_107274_();
        }
    }

    public Quaternionf turnBackfaceFlipways(Quaternionf quaternion, Vector3f cameraOffset) {
        Vector3f normal = new Vector3f(0.0f, 0.0f, 1.0f);
        normal.rotate((Quaternionfc)quaternion).normalize();
        float dot = normal.dot((Vector3fc)cameraOffset);
        if (dot > 0.0f) {
            return quaternion.mul((Quaternionfc)Axis.f_252436_.m_252961_((float)Math.PI));
        }
        return quaternion;
    }

    protected void renderRotatedQuad(VertexConsumer vertexConsumer, Quaternionf quaternionf, float x, float y, float z, float tickPercent) {
        quaternionf.rotateY((float)Math.PI);
        float size = this.m_5902_(tickPercent);
        float u0 = this.m_5970_();
        float u1 = this.m_5952_();
        float v0 = this.m_5951_();
        float v1 = this.m_5950_();
        int lightColor = this.m_6355_(tickPercent);
        Vector3f[] vector3fs = new Vector3f[]{new Vector3f(-1.0f, -1.0f, 0.0f), new Vector3f(-1.0f, 1.0f, 0.0f), new Vector3f(1.0f, 1.0f, 0.0f), new Vector3f(1.0f, -1.0f, 0.0f)};
        for (int k = 0; k < 4; ++k) {
            Vector3f vector3f = vector3fs[k];
            vector3f.rotate((Quaternionfc)quaternionf);
            vector3f.mul(size);
            vector3f.add(x, y, z);
        }
        vertexConsumer.m_5483_((double)vector3fs[0].x(), (double)vector3fs[0].y(), (double)vector3fs[0].z()).m_7421_(u1, v1).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(lightColor).m_5752_();
        vertexConsumer.m_5483_((double)vector3fs[1].x(), (double)vector3fs[1].y(), (double)vector3fs[1].z()).m_7421_(u1, v0).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(lightColor).m_5752_();
        vertexConsumer.m_5483_((double)vector3fs[2].x(), (double)vector3fs[2].y(), (double)vector3fs[2].z()).m_7421_(u0, v0).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(lightColor).m_5752_();
        vertexConsumer.m_5483_((double)vector3fs[3].x(), (double)vector3fs[3].y(), (double)vector3fs[3].z()).m_7421_(u0, v1).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(lightColor).m_5752_();
    }
}

