/*
 * Decompiled with CFR 0.152.
 */
package pigcart.particlerain.particle;

import com.mojang.blaze3d.vertex.VertexConsumer;
import java.awt.Color;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;
import org.joml.AxisAngle4f;
import org.joml.Math;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import pigcart.particlerain.VersionUtil;
import pigcart.particlerain.config.ConfigManager;
import pigcart.particlerain.particle.WeatherParticle;

public class ShrubParticle
extends WeatherParticle {
    protected ShrubParticle(ClientLevel level, double x, double y, double z) {
        super(level, x, y, z, VersionUtil.getSprite(MissingTextureAtlasSprite.m_118071_()));
        this.f_107663_ = ConfigManager.config.shrub.size;
        this.m_107250_(this.f_107663_, this.f_107663_);
        this.f_107219_ = true;
        this.f_107226_ = ConfigManager.config.shrub.gravity;
        this.f_107216_ = 0.1f;
        this.f_107225_ = 200;
        this.f_107215_ = level.m_46470_() ? (double)ConfigManager.config.shrub.stormWindStrength : (double)ConfigManager.config.shrub.windStrength;
        this.f_107217_ = level.m_46470_() ? (double)ConfigManager.config.shrub.stormWindStrength : (double)ConfigManager.config.shrub.windStrength;
        BlockState blockState = level.m_8055_(level.m_5452_(Heightmap.Types.MOTION_BLOCKING, (BlockPos)this.pos));
        if (blockState.m_204336_(BlockTags.f_278394_) && !blockState.m_60795_() && blockState.m_60819_().m_76178_() && !blockState.m_204336_(BlockTags.f_13073_) && !blockState.m_204336_(BlockTags.f_144279_)) {
            BakedModel model = Minecraft.m_91087_().m_91289_().m_110910_(blockState);
            this.m_108337_(model.m_6160_());
            BakedQuad quad = (BakedQuad)model.m_213637_(blockState, null, this.f_107223_).get(0);
            if (quad.m_111304_()) {
                Color color = new Color(BiomeColors.m_108804_((BlockAndTintGetter)level, (BlockPos)this.pos));
                this.m_107253_((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f);
            }
        } else {
            blockState = Blocks.f_50036_.m_49966_();
        }
        this.m_108337_(Minecraft.m_91087_().m_91289_().m_110910_(blockState).m_6160_());
    }

    @Override
    public void m_5989_() {
        super.m_5989_();
        if (this.f_107215_ == 0.0 || this.f_107217_ == 0.0) {
            this.m_107274_();
        }
        this.f_107215_ = this.f_107208_.m_46470_() ? (double)ConfigManager.config.shrub.stormWindStrength : (double)ConfigManager.config.shrub.windStrength;
        this.f_107217_ = this.f_107208_.m_46470_() ? (double)ConfigManager.config.shrub.stormWindStrength : (double)ConfigManager.config.shrub.windStrength;
        float speed = (float)new Vec3(this.f_107215_, this.f_107216_, this.f_107217_).m_82553_();
        this.f_107204_ = this.f_107231_;
        this.f_107231_ += ConfigManager.config.shrub.rotationAmount * speed;
        if (this.f_107218_) {
            this.f_107216_ = ConfigManager.config.shrub.bounciness;
        }
    }

    @Override
    public void tickDistanceFade() {
    }

    @Override
    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107429_;
    }

    public void m_5744_(VertexConsumer h, Camera camera, float tickPercentage) {
        Vector3f camPos = VersionUtil.camPos(camera).m_252839_();
        float x = (float)(Mth.m_14139_((double)tickPercentage, (double)this.f_107209_, (double)this.f_107212_) - (double)camPos.x);
        float y = (float)(Mth.m_14139_((double)tickPercentage, (double)this.f_107210_, (double)this.f_107213_) - (double)camPos.y);
        float z = (float)(Mth.m_14139_((double)tickPercentage, (double)this.f_107211_, (double)this.f_107214_) - (double)camPos.z);
        float angle = (float)Math.atan2((double)this.f_107215_, (double)this.f_107217_);
        Quaternionf quaternion = new Quaternionf();
        quaternion.rotateY(angle);
        Quaternionf quat1 = new Quaternionf(new AxisAngle4f(0.0f, 0.0f, 1.0f, 0.0f));
        Quaternionf quat2 = new Quaternionf(new AxisAngle4f(1.5707964f, 0.0f, 1.0f, 0.0f));
        quat1.mul((Quaternionfc)quaternion).rotateX(Mth.m_14179_((float)tickPercentage, (float)this.f_107204_, (float)this.f_107231_));
        quat2.mul((Quaternionfc)quaternion).rotateZ(Mth.m_14179_((float)tickPercentage, (float)this.f_107204_, (float)this.f_107231_));
        quat1 = this.turnBackfaceFlipways(quat1, new Vector3f(x, y, z));
        quat2 = this.turnBackfaceFlipways(quat2, new Vector3f(x, y, z));
        this.renderRotatedQuad(h, quat1, x, y, z, tickPercentage);
        this.renderRotatedQuad(h, quat2, x, y, z, tickPercentage);
    }

    public static class DefaultFactory
    implements ParticleProvider<SimpleParticleType> {
        public DefaultFactory(SpriteSet provider) {
        }

        public Particle createParticle(SimpleParticleType parameters, ClientLevel level, double x, double y, double z, double velocityX, double velocityY, double velocityZ) {
            return new ShrubParticle(level, x, y, z);
        }
    }
}

