/*
 * Decompiled with CFR 0.152.
 */
package pigcart.particlerain;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.util.List;
import java.util.Set;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.NoteBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.Heightmap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import pigcart.particlerain.VersionUtil;
import pigcart.particlerain.WeatherParticleManager;
import pigcart.particlerain.config.ConfigManager;
import pigcart.particlerain.particle.CustomParticle;

public class ParticleRain {
    public static int clientTicks = 0;
    public static final String MOD_ID = "particlerain";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"particlerain");
    public static SimpleParticleType MIST;
    public static SimpleParticleType SHRUB;
    public static SimpleParticleType RIPPLE;
    public static SimpleParticleType STREAK;
    public static Set<String> particleConfigIds;
    public static SoundEvent WEATHER_SNOW;
    public static SoundEvent WEATHER_SNOW_ABOVE;
    public static SoundEvent WEATHER_SANDSTORM;
    public static SoundEvent WEATHER_SANDSTORM_ABOVE;

    private static List<String> getDebugLines() {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level == null) {
            return List.of();
        }
        BlockPos blockPos = BlockPos.m_274446_((Position)Minecraft.m_91087_().f_91074_.m_20182_());
        Holder biome = level.m_204166_(blockPos);
        Biome.Precipitation precipitation = VersionUtil.getPrecipitationAt((Level)level, (Holder<Biome>)biome, blockPos);
        return List.of(String.format("Tracked particles: %d/%d", WeatherParticleManager.getParticleCount(), ConfigManager.config.perf.maxParticleAmount), "after Weather Ticks Left: " + WeatherParticleManager.afterWeatherTicksLeft, "spawn Attempts Until Block FX Idle: " + WeatherParticleManager.spawnAttemptsUntilBlockFXIdle, "ticks Until Sky FX Idle: " + WeatherParticleManager.ticksUntilSkyFXIdle, "ticks Until Surface FX Idle: " + WeatherParticleManager.ticksUntilSurfaceFXIdle, "is Raining: " + level.m_46471_(), "Biome Precipitation: " + String.valueOf(precipitation), "Wind multiplier: " + CustomParticle.yLevelWindMultiplier(blockPos.m_123342_()));
    }

    public static void onInitializeClient() {
        ConfigManager.load();
        WEATHER_SNOW = ParticleRain.createSoundEvent("weather.snow");
        WEATHER_SNOW_ABOVE = ParticleRain.createSoundEvent("weather.snow.above");
        WEATHER_SANDSTORM = ParticleRain.createSoundEvent("weather.sandstorm");
        WEATHER_SANDSTORM_ABOVE = ParticleRain.createSoundEvent("weather.sandstorm.above");
    }

    public static void onTick(Minecraft client) {
        Camera camera = client.f_91063_.m_109153_();
        if (!client.m_91104_() && client.f_91073_ != null && camera.m_90593_()) {
            ++clientTicks;
            WeatherParticleManager.tick(client.f_91073_, camera.m_90583_());
        }
    }

    private static SoundEvent createSoundEvent(String name) {
        ResourceLocation id = VersionUtil.getId(name);
        return SoundEvent.m_262824_((ResourceLocation)id);
    }

    public static <S> LiteralArgumentBuilder<S> getCommands() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)MOD_ID).executes(ctx -> {
            VersionUtil.schedule(() -> Minecraft.m_91087_().m_91152_(ConfigManager.screenPlease(null)));
            return 0;
        })).then(LiteralArgumentBuilder.literal((String)"debug").executes(ctx -> {
            ParticleRain.getDebugLines().forEach(ParticleRain::addChatMsg);
            return 0;
        }));
    }

    private static void addChatMsg(String message) {
        Minecraft.m_91087_().f_91065_.m_93076_().m_93785_((Component)Component.m_237113_((String)message));
    }

    public static void doAdditionalWeatherSounds(ClientLevel level, BlockPos cameraPos, BlockPos rainPos, CallbackInfo ci) {
        BlockState state;
        SoundType soundType;
        if (ConfigManager.config.compat.doSpawnHeightLimit) {
            int cloudHeight;
            int n = cloudHeight = ConfigManager.config.compat.spawnHeightLimit == 0 ? VersionUtil.getCloudHeight(level, rainPos) : ConfigManager.config.compat.spawnHeightLimit;
            if (rainPos.m_123342_() > cloudHeight) {
                ci.cancel();
                return;
            }
        }
        boolean above = rainPos.m_123342_() > cameraPos.m_123342_() + 1 && level.m_5452_(Heightmap.Types.MOTION_BLOCKING, cameraPos).m_123342_() > Mth.m_14143_((float)cameraPos.m_123342_());
        Holder biome = level.m_204166_(rainPos);
        Biome.Precipitation precipitation = VersionUtil.getPrecipitationAt((Level)level, (Holder<Biome>)biome, rainPos);
        if (precipitation == Biome.Precipitation.SNOW && ConfigManager.config.sound.snowVolume > 0.0f) {
            SoundEvent sound = above ? WEATHER_SNOW_ABOVE : WEATHER_SNOW;
            level.m_245747_(rainPos, sound, SoundSource.WEATHER, ConfigManager.config.sound.snowVolume, above ? 0.5f : 1.0f, false);
        } else if (precipitation == Biome.Precipitation.NONE && (double)((Biome)biome.m_203334_()).m_47554_() > 0.25 && ConfigManager.config.sound.windVolume > 0.0f) {
            SoundEvent sound = above ? WEATHER_SANDSTORM_ABOVE : WEATHER_SANDSTORM;
            level.m_245747_(rainPos, sound, SoundSource.WEATHER, ConfigManager.config.sound.windVolume, above ? 0.5f : 1.0f, false);
        } else if (ConfigManager.config.sound.blockVolume > 0.0f && !(soundType = (state = level.m_8055_(rainPos)).m_60827_()).equals(SoundType.f_56742_)) {
            if (state.m_60713_(Blocks.f_50065_)) {
                SoundEvent sound = (SoundEvent)((NoteBlockInstrument)state.m_61143_((Property)NoteBlock.f_55011_)).m_263188_().m_203334_();
                float pitch = NoteBlock.m_276981_((int)level.f_46441_.m_188503_(24));
                level.m_245747_(rainPos, sound, SoundSource.WEATHER, ConfigManager.config.sound.blockVolume, above ? pitch / 2.0f : pitch, false);
            } else {
                SoundEvent sound = soundType.m_56778_();
                level.m_245747_(rainPos, sound, SoundSource.WEATHER, ConfigManager.config.sound.blockVolume, above ? 0.5f : 1.5f, false);
            }
        }
        if (ConfigManager.config.sound.rainVolume == 0.0f || !precipitation.equals((Object)Biome.Precipitation.RAIN)) {
            ci.cancel();
        }
    }

    static {
        particleConfigIds = Set.of("shrub", "ripple", "streak", "mist");
    }
}

