/*
 * Decompiled with CFR 0.152.
 */
package com.wildfire.main.config;

import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;

public class GeneralClientConfig {
    public static final GeneralClientConfig INSTANCE = new GeneralClientConfig();
    public final ForgeConfigSpec configSpec;
    public final ForgeConfigSpec.BooleanValue disableRendering;
    public final ForgeConfigSpec.BooleanValue disableSoundReplacement;

    public static void register(ModContainer modContainer) {
        modContainer.addConfig(new ModConfig(ModConfig.Type.CLIENT, (IConfigSpec)GeneralClientConfig.INSTANCE.configSpec, modContainer, "WildfireGender/client.toml"));
    }

    private GeneralClientConfig() {
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        builder.comment("Client Config. This config only exists on the client").translation("wildfire_gender.config.client").push("client");
        this.disableRendering = builder.comment("Global override to disable all rendering related to the mod (including in gender menus)").translation("wildfire_gender.config.client.disable_rendering").define("disableRendering", false);
        this.disableSoundReplacement = builder.comment("Global override to disable replacing sounds of players with female variants").translation("wildfire_gender.config.client.disable_sound_replacement").define("disableSoundReplacement", false);
        builder.pop();
        this.configSpec = builder.build();
    }
}

