/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.gui.controls.collection;

import java.util.ArrayList;
import team.creative.creativecore.common.gui.controls.collection.GuiComboBox;
import team.creative.creativecore.common.gui.controls.collection.GuiListBoxBase;
import team.creative.creativecore.common.gui.controls.simple.GuiRowLabel;
import team.creative.creativecore.common.gui.controls.simple.GuiTextfield;
import team.creative.creativecore.common.util.math.geo.Rect;

public class GuiComboBoxExtension
extends GuiListBoxBase<GuiRowLabel> {
    public GuiComboBox comboBox;
    public String search = "";

    public GuiComboBoxExtension(String name, GuiComboBox comboBox) {
        super(name, false, new ArrayList());
        this.comboBox = comboBox;
        this.registerEventChanged(event -> {
            if (event.control.is("searchBar")) {
                this.search = ((GuiTextfield)event.control).getText();
                this.reloadControls();
            }
        });
        this.reloadControls();
    }

    @Override
    public void looseFocus() {
        this.comboBox.extensionLostFocus = true;
    }

    public void reloadControls() {
        if (this.comboBox == null) {
            return;
        }
        GuiTextfield textfield = (GuiTextfield)this.get("searchBar");
        this.clearItems();
        if (this.search != null && this.search.isBlank()) {
            this.search = null;
        }
        if (this.comboBox.hasSearchbar()) {
            if (textfield == null) {
                textfield = new GuiTextfield("searchBar", this.search == null ? "" : this.search);
                this.addCustomControl(textfield.setExpandableX());
            }
            textfield.focus();
        }
        ArrayList<GuiRowLabel> entries = new ArrayList<GuiRowLabel>();
        for (int i = 0; i < this.comboBox.lines.length; ++i) {
            if (this.search != null && !this.comboBox.lines[i].contains(this.search)) continue;
            int index = i;
            entries.add(new GuiRowLabel("" + i, i, i == this.comboBox.getIndex(), x -> {
                this.comboBox.select(index);
                this.comboBox.closeBox();
            }).set(this.comboBox.lines[i].copy()));
        }
        this.addAllItems(entries);
        if (this.hasGui()) {
            this.reflowInternal();
        }
    }

    @Override
    public boolean mouseClicked(Rect rect, double x, double y, int button) {
        if (super.mouseClicked(rect, x, y, button)) {
            this.comboBox.extensionLostFocus = false;
            return true;
        }
        return false;
    }

    @Override
    protected int maxHeight(int width, int availableWidth) {
        return 100;
    }
}

