/*
 * Decompiled with CFR 0.152.
 */
package io.github.edwinmindcraft.origins.api.data;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Streams;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import io.github.apace100.origins.data.CompatibilityDataTypes;
import io.github.apace100.origins.origin.Impact;
import io.github.edwinmindcraft.apoli.api.ApoliAPI;
import io.github.edwinmindcraft.apoli.api.power.configuration.ConfiguredPower;
import io.github.edwinmindcraft.apoli.api.registry.ApoliDynamicRegistries;
import io.github.edwinmindcraft.origins.api.origin.Origin;
import io.github.edwinmindcraft.origins.api.origin.OriginUpgrade;
import io.github.edwinmindcraft.origins.api.util.JsonUtils;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import net.minecraft.core.HolderSet;
import net.minecraft.core.MappedRegistry;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record PartialOrigin(@NotNull List<HolderSet<ConfiguredPower<?, ?>>> powers, @Nullable ItemStack icon, @Nullable Boolean unchoosable, @Nullable Integer order, @Nullable Impact impact, @Nullable String name, @Nullable String description, @NotNull Set<OriginUpgrade> upgrades, int loadingOrder) {
    public Origin create(ResourceLocation name) {
        return new Origin((Collection<HolderSet<ConfiguredPower<?, ?>>>)ImmutableSet.copyOf(this.powers()), this.icon() != null ? this.icon() : ItemStack.f_41583_, this.unchoosable() != null ? this.unchoosable() : false, this.order() != null ? this.order() : Integer.MAX_VALUE, this.impact() != null ? this.impact() : Impact.NONE, (Component)Component.m_237115_((String)(this.name() != null ? this.name() : "origin." + name.m_135827_() + "." + name.m_135815_() + ".name")), (Component)Component.m_237115_((String)(this.description() != null ? this.description() : "origin." + name.m_135827_() + "." + name.m_135815_() + ".description")), (Set<OriginUpgrade>)ImmutableSet.copyOf(this.upgrades()));
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private final ImmutableList.Builder<HolderSet<ConfiguredPower<?, ?>>> powers = ImmutableList.builder();
        private final ImmutableSet.Builder<OriginUpgrade> upgrades = ImmutableSet.builder();
        private ItemStack icon;
        private Boolean unchoosable;
        private Integer order;
        private Impact impact;
        private String name;
        private String description;
        private int loadingOrder = 0;

        private Builder() {
        }

        @Contract(value="_ -> this")
        public Builder powers(JsonArray powers) throws JsonParseException {
            DataResult decode = ConfiguredPower.CODEC_SET.set().decode((DynamicOps)JsonOps.INSTANCE, (Object)powers);
            if (decode.result().isEmpty()) {
                throw new JsonParseException("Failed to deserialize powers: " + ((DataResult.PartialResult)decode.error().orElseThrow()).message());
            }
            this.powers.addAll((Iterable)((Pair)decode.result().get()).getFirst());
            return this;
        }

        @Contract(value="_ -> this")
        public Builder powers(Iterable<ResourceLocation> powers) {
            MappedRegistry registry = ApoliAPI.getPowers((RegistryAccess)(ServerLifecycleHooks.getCurrentServer() != null ? ServerLifecycleHooks.getCurrentServer().m_206579_() : RegistryAccess.f_243945_));
            List<ResourceKey> keys = Streams.stream(powers).map(loc -> ResourceKey.m_135785_((ResourceKey)ApoliDynamicRegistries.CONFIGURED_POWER_KEY, (ResourceLocation)loc)).toList();
            this.powers.add((Object)HolderSet.m_205803_(arg_0 -> ((Registry)registry).m_246971_(arg_0), keys));
            return this;
        }

        @Contract(value="_ -> this")
        public Builder powers(ResourceLocation ... powers) {
            return this.powers(Arrays.asList(powers));
        }

        @Contract(value="_ -> this")
        public Builder icon(@Nullable ItemStack icon) {
            this.icon = icon;
            return this;
        }

        @Contract(value="_ -> this")
        public Builder unchoosable(@Nullable Boolean unchoosable) {
            this.unchoosable = unchoosable;
            return this;
        }

        @Contract(value="_ -> this")
        public Builder order(@Nullable Integer order) {
            this.order = order;
            return this;
        }

        @Contract(value="_ -> this")
        public Builder impact(@Nullable Impact impact) {
            this.impact = impact;
            return this;
        }

        @Contract(value="_ -> this")
        public Builder name(@Nullable String name) {
            this.name = name;
            return this;
        }

        @Contract(value="_ -> this")
        public Builder description(@Nullable String description) {
            this.description = description;
            return this;
        }

        @Contract(value="_ -> this")
        public Builder upgrades(Iterable<OriginUpgrade> upgrades) {
            this.upgrades.addAll(upgrades);
            return this;
        }

        @Contract(value="_ -> this")
        public Builder upgrades(OriginUpgrade ... upgrades) {
            this.upgrades.add((Object[])upgrades);
            return this;
        }

        @Contract(value="_ -> this")
        public Builder loadingOrder(int loadingOrder) {
            this.loadingOrder = loadingOrder;
            return this;
        }

        public PartialOrigin build() {
            return new PartialOrigin((List<HolderSet<ConfiguredPower<?, ?>>>)this.powers.build(), this.icon, this.unchoosable, this.order, this.impact, this.name, this.description, (Set<OriginUpgrade>)this.upgrades.build(), this.loadingOrder);
        }
    }

    public static enum Serializer implements JsonSerializer<PartialOrigin>,
    JsonDeserializer<PartialOrigin>
    {
        INSTANCE;


        public PartialOrigin deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonElement icon;
            ItemStack read;
            JsonObject root = GsonHelper.m_13918_((JsonElement)json, (String)"root element");
            Builder builder = PartialOrigin.builder();
            if (root.has("powers")) {
                builder.powers(root.getAsJsonArray("powers"));
            }
            if (root.has("icon") && (read = (ItemStack)CompatibilityDataTypes.ITEM_OR_ITEM_STACK.read(icon = root.get("icon"))) != null) {
                builder.icon(read);
            }
            JsonUtils.getOptional(root, "unchoosable", GsonHelper::m_13912_).ifPresent(builder::unchoosable);
            JsonUtils.getOptional(root, "order", GsonHelper::m_13927_).ifPresent(builder::order);
            JsonUtils.getOptional(root, "impact", GsonHelper::m_13927_).ifPresent(x -> {
                if (x < 0 || x >= Impact.values().length) {
                    throw new JsonParseException("Impact must be between 0 and " + (Impact.values().length - 1) + ", was " + x);
                }
                builder.impact(Impact.values()[x]);
            });
            JsonUtils.getOptional(root, "name", GsonHelper::m_13906_).ifPresent(builder::name);
            JsonUtils.getOptional(root, "description", GsonHelper::m_13906_).ifPresent(builder::description);
            builder.upgrades(JsonUtils.getOptionalList(root, "upgrades", (x, s) -> (OriginUpgrade)context.deserialize(x, OriginUpgrade.class)));
            JsonUtils.getOptional(root, "loading_priority", GsonHelper::m_13927_).ifPresent(builder::loadingOrder);
            return builder.build();
        }

        public JsonElement serialize(PartialOrigin src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject root = new JsonObject();
            DataResult powers = ConfiguredPower.CODEC_SET.set().encodeStart((DynamicOps)JsonOps.INSTANCE, src.powers());
            if (powers.result().isEmpty()) {
                throw new IllegalArgumentException("Failed to generate power list: " + ((DataResult.PartialResult)powers.error().orElseThrow()).message());
            }
            root.add("powers", (JsonElement)powers.result().get());
            if (src.icon() != null) {
                root.add("icon", CompatibilityDataTypes.ITEM_OR_ITEM_STACK.write((Object)src.icon()));
            }
            if (src.unchoosable() != null) {
                root.addProperty("unchoosable", src.unchoosable());
            }
            if (src.order() != null) {
                root.addProperty("order", (Number)src.order());
            }
            if (src.impact() != null) {
                root.addProperty("impact", (Number)src.impact().ordinal());
            }
            if (src.name() != null) {
                root.addProperty("name", src.name());
            }
            if (src.description() != null) {
                root.addProperty("description", src.description());
            }
            root.add("upgrades", (JsonElement)src.upgrades().stream().map(x -> context.serialize(x, OriginUpgrade.class)).collect(JsonUtils.toJsonArray()));
            if (src.loadingOrder() != 0) {
                root.addProperty("loading_priority", (Number)src.loadingOrder());
            }
            return root;
        }
    }
}

