/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins.mixin.forge;

import io.github.apace100.apoli.util.ApoliConfigs;
import io.github.edwinmindcraft.apoli.api.ApoliAPI;
import io.github.edwinmindcraft.apoli.api.power.configuration.ConfiguredPower;
import io.github.edwinmindcraft.apoli.api.power.factory.PowerFactory;
import io.github.edwinmindcraft.apoli.common.power.ModifyPlayerSpawnPower;
import io.github.edwinmindcraft.apoli.common.power.configuration.ModifyPlayerSpawnConfiguration;
import io.github.edwinmindcraft.apoli.common.registry.ApoliPowers;
import io.github.edwinmindcraft.apoli.common.util.SpawnLookupUtil;
import io.github.edwinmindcraft.origins.api.origin.IOriginCallbackPower;
import java.util.Set;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={ModifyPlayerSpawnPower.class})
public abstract class ModifyPlayerSpawnPowerMixin
implements IOriginCallbackPower<ModifyPlayerSpawnConfiguration> {
    @Shadow
    @Final
    private static Set<ServerPlayer> PLAYERS_TO_RESPAWN;

    @Shadow
    public abstract void teleportToModifiedSpawn(ConfiguredPower<?, ?> var1, Entity var2);

    @Shadow
    @Nullable
    public abstract Tuple<ResourceKey<ConfiguredPower<?, ?>>, Tuple<ServerLevel, Vec3>> getSpawn(ConfiguredPower<?, ?> var1, Entity var2, boolean var3);

    @Override
    public <F extends PowerFactory<ModifyPlayerSpawnConfiguration>> void onChosen(@NotNull ConfiguredPower<ModifyPlayerSpawnConfiguration, F> configuration, @NotNull Entity living, boolean isOrb) {
        if (configuration.getFactory() instanceof IOriginCallbackPower && !isOrb) {
            this.teleportToModifiedSpawn(configuration, living);
        }
    }

    @Override
    public <F extends PowerFactory<ModifyPlayerSpawnConfiguration>> boolean isReady(@NotNull ConfiguredPower<ModifyPlayerSpawnConfiguration, F> configuration, @NotNull Entity living, boolean isOrb) {
        return isOrb || (Boolean)ApoliConfigs.SERVER.separateSpawnFindingThread.get() == false || ApoliAPI.getPowers().m_7854_(configuration).map(SpawnLookupUtil::hasSpawnCached).orElse(true) != false;
    }

    @Override
    public <F extends PowerFactory<ModifyPlayerSpawnConfiguration>> void prepare(@NotNull ConfiguredPower<ModifyPlayerSpawnConfiguration, F> configuration, @NotNull Entity living, boolean isOrb) {
        ServerPlayer sp;
        if (((Boolean)ApoliConfigs.SERVER.separateSpawnFindingThread.get()).booleanValue() && configuration.getFactory() instanceof IOriginCallbackPower && living instanceof ServerPlayer && !PLAYERS_TO_RESPAWN.contains(sp = (ServerPlayer)living)) {
            this.getSpawn(configuration, living, false);
            ((ModifyPlayerSpawnPower)ApoliPowers.MODIFY_PLAYER_SPAWN.get()).schedulePlayerToSpawn(sp);
        }
    }
}

