/*
 * Decompiled with CFR 0.152.
 */
package dev.corgitaco.enhancedcelestials.api.lunarevent;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.util.Pair;
import corgitaco.corgilib.entity.condition.AnyCondition;
import corgitaco.corgilib.entity.condition.Condition;
import corgitaco.corgilib.entity.condition.FlipCondition;
import dev.corgitaco.enhancedcelestials.EnhancedCelestials;
import dev.corgitaco.enhancedcelestials.api.ECItemTags;
import dev.corgitaco.enhancedcelestials.api.EnhancedCelestialsRegistry;
import dev.corgitaco.enhancedcelestials.api.client.ColorSettings;
import dev.corgitaco.enhancedcelestials.api.lunarevent.DropSettings;
import dev.corgitaco.enhancedcelestials.api.lunarevent.LunarEvent;
import dev.corgitaco.enhancedcelestials.api.lunarevent.LunarMobSettings;
import dev.corgitaco.enhancedcelestials.api.lunarevent.LunarMobSpawnInfo;
import dev.corgitaco.enhancedcelestials.api.lunarevent.LunarTextComponents;
import dev.corgitaco.enhancedcelestials.api.lunarevent.MobEffectInstanceBuilder;
import dev.corgitaco.enhancedcelestials.api.lunarevent.client.LunarEventClientSettings;
import dev.corgitaco.enhancedcelestials.core.ECSounds;
import dev.corgitaco.enhancedcelestials.util.CustomTranslationTextComponent;
import it.unimi.dsi.fastutil.ints.IntArraySet;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.MobSpawnSettings;

public class DefaultLunarEvents {
    public static final Map<ResourceKey<LunarEvent>, LunarEventFactory> LUNAR_EVENT_FACTORIES = new Reference2ObjectOpenHashMap();
    public static final Collection<Integer> DEFAULT_PHASES = IntArraySet.of((int[])new int[]{0, 1, 2, 3, 4, 5, 6, 7});
    public static final Collection<Integer> DEFAULT_SUPER_MOON_PHASES = IntArraySet.of((int)0);
    public static final ResourceKey<LunarEvent> DEFAULT = DefaultLunarEvents.createEvent("default", () -> new LunarEvent((Map<ResourceKey<Level>, LunarEvent.SpawnRequirements>)ImmutableMap.of(), new LunarEventClientSettings(new ColorSettings("3333ff", "ffffff"), 20.0f, null, null), new LunarTextComponents(new CustomTranslationTextComponent("enhancedcelestials.name.moon", new CustomTranslationTextComponent[0]), Optional.empty(), Optional.empty()), LunarMobSettings.DEFAULT, DropSettings.EMPTY));
    public static final ResourceKey<LunarEvent> SUPER_MOON = DefaultLunarEvents.createEvent("super_moon", () -> new LunarEvent((Map<ResourceKey<Level>, LunarEvent.SpawnRequirements>)ImmutableMap.of((Object)Level.f_46428_, (Object)new LunarEvent.SpawnRequirements(0.05, 20, DEFAULT_SUPER_MOON_PHASES)), new LunarEventClientSettings(new ColorSettings("6766ff", "ffffff"), 40.0f, null, null), new LunarTextComponents(new CustomTranslationTextComponent("enhancedcelestials.name.super_moon", new CustomTranslationTextComponent[0]), new CustomTranslationTextComponent("enhancedcelestials.notification.super_moon.rise", new CustomTranslationTextComponent[0]), new CustomTranslationTextComponent("enhancedcelestials.notification.super_moon.set", new CustomTranslationTextComponent[0])), new LunarMobSettings((Map<MobCategory, Double>)ImmutableMap.of(), new LunarMobSpawnInfo(true, false, true, MobSpawnSettings.f_48326_), List.of(), (Condition)new FlipCondition((Condition)AnyCondition.INSTANCE)), DropSettings.EMPTY));
    public static final ResourceKey<LunarEvent> BLOOD_MOON = DefaultLunarEvents.createEvent("blood_moon", () -> new LunarEvent((Map<ResourceKey<Level>, LunarEvent.SpawnRequirements>)ImmutableMap.of((Object)Level.f_46428_, (Object)new LunarEvent.SpawnRequirements(0.1, 4, DEFAULT_PHASES)), new LunarEventClientSettings(new ColorSettings("990000", "990000"), 20.0f, null, ECSounds.BLOOD_MOON.get()), new LunarTextComponents(new CustomTranslationTextComponent("enhancedcelestials.name.blood_moon", Style.f_131099_.m_131157_(ChatFormatting.RED), new CustomTranslationTextComponent[0]), new CustomTranslationTextComponent("enhancedcelestials.notification.blood_moon.rise", Style.f_131099_.m_131157_(ChatFormatting.RED), new CustomTranslationTextComponent[0]), new CustomTranslationTextComponent("enhancedcelestials.notification.blood_moon.set", new CustomTranslationTextComponent[0])), new LunarMobSettings((Map<MobCategory, Double>)ImmutableMap.of((Object)MobCategory.MONSTER, (Object)2.25), new LunarMobSpawnInfo(true, true, false, MobSpawnSettings.f_48326_), List.of(), (Condition)AnyCondition.INSTANCE), DropSettings.EMPTY));
    public static final ResourceKey<LunarEvent> SUPER_BLOOD_MOON = DefaultLunarEvents.createEvent("super_blood_moon", () -> new LunarEvent((Map<ResourceKey<Level>, LunarEvent.SpawnRequirements>)ImmutableMap.of((Object)Level.f_46428_, (Object)new LunarEvent.SpawnRequirements(0.05, 20, DEFAULT_SUPER_MOON_PHASES)), new LunarEventClientSettings(new ColorSettings("FF0000", "FF0000"), 40.0f, null, ECSounds.BLOOD_MOON.get()), new LunarTextComponents(new CustomTranslationTextComponent("enhancedcelestials.name.super_blood_moon", Style.f_131099_.m_131157_(ChatFormatting.RED), new CustomTranslationTextComponent[0]), new CustomTranslationTextComponent("enhancedcelestials.notification.super_blood_moon.rise", Style.f_131099_.m_131157_(ChatFormatting.RED).m_131157_(ChatFormatting.BOLD), new CustomTranslationTextComponent[0]), new CustomTranslationTextComponent("enhancedcelestials.notification.blood_moon.set", new CustomTranslationTextComponent[0])), new LunarMobSettings((Map<MobCategory, Double>)ImmutableMap.of((Object)MobCategory.MONSTER, (Object)4.5), new LunarMobSpawnInfo(true, true, false, MobSpawnSettings.f_48326_), List.of(), (Condition)AnyCondition.INSTANCE), DropSettings.EMPTY));
    public static final ResourceKey<LunarEvent> HARVEST_MOON = DefaultLunarEvents.createEvent("harvest_moon", () -> new LunarEvent((Map<ResourceKey<Level>, LunarEvent.SpawnRequirements>)ImmutableMap.of((Object)Level.f_46428_, (Object)new LunarEvent.SpawnRequirements(0.1, 4, DEFAULT_PHASES)), new LunarEventClientSettings(new ColorSettings("99833b", "665828"), 20.0f, null, ECSounds.HARVEST_MOON.get()), new LunarTextComponents(new CustomTranslationTextComponent("enhancedcelestials.name.harvest_moon", Style.f_131099_.m_131157_(ChatFormatting.YELLOW), new CustomTranslationTextComponent[0]), new CustomTranslationTextComponent("enhancedcelestials.notification.harvest_moon.rise", Style.f_131099_.m_131157_(ChatFormatting.YELLOW), new CustomTranslationTextComponent[0]), new CustomTranslationTextComponent("enhancedcelestials.notification.harvest_moon.set", new CustomTranslationTextComponent[0])), LunarMobSettings.DEFAULT, new DropSettings((Map<TagKey<Item>, Double>)ImmutableMap.of(ECItemTags.HARVEST_MOON_CROPS, (Object)2.0))));
    public static final ResourceKey<LunarEvent> SUPER_HARVEST_MOON = DefaultLunarEvents.createEvent("super_harvest_moon", () -> new LunarEvent((Map<ResourceKey<Level>, LunarEvent.SpawnRequirements>)ImmutableMap.of((Object)Level.f_46428_, (Object)new LunarEvent.SpawnRequirements(0.05, 20, DEFAULT_SUPER_MOON_PHASES)), new LunarEventClientSettings(new ColorSettings("FFDB63", "FFDB63"), 40.0f, null, ECSounds.HARVEST_MOON.get()), new LunarTextComponents(new CustomTranslationTextComponent("enhancedcelestials.name.super_harvest_moon", Style.f_131099_.m_131157_(ChatFormatting.YELLOW), new CustomTranslationTextComponent[0]), new CustomTranslationTextComponent("enhancedcelestials.notification.super_harvest_moon.rise", Style.f_131099_.m_131157_(ChatFormatting.YELLOW).m_131157_(ChatFormatting.BOLD), new CustomTranslationTextComponent[0]), new CustomTranslationTextComponent("enhancedcelestials.notification.super_harvest_moon.set", new CustomTranslationTextComponent[0])), LunarMobSettings.DEFAULT, new DropSettings((Map<TagKey<Item>, Double>)ImmutableMap.of(ECItemTags.HARVEST_MOON_CROPS, (Object)4.0))));
    public static final ResourceKey<LunarEvent> BLUE_MOON = DefaultLunarEvents.createEvent("blue_moon", () -> new LunarEvent((Map<ResourceKey<Level>, LunarEvent.SpawnRequirements>)ImmutableMap.of((Object)Level.f_46428_, (Object)new LunarEvent.SpawnRequirements(0.1, 4, DEFAULT_PHASES)), new LunarEventClientSettings(new ColorSettings("009999", "009999"), 20.0f, null, ECSounds.BLUE_MOON.get()), new LunarTextComponents(new CustomTranslationTextComponent("enhancedcelestials.name.blue_moon", Style.f_131099_.m_131157_(ChatFormatting.AQUA), new CustomTranslationTextComponent[0]), new CustomTranslationTextComponent("enhancedcelestials.notification.blue_moon.rise", Style.f_131099_.m_131157_(ChatFormatting.AQUA), new CustomTranslationTextComponent[0]), new CustomTranslationTextComponent("enhancedcelestials.notification.blue_moon.set", new CustomTranslationTextComponent[0])), new LunarMobSettings((Map<MobCategory, Double>)ImmutableMap.of(), LunarMobSpawnInfo.DEFAULT, List.of(Pair.of((Object)AnyCondition.INSTANCE, (Object)new MobEffectInstanceBuilder(MobEffects.f_19621_, 1210, 0, true, false, false))), (Condition)new FlipCondition((Condition)AnyCondition.INSTANCE)), DropSettings.EMPTY));
    public static final ResourceKey<LunarEvent> SUPER_BLUE_MOON = DefaultLunarEvents.createEvent("super_blue_moon", () -> new LunarEvent((Map<ResourceKey<Level>, LunarEvent.SpawnRequirements>)ImmutableMap.of((Object)Level.f_46428_, (Object)new LunarEvent.SpawnRequirements(0.05, 20, DEFAULT_SUPER_MOON_PHASES)), new LunarEventClientSettings(new ColorSettings("00ffff", "00ffff"), 40.0f, null, ECSounds.BLUE_MOON.get()), new LunarTextComponents(new CustomTranslationTextComponent("enhancedcelestials.name.super_blue_moon", Style.f_131099_.m_131157_(ChatFormatting.AQUA), new CustomTranslationTextComponent[0]), new CustomTranslationTextComponent("enhancedcelestials.notification.super_blue_moon.rise", Style.f_131099_.m_131157_(ChatFormatting.AQUA), new CustomTranslationTextComponent[0]), new CustomTranslationTextComponent("enhancedcelestials.notification.super_blue_moon.set", new CustomTranslationTextComponent[0])), new LunarMobSettings((Map<MobCategory, Double>)ImmutableMap.of(), LunarMobSpawnInfo.DEFAULT, List.of(Pair.of((Object)AnyCondition.INSTANCE, (Object)new MobEffectInstanceBuilder(MobEffects.f_19621_, 1210, 4, true, false, false))), (Condition)new FlipCondition((Condition)AnyCondition.INSTANCE)), DropSettings.EMPTY));

    public static ResourceKey<LunarEvent> createEvent(String id, Supplier<LunarEvent> event) {
        ResourceKey lunarEventResourceKey = ResourceKey.m_135785_(EnhancedCelestialsRegistry.LUNAR_EVENT_KEY, (ResourceLocation)EnhancedCelestials.createLocation(id));
        LUNAR_EVENT_FACTORIES.put((ResourceKey<LunarEvent>)lunarEventResourceKey, placedFeatureHolderGetter -> (LunarEvent)event.get());
        return lunarEventResourceKey;
    }

    public static void loadClass() {
    }

    @FunctionalInterface
    public static interface LunarEventFactory {
        public LunarEvent generate(BootstapContext<LunarEvent> var1);
    }
}

