/*
 * Decompiled with CFR 0.152.
 */
package dev.obscuria.caravans.content;

import java.util.List;
import net.minecraft.util.RandomSource;
import org.jetbrains.annotations.Nullable;

public interface IWeighted {
    public int weight();

    @Nullable
    public static <T extends IWeighted> T pickRandom(List<T> elements, RandomSource random) {
        if (elements.isEmpty()) {
            return null;
        }
        int totalWeight = 0;
        for (IWeighted element : elements) {
            totalWeight += element.weight();
        }
        if (totalWeight <= 0) {
            return null;
        }
        int roll = random.m_188503_(totalWeight);
        for (IWeighted element : elements) {
            if ((roll -= element.weight()) >= 0) continue;
            return (T)element;
        }
        return null;
    }
}

